/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.ds;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.platform.core.connector.ConnectionFactory;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.util.connector.Response;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscx.platform.core.res.meta.ds.AbstractDataBatchConsumerApplication;
import kd.isc.iscx.platform.core.res.meta.ds.EntityLoad;
import kd.isc.iscx.platform.core.res.runtime.Connector;
import kd.isc.iscx.platform.core.res.runtime.job.AbstractBatchApplication;
import kd.isc.iscx.platform.core.res.runtime.job.DataStream;
import kd.isc.iscx.platform.core.res.runtime.util.Util;

class EntityBatchLoadApplication
extends AbstractDataBatchConsumerApplication {
    private EntityLoad entityLoad;

    EntityBatchLoadApplication(Connector connector, EntityLoad entityLoad, int batchSize) {
        super(connector, entityLoad, batchSize);
        this.entityLoad = entityLoad;
    }

    @Override
    public void doBatch(DataStream stream, ConnectionWrapper cn, List<AbstractBatchApplication.Data> batch) {
        Map<String, Object> fieldMap = this.entityLoad.getFieldMap();
        List<Map<String, Object>> filterDataList = this.filterData(batch, fieldMap);
        HashMap<String, Object> emptyMap = new HashMap<String, Object>(0);
        String proxyUser = this.entityLoad.evalProxyUser(emptyMap);
        Map<String, Object> evalOperationOptions = this.entityLoad.evalOperationOptions(emptyMap);
        String operation = this.entityLoad.getOperation();
        Map<String, Object> paramMap = this.makeParamMap(evalOperationOptions, operation);
        ConnectionFactory factory = cn.getFactory();
        List responses = factory.doBatchBizAction(cn, this.entityLoad.getEntityNumber(), filterDataList, this.pk.getName(), this.entityLoad.getJudgeFields(), operation, paramMap, proxyUser);
        this.outputResult(batch, responses);
    }

    private Map<String, Object> makeParamMap(Map<String, Object> evalOperationOptions, String operation) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(1);
        paramMap.put(operation, evalOperationOptions);
        return paramMap;
    }

    private void outputResult(List<AbstractBatchApplication.Data> batch, List<Response> responses) {
        for (int i = 0; i < responses.size(); ++i) {
            AbstractBatchApplication.Data data = batch.get(i);
            Response res = responses.get(i);
            Map<String, Object> output = data.getOutput();
            output.put("id", res.getId());
            output.put("type", D.s((Object)res.getType()));
            output.put("message", res.getErrorMessage());
        }
    }

    private List<Map<String, Object>> filterData(List<AbstractBatchApplication.Data> batch, Map<String, Object> fieldMap) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(batch.size());
        for (AbstractBatchApplication.Data data : batch) {
            result.add(Util.filter(data.getInput(), fieldMap));
        }
        return result;
    }
}

