/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.ds;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.util.connector.TableAction;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.NodeBuilder;
import kd.isc.iscb.util.flow.core.plugin.Application;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscx.platform.core.res.ResourceType;
import kd.isc.iscx.platform.core.res.meta.Resource;
import kd.isc.iscx.platform.core.res.meta.ds.AbstractDataConsumer;
import kd.isc.iscx.platform.core.res.meta.ds.EntityBatchLoadApplication;
import kd.isc.iscx.platform.core.res.meta.ds.EntityLoadApplication;
import kd.isc.iscx.platform.core.res.runtime.BatchSupportable;
import kd.isc.iscx.platform.core.res.runtime.Connector;
import kd.isc.iscx.platform.core.res.runtime.trigger.VariableGetter;
import kd.isc.iscx.platform.core.res.runtime.util.Util;

public class EntityLoad
extends AbstractDataConsumer
implements BatchSupportable {
    private int batchSize;
    private String operation;
    private String entityNumber;
    private Map<String, List<String>> judgeFields;
    private Map<String, Object> fieldMap;
    private VariableGetter proxyUserGetter;
    private Map<String, VariableGetter> operationOptionMap;

    protected EntityLoad(long id, String number, String name, ResourceType resourceType, Map<String, Object> details) {
        super(id, number, name, resourceType, details);
        Map entity = (Map)details.get("input");
        this.entityNumber = D.s(entity.get("number"));
        this.batchSize = D.i((Object)details.get("batch_size"));
        String proxyUserStr = D.s((Object)details.get("proxy_user"));
        this.proxyUserGetter = new VariableGetter(proxyUserStr);
        String operationOptions = D.s((Object)details.get("operation_options"));
        this.initOperationOptionMap(operationOptions);
        this.operation = this.initOperationName(D.s((Object)details.get("operation")));
        List fields = (List)details.get("fields");
        this.fieldMap = Collections.unmodifiableMap(Util.initRequiresMap(fields));
        this.judgeFields = Collections.unmodifiableMap(Util.initJudgeFields(fields));
    }

    private String initOperationName(String operation) {
        return operation != null ? operation : TableAction._SAVE.name();
    }

    private void initOperationOptionMap(String operationOptions) {
        HashMap optionMap = new HashMap(1);
        if (operationOptions != null) {
            Map map = (Map)Script.parseJson((String)operationOptions);
            for (Map.Entry entry : map.entrySet()) {
                optionMap.put(entry.getKey(), new VariableGetter(D.s(entry.getValue())));
            }
        }
        this.operationOptionMap = Collections.unmodifiableMap(optionMap);
    }

    @Override
    protected void build(NodeBuilder node, Map<String, Object> details, Connector $tar, boolean batchMode) {
        if (batchMode) {
            this.checkProxyUserAndOperationOptions();
            node.biz((Application)new EntityBatchLoadApplication($tar, this, this.batchSize), WAIT_FOR_BATCH_TASK);
        } else {
            node.biz((Application)new EntityLoadApplication($tar, this));
        }
    }

    @Override
    public Object getDataConsumerApplication(Connector $tar) {
        if (this.batchSize > 1) {
            return new EntityBatchLoadApplication($tar, this, this.batchSize);
        }
        return new EntityLoadApplication($tar, this);
    }

    private void checkProxyUserAndOperationOptions() {
        if (this.proxyUserGetter.isDynamic()) {
            throw new IscBizException(ResManager.loadKDString((String)"\u5b9e\u4f53\u6279\u91cf\u64cd\u4f5c\u4e0d\u652f\u6301\u8bbe\u7f6e\u52a8\u6001\u4ee3\u7406\u7528\u6237", (String)"EntityLoad_0", (String)"isc-iscx-platform-core", (Object[])new Object[0]));
        }
        if (!CollectionUtils.isEmpty(this.operationOptionMap)) {
            Collection<VariableGetter> variableGetters = this.operationOptionMap.values();
            for (VariableGetter variableGetter : variableGetters) {
                if (!variableGetter.isDynamic()) continue;
                throw new IscBizException(ResManager.loadKDString((String)"\u5b9e\u4f53\u6279\u91cf\u64cd\u4f5c\u4e0d\u652f\u6301\u8bbe\u7f6e\u52a8\u6001\u53c2\u6570", (String)"EntityLoad_1", (String)"isc-iscx-platform-core", (Object[])new Object[0]));
            }
        }
    }

    public Map<String, Object> evalOperationOptions(Map<String, Object> data) {
        HashMap<String, Object> params = new HashMap<String, Object>(this.operationOptionMap.size());
        for (Map.Entry<String, VariableGetter> entry : this.operationOptionMap.entrySet()) {
            params.put(entry.getKey(), entry.getValue().eval(data));
        }
        return params;
    }

    public String evalProxyUser(Map<String, Object> data) {
        return D.s((Object)this.proxyUserGetter.eval(data));
    }

    private void checkBizBatchAction(Connector c) {
        try (ConnectionWrapper cn = c.getConnection();){
            if (!cn.getFactory().supportsBizBatchAction(cn)) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8fde\u63a5\u5668\uff08%s\uff09\u4e0d\u652f\u6301\u5b9e\u4f53\u6279\u91cf\u64cd\u4f5c\uff0c\u8bf7\u8c03\u6574\u6279\u91cf\u5927\u5c0f\u503c\u4e0d\u5927\u4e8e1\u3002", (String)"EntityLoad_4", (String)"isc-iscx-platform-core", (Object[])new Object[0]), cn.getConfig().get("name")));
            }
        }
    }

    @Override
    public boolean isBatchMode() {
        return this.batchSize > 1;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public VariableGetter getProxyUserGetter() {
        return this.proxyUserGetter;
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public String getOperation() {
        return this.operation;
    }

    public Map<String, VariableGetter> getOperationOptionMap() {
        return this.operationOptionMap;
    }

    public Map<String, List<String>> getJudgeFields() {
        return this.judgeFields;
    }

    public Map<String, Object> getFieldMap() {
        return this.fieldMap;
    }

    public static final class EntityLoadParser
    extends ResourceType {
        public EntityLoadParser(String number, String formId) {
            super(number, formId);
        }

        @Override
        public Resource parse(long id, String number, String name, Map<String, Object> details) {
            return new EntityLoad(id, number, name, this, details);
        }

        @Override
        public boolean isExtensible() {
            return true;
        }
    }
}

