/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.ds;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.platform.core.cache.CacheableObjectManager;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.flow.core.NodeBuilder;
import kd.isc.iscb.util.flow.core.plugin.Application;
import kd.isc.iscb.util.format.Format;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscx.platform.core.res.ResourceType;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.Resource;
import kd.isc.iscx.platform.core.res.meta.SystemInfo;
import kd.isc.iscx.platform.core.res.meta.dm.AbstractDataModel;
import kd.isc.iscx.platform.core.res.meta.ds.NoticeSendApplication;
import kd.isc.iscx.platform.core.res.runtime.Connector;
import kd.isc.iscx.platform.core.res.runtime.DataHandler;

public final class NoticeSend
extends Resource
implements DataHandler {
    private AbstractDataModel data_model;
    private List<Long> ierp_user_list;
    private Script ierp_user_expr;
    private List<String> external_user_list;
    private Script external_user_expr;
    private Format header;
    private Format content;

    protected NoticeSend(long id, String number, String name, ResourceType resourceType, Map<String, Object> details) {
        super(id, number, name, resourceType, details);
        Object input = ResourceUtil.getValue(details, "data_model", "id");
        this.data_model = (AbstractDataModel)CacheableObjectManager.get(Resource.class, (Long)D.l(input));
        this.header = Format.parse((String)D.s((Object)details.get("header")), new HashMap());
        this.content = Format.parse((String)D.s((Object)details.get("content")), new HashMap());
        this.ierp_user_list = this.parseIerpUserList(details);
        this.ierp_user_expr = Script.compileSimpleScript((String)D.s((Object)details.get("ierp_user_expr")));
        this.external_user_list = this.parseExternalUserList(details);
        this.external_user_expr = Script.compileSimpleScript((String)D.s((Object)details.get("external_user_expr")));
    }

    private List<String> parseExternalUserList(Map<String, Object> details) {
        String external_user_list = D.s((Object)details.get("external_user_list"));
        if (external_user_list != null) {
            ArrayList<String> mobiles = new ArrayList<String>();
            for (String p : external_user_list.split(";")) {
                if (p == null || p.indexOf(44) <= 0) continue;
                String[] item = p.split(",");
                mobiles.add(item[1]);
            }
            return Collections.unmodifiableList(mobiles);
        }
        return Collections.emptyList();
    }

    private List<Long> parseIerpUserList(Map<String, Object> details) {
        List users = (List)details.get("ierp_user_json");
        if (users != null) {
            ArrayList<Long> userIds = new ArrayList<Long>(users.size());
            for (Map u : users) {
                userIds.add(D.l(u.get("key")));
            }
            return Collections.unmodifiableList(userIds);
        }
        return Collections.emptyList();
    }

    public Format getContent() {
        return this.content;
    }

    public Format getHeader() {
        return this.header;
    }

    public AbstractDataModel getDataModel() {
        return this.data_model;
    }

    public Script getExternalUserExpr() {
        return this.external_user_expr;
    }

    public List<String> getExternalUserList() {
        return this.external_user_list;
    }

    public Script getIerpUserExpr() {
        return this.ierp_user_expr;
    }

    public List<Long> getIerpUserList() {
        return this.ierp_user_list;
    }

    @Override
    public void build(NodeBuilder node, Map<String, Object> details, Map<String, Connector> connectors, boolean batchMode) {
        node.biz((Application)new NoticeSendApplication(this));
    }

    @Override
    public boolean isFiberTerminal() {
        return false;
    }

    @Override
    public List<SystemInfo> requiredConnectors() {
        return Collections.emptyList();
    }

    @Override
    public AbstractDataModel getInput() {
        return this.data_model;
    }

    @Override
    public AbstractDataModel getOutput() {
        return this.data_model;
    }

    public void send(Map<String, Object> ctx, NoticeType type) {
        NoticeSendApplication.sendNotice(this, ctx, type);
    }

    public static enum NoticeType {
        message,
        warning;

    }

    public static class NoticeSendParser
    extends ResourceType {
        public NoticeSendParser(String number, String formId) {
            super(number, formId);
        }

        @Override
        public boolean isExtensible() {
            return true;
        }

        @Override
        public Resource parse(long id, String number, String name, Map<String, Object> details) {
            return new NoticeSend(id, number, name, this, details);
        }
    }
}

