/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.ds;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.message.api.ShortMessageInfo;
import kd.bos.servicehelper.message.MessageServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.flow.core.VariableScope;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscx.platform.core.res.meta.ds.NoticeSend;
import kd.isc.iscx.platform.core.res.runtime.job.AbstractDataApplication;
import kd.isc.iscx.platform.core.res.runtime.job.task.DataTaskUtil;

class NoticeSendApplication
extends AbstractDataApplication {
    private NoticeSend res;

    NoticeSendApplication(NoticeSend res) {
        super(res);
        this.res = res;
    }

    @Override
    public void compile(VariableScope scope) {
    }

    @Override
    protected Map<String, Object> invoke(Execution e, Map<String, Object> data) {
        Map<String, Object> ctx = NoticeSendApplication.createContext(e, data);
        NoticeSendApplication.sendNotice(this.res, ctx, NoticeSend.NoticeType.message);
        return data;
    }

    public static void sendNotice(NoticeSend res, Map<String, Object> ctx, NoticeSend.NoticeType type) {
        String header = res.getHeader().translate(ctx);
        String content = res.getContent().translate(ctx);
        List<Long> ierpUsers = NoticeSendApplication.calcIerpUserList(res, ctx);
        List<String> mobile_phones = NoticeSendApplication.calcMobilePhones(res, ctx);
        NoticeSendApplication.sendIerpMessage(ierpUsers, header, content, type);
        NoticeSendApplication.sendMobileMessage(mobile_phones, header, content);
    }

    private static void sendMobileMessage(List<String> mobile_phones, String header, String content) {
        ShortMessageInfo shortMessageInfo = new ShortMessageInfo();
        shortMessageInfo.setMessage(StringUtil.trim((String)(content.length() == 0 ? header : content), (int)400));
        shortMessageInfo.setPhone(mobile_phones);
        MessageServiceHelper.sendShortMessage((ShortMessageInfo)shortMessageInfo);
    }

    private static List<String> calcMobilePhones(NoticeSend res, Map<String, Object> ctx) {
        ArrayList<String> mobile_phones = new ArrayList<String>(res.getExternalUserList());
        Object users = res.getExternalUserExpr().eval(ctx);
        if (users instanceof List) {
            for (Object o : (List)users) {
                mobile_phones.add(D.s(o));
            }
        } else if (users != null) {
            mobile_phones.add(D.s((Object)users));
        }
        return mobile_phones;
    }

    private static void sendIerpMessage(List<Long> ierpUsers, String header, String content, NoticeSend.NoticeType type) {
        if (!ierpUsers.isEmpty()) {
            MessageInfo messageInfo = new MessageInfo();
            messageInfo.setType(type.name());
            messageInfo.setUserIds(ierpUsers);
            messageInfo.setTag(ResManager.loadKDString((String)"\u96c6\u6210\u4e91\u00b7\u6570\u636e\u6d41", (String)"NoticeSendApplication_0", (String)"isc-iscx-platform-core", (Object[])new Object[0]));
            messageInfo.setTitle(header);
            messageInfo.setContent(content);
            messageInfo.setContent(StringUtil.trim((String)content, (int)1000));
            MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
        }
    }

    private static List<Long> calcIerpUserList(NoticeSend res, Map<String, Object> ctx) {
        Object users = res.getIerpUserExpr().eval(ctx);
        ArrayList<Long> ierpUsers = new ArrayList<Long>(res.getIerpUserList());
        if (users instanceof List) {
            for (Object o : (List)users) {
                ierpUsers.add(D.l(o));
            }
        } else if (users != null) {
            ierpUsers.add(D.l((Object)users));
        }
        return ierpUsers;
    }

    private static Map<String, Object> createContext(Execution e, Map<String, Object> data) {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("$data", Collections.unmodifiableMap(data));
        DataTaskUtil.appendStreamContext(e, ctx);
        return ctx;
    }
}

