/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.dt;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.db.DataTypeUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.dt.DataTypes;
import kd.isc.iscx.platform.core.res.meta.dt.EnumSchema;
import kd.isc.iscx.platform.core.res.meta.dt.MultiLangStringTypeX;
import kd.isc.iscx.platform.core.res.meta.dt.RefSchema;
import kd.isc.iscx.platform.core.res.meta.dt.StructSchema;

public final class DataTypeParser {
    public static DataType get(Map<String, Object> field) {
        String type = D.s((Object)field.get("data_type"));
        if (type != null) {
            return DataTypeParser.parse(type, field);
        }
        throw new IllegalArgumentException(ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u6570\u636e\u7c7b\u578b\u3002\u89e3\u51b3\u65b9\u6cd5\uff1a\u4ee5\u201ctype\u201d\u4e3aKey\u6307\u5b9a\u6570\u636e\u7c7b\u578b\u3002", (String)"DataTypeParser_0", (String)"isc-iscx-platform-core", (Object[])new Object[0]));
    }

    private static DataType parse(String type, Map<String, Object> field) {
        DataType t = DataTypeParser.get(type, field);
        if (D.x((Object)field.get("is_multiple"))) {
            return DataTypes.listType((DataType)t);
        }
        return t;
    }

    private static DataType get(String type, Map<String, Object> field) {
        switch (type) {
            case "string": 
            case "varchar": {
                return DataTypes.STRING2;
            }
            case "int": 
            case "integer": {
                return DataTypes.INTEGER;
            }
            case "datetime": 
            case "timestamp": {
                return DataTypes.DATETIME;
            }
            case "boolean": 
            case "bit": {
                return DataTypes.BOOLEAN;
            }
            case "decimal": {
                return DataTypes.DECIMAL;
            }
            case "date": {
                return DataTypes.DATE;
            }
            case "time": {
                return DataTypes.TIME;
            }
            case "long": 
            case "bigint": {
                return DataTypes.LONG;
            }
            case "ml_string": {
                return MultiLangStringTypeX.INS;
            }
            case "double": 
            case "float": {
                return DataTypeUtil.DOUBLE_TYPE;
            }
            case "ENUM": {
                return new EnumSchema(field);
            }
            case "REF": 
            case "REF(?)": {
                return new RefSchema(field);
            }
            case "ENTRIES": 
            case "STRUCT": {
                return new StructSchema(field);
            }
            case "varbinary": 
            case "binary": 
            case "blob": {
                return DataTypes.BINARY;
            }
            case "unknown": {
                return DataTypes.UNKNOWN;
            }
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u662f\u975e\u6cd5\u7684\u6570\u636e\u7c7b\u578b\u3002", (String)"DataTypeParser_2", (String)"isc-iscx-platform-core", (Object[])new Object[0]), type));
    }
}

