/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.dt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.dt.ListType;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.dt.Field;
import kd.isc.iscx.platform.core.res.meta.dt.MultiLangStringTypeX;
import kd.isc.iscx.platform.core.res.meta.dt.RefSchema;
import kd.isc.iscx.platform.core.res.meta.dt.StructValue;

public class StructSchema
implements DataType {
    private List<Field> fields;
    private List<Field> pk_fields;
    private Map<String, Field> mapping;
    private Field primaryKey;

    public StructSchema(Map<String, Object> field) {
        List list = (List)field.get("fields");
        if (list == null || list.isEmpty()) {
            this.fields = Collections.emptyList();
            this.mapping = Collections.emptyMap();
            this.primaryKey = null;
        } else {
            ArrayList<Field> fields = new ArrayList<Field>(list.size());
            HashMap<String, Field> mapping = new HashMap<String, Field>(list.size());
            this.initFieldMapping(list, fields, mapping);
            this.checkDuplicatedFields(fields, mapping);
            this.primaryKey = this.findPrimaryKey(fields);
            this.mapping = mapping;
            this.fields = Collections.unmodifiableList(fields);
        }
    }

    public StructSchema(List<Field> fields) {
        HashMap<String, Field> mapping = new HashMap<String, Field>(fields.size());
        this.initFieldMapping(fields, mapping);
        this.checkDuplicatedFields(fields, mapping);
        this.primaryKey = this.findPrimaryKey(fields);
        this.mapping = mapping;
        this.fields = Collections.unmodifiableList(fields);
    }

    private Field findPrimaryKey(List<Field> fields) {
        ArrayList<Field> pks = new ArrayList<Field>(3);
        for (Field f : fields) {
            if (!f.isPrimaryKey()) continue;
            pks.add(f);
        }
        this.pk_fields = Collections.unmodifiableList(pks);
        if (pks.size() == 1) {
            return (Field)pks.get(0);
        }
        return null;
    }

    private void checkDuplicatedFields(List<Field> fields, Map<String, Field> mapping) {
        if (mapping.size() != fields.size()) {
            throw new IscBizException(ResManager.loadKDString((String)"\u5b57\u6bb5\u5217\u8868\u4e2d\u5b58\u5728\u91cd\u590d\u5b57\u6bb5\u3002", (String)"StructSchema_0", (String)"isc-iscx-platform-core", (Object[])new Object[0]));
        }
    }

    private void initFieldMapping(List<Map<String, Object>> list, List<Field> fields, Map<String, Field> mapping) {
        for (Map<String, Object> item : list) {
            Field f = new Field(item);
            fields.add(f);
            mapping.put(f.getName(), f);
        }
    }

    private void initFieldMapping(List<Field> fields, Map<String, Field> mapping) {
        for (Field f : fields) {
            mapping.put(f.getName(), f);
        }
    }

    public List<Field> getPrimaryKeyFields() {
        return this.pk_fields;
    }

    public Field getPrimaryKey() {
        return this.primaryKey;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public int fieldCount() {
        return this.fields.size();
    }

    public Field getField(int index) {
        return this.fields.get(index);
    }

    public Field findField(String name) {
        return this.recursionFindField(name, this.mapping);
    }

    private Field recursionFindField(String name, Map<String, Field> fieldsMapping) {
        String[] fs = name.split("\\.");
        if (fs.length == 1) {
            return fieldsMapping.get(name);
        }
        Field f = fieldsMapping.get(fs[0]);
        if (f == null) {
            return null;
        }
        Map<String, Field> mapping = null;
        if (f.isMultiple()) {
            ListType children = (ListType)f.getType();
            mapping = this.getChildrenFields(children.getElementType());
        } else {
            mapping = this.getChildrenFields(f.getType());
        }
        String suffixName = name.substring(name.indexOf(46) + 1);
        return this.recursionFindField(suffixName, mapping);
    }

    private Map<String, Field> getChildrenFields(DataType type) {
        List<Object> fieldList = new ArrayList();
        if (type instanceof StructSchema) {
            fieldList = ((StructSchema)type).getFields();
        } else if (type instanceof RefSchema) {
            fieldList = ((RefSchema)type).getEntity().getFields();
        } else if (type instanceof MultiLangStringTypeX) {
            for (Map<String, Object> map : ResourceUtil.buildMultiStringFieldMap()) {
                fieldList.add(new Field(map));
            }
        }
        HashMap<String, Field> result = new HashMap<String, Field>(fieldList.size());
        for (Field field : fieldList) {
            result.put(field.getName(), field);
        }
        return result;
    }

    public Field getField(String name) {
        return this.mapping.get(name);
    }

    public boolean containsField(String name) {
        return this.mapping.containsKey(name);
    }

    public Map<String, Field> queryEntriesKey() {
        HashMap<String, Field> entriesGroup = new HashMap<String, Field>(8);
        this.queryEntriesKey(entriesGroup, this.fields, "");
        return entriesGroup;
    }

    private void queryEntriesKey(Map<String, Field> entriesGroup, List<Field> fields, String prefix) {
        for (Field field : fields) {
            if (!field.isEntriesType()) continue;
            String fullname = prefix + field.getName();
            entriesGroup.put(fullname, field);
            ListType children = (ListType)field.getType();
            List<Field> childrenFieldList = ((StructSchema)children.getElementType()).getFields();
            this.queryEntriesKey(entriesGroup, childrenFieldList, fullname + '.');
        }
    }

    public StructValue narrow(Object outerValue) {
        if (outerValue == null) {
            return null;
        }
        if (outerValue instanceof Map) {
            StructValue struct = new StructValue(this);
            for (Map.Entry e : ((Map)outerValue).entrySet()) {
                struct.put((String)e.getKey(), e.getValue());
            }
            return struct;
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8f93\u5165\u5bf9\u8c61\u7684\u7c7b\u578b\u662f\u201c%s\u201d\uff0c\u4e0d\u80fd\u4f5c\u4e3a\u201c\u7ed3\u6784\u201d\u7684\u8d4b\u503c\u3002", (String)"StructSchema_3", (String)"isc-iscx-platform-core", (Object[])new Object[0]), outerValue.getClass().getName()));
    }

    public Object forSave(Object innerValue) {
        throw new UnsupportedOperationException();
    }

    public Object forJson(Object object) {
        return object;
    }

    public String toString() {
        return "STRUCT";
    }
}

