/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.dw;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.cache.CacheableObjectManager;
import kd.isc.iscb.util.dt.AbstractCollectionDataType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.flow.core.Event;
import kd.isc.iscb.util.flow.core.NodeBuilder;
import kd.isc.iscb.util.flow.core.plugin.Application;
import kd.isc.iscb.util.flow.core.plugin.Listener;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscb.util.script.util.Numeric;
import kd.isc.iscb.util.script.util.Symbol;
import kd.isc.iscx.platform.core.res.ResourceType;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.Resource;
import kd.isc.iscx.platform.core.res.meta.SystemInfo;
import kd.isc.iscx.platform.core.res.meta.dm.AbstractDataModel;
import kd.isc.iscx.platform.core.res.meta.dt.Field;
import kd.isc.iscx.platform.core.res.meta.dt.RefSchema;
import kd.isc.iscx.platform.core.res.meta.dt.StructSchema;
import kd.isc.iscx.platform.core.res.meta.dw.DataCompareApplication;
import kd.isc.iscx.platform.core.res.meta.dw.DataCompareUtil;
import kd.isc.iscx.platform.core.res.meta.dw.DataCompareXApplication;
import kd.isc.iscx.platform.core.res.runtime.BatchSupportable;
import kd.isc.iscx.platform.core.res.runtime.Connector;
import kd.isc.iscx.platform.core.res.runtime.DataHandler;
import kd.isc.iscx.platform.core.res.runtime.job.StopOnIgnored;
import kd.isc.iscx.platform.core.res.runtime.util.Util;

public class DataCompare
extends Resource
implements DataHandler,
BatchSupportable {
    private AbstractDataModel input;
    private AbstractDataModel output;
    private int batchSize;
    private Map<String, List<String>> judgeFields;
    private Map<String, Object> comparedFieldsMap;
    private Map<String, Object> queryFieldsMap;
    private String abort_fiber_when;
    private Map<String, Object> diff_limits;

    private DataCompare(long id, String number, String name, ResourceType resourceType, Map<String, Object> details) {
        super(id, number, name, resourceType, details);
        long input = D.l(ResourceUtil.getValue(details, "input", "id"));
        long output = D.l(ResourceUtil.getValue(details, "output", "id"));
        this.input = (AbstractDataModel)CacheableObjectManager.get(Resource.class, (Long)input);
        this.output = (AbstractDataModel)CacheableObjectManager.get(Resource.class, (Long)output);
        List fields = (List)details.get("fields");
        this.diff_limits = this.initDiffLimits(fields);
        this.comparedFieldsMap = Util.initRequiresMap(fields);
        this.queryFieldsMap = Util.initRequiresMap(fields);
        for (Field f : this.input.getDataType().getPrimaryKeyFields()) {
            this.queryFieldsMap.put(f.getName(), 1);
        }
        this.judgeFields = Util.initJudgeFields(fields);
        this.batchSize = D.i((Object)details.get("batch_size"));
        this.abort_fiber_when = StringUtil.trim((String)((String)details.get("abort_fiber_when")), (String)"");
    }

    private Map<String, Object> initDiffLimits(List<Map<String, Object>> fields) {
        HashMap<String, Object> diff_limits = new HashMap<String, Object>(4);
        for (Map<String, Object> field : fields) {
            String diff_limit = D.s((Object)field.get("diff_limit"));
            if (diff_limit == null) continue;
            String[] path = D.s((Object)field.get("field_name")).split("\\.");
            String lastKey = path[path.length - 1];
            this.getMap(diff_limits, path).put(lastKey, this.parseDiffLimit(diff_limit));
        }
        return diff_limits;
    }

    private Object parseDiffLimit(String diff_limit) {
        if (this.isNumber(diff_limit)) {
            return Numeric.parse((String)diff_limit);
        }
        Script script = Script.compileSimpleScript((String)diff_limit);
        if (script.getProgram().isPredicate()) {
            return script;
        }
        throw new IllegalArgumentException("'" + diff_limit + "' is invalid expr.");
    }

    private boolean isNumber(String diff_limit) {
        int j = diff_limit.length();
        for (int i = 0; i < j; ++i) {
            char c = diff_limit.charAt(i);
            if (Symbol.isNumber((int)c)) continue;
            return false;
        }
        return true;
    }

    private Map<String, Object> getMap(Map<String, Object> map, String[] path) {
        for (int i = 0; i < path.length - 1; ++i) {
            HashMap value = map.get(path[i]);
            if (value instanceof Map) {
                map = value;
                continue;
            }
            value = new HashMap(4);
            map.put(path[i], value);
            map = value;
        }
        return map;
    }

    public Map<String, Object> getDiffLimits() {
        return this.diff_limits;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public Map<String, Object> getComparedFieldsMap() {
        return this.comparedFieldsMap;
    }

    public Map<String, Object> getQueryFieldsMap() {
        return this.queryFieldsMap;
    }

    public Map<String, List<String>> getJudgeFields() {
        return this.judgeFields;
    }

    public boolean shouldStopFiber(String state) {
        if (this.abort_fiber_when.equals(state)) {
            return true;
        }
        int i = this.abort_fiber_when.indexOf(state);
        if (i < 0) {
            return false;
        }
        if (i == 0) {
            return true;
        }
        return this.abort_fiber_when.charAt(i - 1) == '+';
    }

    @Override
    public boolean isFiberTerminal() {
        return false;
    }

    @Override
    public List<SystemInfo> requiredConnectors() {
        return Collections.singletonList(new SystemInfo("$tar", this.getScopeName(), ResManager.loadKDString((String)"\u76ee\u6807\u7cfb\u7edf", (String)"AbstractDataConsumer_2", (String)"isc-iscx-platform-core", (Object[])new Object[0])));
    }

    @Override
    public AbstractDataModel getInput() {
        return this.input;
    }

    @Override
    public AbstractDataModel getOutput() {
        return this.output;
    }

    @Override
    public boolean isBatchMode() {
        return this.batchSize > 1;
    }

    public Object getDiffLimit(List<DataCompareUtil.Item> parentFields, String field) {
        Map diff_limits = this.diff_limits;
        for (DataCompareUtil.Item parent : parentFields) {
            if ((diff_limits = (Map)diff_limits.get(parent.getField())) != null) continue;
            return null;
        }
        return diff_limits.get(field);
    }

    @Override
    public void build(NodeBuilder node, Map<String, Object> details, Map<String, Connector> connectors, boolean batchMode) {
        Connector $tar = connectors.get("$tar");
        if (batchMode) {
            node.biz((Application)new DataCompareXApplication(this, $tar), WAIT_FOR_BATCH_TASK);
        } else {
            node.biz((Application)new DataCompareApplication(this, $tar));
        }
        node.listener(Event.ON_APP_COMPLETED, (Listener)new StopOnIgnored(this.getOutput()));
    }

    public StructSchema getStructSchema(List<DataCompareUtil.Item> parentFields, String field) {
        StructSchema schema = this.getInput().getDataType();
        for (DataCompareUtil.Item parent : parentFields) {
            if ((schema = this.getFieldSchema(schema.getField(parent.getField()))) != null) continue;
            return null;
        }
        return this.getFieldSchema(schema.getField(field));
    }

    private StructSchema getFieldSchema(Field field) {
        if (field == null) {
            return null;
        }
        DataType t = field.getType();
        if (t instanceof StructSchema) {
            return (StructSchema)t;
        }
        if (t instanceof RefSchema) {
            return ((RefSchema)t).getEntity();
        }
        if (t instanceof AbstractCollectionDataType) {
            DataType et = ((AbstractCollectionDataType)t).getElementType();
            if (et instanceof StructSchema) {
                return (StructSchema)et;
            }
            return null;
        }
        return null;
    }

    public static class DataCompareParser
    extends ResourceType {
        public DataCompareParser(String number, String formId) {
            super(number, formId);
        }

        @Override
        public Resource parse(long id, String number, String name, Map<String, Object> details) {
            return new DataCompare(id, number, name, this, details);
        }
    }
}

