/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.dw;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Quad;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscb.util.script.feature.op.compare.Equals;
import kd.isc.iscx.platform.core.res.meta.dm.AbstractDataModel;
import kd.isc.iscx.platform.core.res.meta.dp.DataQuery;
import kd.isc.iscx.platform.core.res.meta.dp.QueryUtil;
import kd.isc.iscx.platform.core.res.meta.dt.Field;
import kd.isc.iscx.platform.core.res.meta.dt.StructSchema;
import kd.isc.iscx.platform.core.res.meta.dw.DataCompare;
import kd.isc.iscx.platform.core.res.runtime.Connector;
import kd.isc.iscx.platform.core.res.runtime.job.AbstractBatchApplication;

public class DataCompareUtil {
    static Map<String, Object> queryOne(DataCompare comp, Connector $tar, Map<String, Object> memData) {
        List<String> judgeFields = comp.getJudgeFields().get("$");
        List<Map<String, Object>> filters = DataCompareUtil.prepareFilter(memData, judgeFields);
        List<Map<String, Object>> list = DataCompareUtil.queryList(comp, $tar, filters, judgeFields, 1);
        if (list.isEmpty()) {
            return null;
        }
        Map<String, Object> dbData = list.get(0);
        if (DataCompareUtil.getKey(dbData, judgeFields).equals(DataCompareUtil.getKey(memData, judgeFields))) {
            return dbData;
        }
        return null;
    }

    static List<Map<String, Object>> queryList(DataCompare comp, Connector $tar, List<AbstractBatchApplication.Data> memBatch) {
        List<String> judgeFields = comp.getJudgeFields().get("$");
        List<Map<String, Object>> filters = DataCompareUtil.prepareFilter(memBatch, judgeFields);
        return DataCompareUtil.queryList(comp, $tar, filters, judgeFields, memBatch.size());
    }

    static Map<String, Object> doCompare(DataCompare comp, Map<String, Object> memData, Map<String, Object> dbData) {
        DataCompareUtil.writeBackPrimaryKeys(comp, memData, dbData);
        Quad<String, String, Object, Object> result = DataCompareUtil.compareData(comp, comp.getComparedFieldsMap(), memData, dbData, new LinkedList<Item>());
        LinkedHashMap<String, Object> output = new LinkedHashMap<String, Object>();
        output.put("id", DataCompareUtil.getPrimaryKey(comp, dbData));
        output.put("state", result.getA());
        output.put("field", result.getB());
        output.put("real_value", result.getC());
        output.put("mem_value", result.getD());
        if (comp.shouldStopFiber((String)result.getA())) {
            output.put("#_IGNORE_TAG", Boolean.TRUE);
        }
        return output;
    }

    public static Map<String, Map<String, Object>> groupBy(List<Map<String, Object>> list, List<String> judgeFields) {
        HashMap<String, Map<String, Object>> dbMap = new HashMap<String, Map<String, Object>>(list.size());
        for (Map<String, Object> dbData : list) {
            String key = DataCompareUtil.getKey(dbData, judgeFields);
            dbMap.put(key, dbData);
        }
        if (dbMap.size() != list.size()) {
            throw DataCompareUtil.generateDuplicatedRowsException(judgeFields);
        }
        return dbMap;
    }

    private static List<Map<String, Object>> queryList(DataCompare comp, Connector $tar, List<Map<String, Object>> filters, List<String> judgeFields, int maxCount) {
        DataQuery query = new DataQuery(comp.getId(), comp.getNumber(), comp.getName(), comp.getInput(), comp.getInput(), comp.getQueryFieldsMap(), filters);
        try (ConnectionWrapper tar = $tar.getConnection();){
            List<Map<String, Object>> list = DataCompareUtil.queryList(tar, query, maxCount, judgeFields);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, Object>> queryList(ConnectionWrapper tar, DataQuery query, int maxCount, List<String> judgeFields) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(maxCount);
        try (ObjectReader<? extends Map<String, Object>> reader = query.invoke(tar, new HashMap<String, Object>(), 1);){
            Map data = (Map)reader.read();
            while (data != null) {
                list.add(data);
                if (maxCount > 0 && list.size() > maxCount) {
                    throw DataCompareUtil.generateDuplicatedRowsException(judgeFields);
                }
                data = (Map)reader.read();
            }
        }
        return list;
    }

    static IscBizException generateDuplicatedRowsException(List<String> judgeFields) {
        return new IscBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u5019\u9009\u952e\u5b57\u6bb5\uff08%s\uff09\u4ece\u76ee\u6807\u7cfb\u7edf\u67e5\u627e\u5230\u591a\u884c\u6570\u636e\u3002", (String)"PropertyEvaluatorX_44", (String)"isc-iscx-platform-core", (Object[])new Object[0]), judgeFields));
    }

    private static List<Map<String, Object>> prepareFilter(List<AbstractBatchApplication.Data> memBatch, List<String> judgeFields) {
        ArrayList<Map<String, Object>> filters = new ArrayList<Map<String, Object>>(judgeFields.size());
        for (AbstractBatchApplication.Data row : memBatch) {
            List<Map<String, Object>> items = DataCompareUtil.prepareFilter(row.getInput(), judgeFields);
            items.get(items.size() - 1).put("filter_link", "OR");
            filters.addAll(items);
        }
        return filters;
    }

    private static List<Map<String, Object>> prepareFilter(Map<String, Object> data, List<String> judgeFields) {
        ArrayList<Map<String, Object>> filters = new ArrayList<Map<String, Object>>(judgeFields.size());
        for (String field : judgeFields) {
            Object value = data.get(field);
            if (value == null) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6e90\u5355\u5b57\u6bb5\uff08%s\uff09\u6ca1\u6709\u8d4b\u503c\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6d41\u4e2d\u5404\u53d6\u6570\u548c\u8f6c\u6362\u8282\u70b9\u7684\u914d\u7f6e\u3002", (String)"PropertyEvaluatorX_4", (String)"isc-iscx-platform-core", (Object[])new Object[0]), field));
            }
            HashMap<String, Object> item = new HashMap<String, Object>(4);
            item.put("filter_column", field);
            item.put("filter_value_fixed", value);
            item.put("filter_compare", "=");
            filters.add(item);
        }
        return filters;
    }

    public static List<Map<String, Object>> prepareFilters(AbstractDataModel model, List<Map<String, Object>> filters, Map<String, Object> params) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(filters.size());
        for (Map<String, Object> filter : filters) {
            HashMap<String, Object> item = new HashMap<String, Object>(filter);
            Object value = DataCompareUtil.getFilterValue(model, filter, params);
            item.put("filter_value_fixed", value);
            list.add(item);
        }
        return list;
    }

    private static void writeBackPrimaryKeys(DataCompare comp, Map<String, Object> memData, Map<String, Object> dbData) {
        if (dbData == null) {
            return;
        }
        for (Field f : comp.getInput().getDataType().getPrimaryKeyFields()) {
            String key = f.getName();
            memData.put(key, dbData.get(key));
        }
    }

    private static Quad<String, String, Object, Object> compareData(DataCompare comp, Map<String, Object> fieldMap, Map<String, Object> memData, Map<String, Object> dbData, LinkedList<Item> parentFields) {
        if (dbData == null) {
            return new Quad((Object)"NOT_EXISTS", null, null, null);
        }
        Quad result = DataCompareUtil.compareMap(memData, dbData, comp, parentFields, fieldMap);
        return result != null ? result : new Quad((Object)"EQUALS", null, null, null);
    }

    private static Quad<String, String, Object, Object> compareMap(Map<String, Object> memData, Map<String, Object> dbData, DataCompare comp, LinkedList<Item> parentFields, Map<String, Object> fieldMap) {
        for (Map.Entry<String, Object> e : fieldMap.entrySet()) {
            Object dbVal;
            String key = e.getKey();
            Object memVal = DataCompareUtil.getMemValue(memData, key, comp, parentFields);
            Quad<String, String, Object, Object> result = DataCompareUtil.compareMapEntry(memVal, dbVal = dbData.get(key), comp, parentFields, fieldMap, key);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static Quad<String, String, Object, Object> compareMapEntry(Object memVal, Object dbVal, DataCompare comp, LinkedList<Item> parentFields, Map<String, Object> fieldMap, String key) {
        if (Objects.equals(memVal, dbVal)) {
            return null;
        }
        if (memVal == null || dbVal == null) {
            return DataCompareUtil.generateNotEqualsResult(parentFields, key, dbVal, memVal);
        }
        if (memVal instanceof List) {
            List memList = (List)memVal;
            return DataCompareUtil.compareMapEntryL(memList, dbVal, comp, parentFields, fieldMap, key);
        }
        if (memVal instanceof Map) {
            Map memMap = (Map)memVal;
            return DataCompareUtil.compareMapEntryM(memMap, dbVal, comp, parentFields, fieldMap, key);
        }
        if (DataCompareUtil.isSimpleValueEquals(memVal, dbVal, comp, parentFields, key)) {
            return null;
        }
        return DataCompareUtil.generateNotEqualsResult(parentFields, key, dbVal, memVal);
    }

    private static Quad<String, String, Object, Object> compareMapEntryM(Map<String, Object> memMap, Object dbVal, DataCompare comp, LinkedList<Item> parentFields, Map<String, Object> fieldMap, String key) {
        if (!(dbVal instanceof Map)) {
            return DataCompareUtil.generateNotEqualsResult(parentFields, key, dbVal, memMap);
        }
        Map dbMap = (Map)dbVal;
        StructSchema schema = comp.getStructSchema(parentFields, key);
        if (schema != null) {
            return DataCompareUtil.compareMap(memMap, dbMap, comp, DataCompareUtil.concat(parentFields, key), (Map)fieldMap.get(key));
        }
        if (Equals.equals(memMap, (Object)dbMap).booleanValue()) {
            return null;
        }
        return DataCompareUtil.generateNotEqualsResult(parentFields, key, dbVal, memMap);
    }

    private static Quad<String, String, Object, Object> compareMapEntryL(List<Map<String, Object>> memList, Object dbVal, DataCompare comp, LinkedList<Item> parentFields, Map<String, Object> fieldMap, String key) {
        if (!(dbVal instanceof List)) {
            return DataCompareUtil.generateNotEqualsResult(parentFields, key, dbVal, memList);
        }
        List dbList = (List)dbVal;
        if (memList.size() != dbList.size()) {
            return DataCompareUtil.generateNotEqualsResult(parentFields, key, dbList, memList);
        }
        StructSchema schema = comp.getStructSchema(parentFields, key);
        if (schema != null) {
            return DataCompareUtil.compareList(memList, dbList, comp, DataCompareUtil.concat(parentFields, key), (Map)fieldMap.get(key));
        }
        if (Equals.equals(memList, (Object)dbList).booleanValue()) {
            return null;
        }
        return DataCompareUtil.generateNotEqualsResult(parentFields, key, dbVal, memList);
    }

    private static Object getMemValue(Map<String, Object> memData, String key, DataCompare comp, LinkedList<Item> parentFields) {
        Object memVal = memData.get(key);
        if (memVal == null && !memData.containsKey(key)) {
            throw DataCompareUtil.generateValueUnsignedException(comp, parentFields, key);
        }
        return memVal;
    }

    private static Quad<String, String, Object, Object> compareList(List<Map<String, Object>> memList, List<Map<String, Object>> dbList, DataCompare comp, LinkedList<Item> parentFields, Map<String, Object> fieldMap) {
        Comparator<Map<String, Object>> c = DataCompareUtil.createEntryComparator(comp, parentFields);
        memList = new ArrayList<Map<String, Object>>(memList);
        dbList = new ArrayList<Map<String, Object>>(dbList);
        Collections.sort(memList, c);
        Collections.sort(dbList, c);
        Iterator<Map<String, Object>> memIt = memList.iterator();
        Iterator<Map<String, Object>> dbIt = dbList.iterator();
        Item current = parentFields.getLast();
        while (memIt.hasNext()) {
            Map<String, Object> memVal = memIt.next();
            Map<String, Object> dbVal = dbIt.next();
            ++current.index;
            Quad<String, String, Object, Object> result = DataCompareUtil.compareMap(memVal, dbVal, comp, parentFields, fieldMap);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static Comparator<Map<String, Object>> createEntryComparator(DataCompare comp, LinkedList<Item> parentFields) {
        final List<String> judgeFields = comp.getJudgeFields().get(DataCompareUtil.join(parentFields));
        Comparator<Map<String, Object>> c = new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                for (String key : judgeFields) {
                    Object v2;
                    Object v1 = o1.get(key);
                    int i = ((Comparable)v1).compareTo((Comparable)(v2 = o2.get(key)));
                    if (i == 0) continue;
                    return i;
                }
                return 0;
            }
        };
        return c;
    }

    private static String join(LinkedList<Item> parentFields) {
        if (parentFields.size() == 1) {
            return parentFields.getFirst().getField();
        }
        StringBuilder sb = new StringBuilder();
        for (Item i : parentFields) {
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(i.field);
        }
        return sb.toString();
    }

    private static LinkedList<Item> concat(LinkedList<Item> parentFields, String field) {
        LinkedList<Item> fields = new LinkedList<Item>();
        fields.addAll(parentFields);
        fields.add(new Item(field));
        return fields;
    }

    private static IscBizException generateValueUnsignedException(DataCompare comp, LinkedList<Item> parentFields, String key) {
        String field = StringUtil.join(DataCompareUtil.concat(parentFields, key), (String)".");
        String message = String.format(ResManager.loadKDString((String)"\u76ee\u6807\u6570\u636e\uff08%1$s\uff09\u7684\u5b57\u6bb5\uff08%2$s\uff09\u6ca1\u6709\u8d4b\u503c\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6d41\u4e2d\u5404\u53d6\u6570\u548c\u8f6c\u6362\u8282\u70b9\u7684\u914d\u7f6e\u3002", (String)"DataCompareUtil_1", (String)"isc-iscx-platform-core", (Object[])new Object[0]), comp.getInput(), field);
        return new IscBizException(message);
    }

    private static boolean isSimpleValueEquals(Object memVal, Object dbVal, DataCompare comp, List<Item> parentFields, String field) {
        if (memVal instanceof BigDecimal) {
            return ((BigDecimal)memVal).compareTo(D.n((Object)dbVal)) == 0;
        }
        Object diff_limit = comp.getDiffLimit(parentFields, field);
        if (diff_limit instanceof Number) {
            if (memVal instanceof Double || memVal instanceof Float) {
                double diff = ((Number)memVal).doubleValue() - D.d((Object)dbVal);
                return Math.abs(diff) <= ((Number)diff_limit).doubleValue();
            }
            if (memVal instanceof Date) {
                long diff = ((Date)memVal).getTime() - D.t((Object)dbVal).getTime();
                return Math.abs(diff) <= ((Number)diff_limit).longValue();
            }
        } else if (diff_limit instanceof Script) {
            if (memVal instanceof Double || memVal instanceof Float) {
                double diff = ((Number)memVal).doubleValue() - D.d((Object)dbVal);
                return DataCompareUtil.evalDiffLimit((Script)diff_limit, diff);
            }
            if (memVal instanceof Date) {
                long diff = ((Date)memVal).getTime() - D.t((Object)dbVal).getTime();
                return DataCompareUtil.evalDiffLimit((Script)diff_limit, diff);
            }
            return false;
        }
        return false;
    }

    private static boolean evalDiffLimit(Script diff_limit, Object delta) {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("delta", delta);
        return D.x((Object)diff_limit.eval(ctx));
    }

    private static Quad<String, String, Object, Object> generateNotEqualsResult(LinkedList<Item> parentFields, String key, Object dbVal, Object memVal) {
        String field = StringUtil.join(DataCompareUtil.concat(parentFields, key), (String)".");
        return new Quad((Object)"NOT_EQUALS", (Object)field, dbVal, memVal);
    }

    private static Object getPrimaryKey(DataCompare comp, Map<String, Object> dbData) {
        if (dbData == null) {
            return null;
        }
        Field pk = comp.getInput().getDataType().getPrimaryKey();
        if (pk == null) {
            return null;
        }
        return dbData.get(pk.getName());
    }

    public static String getKey(Map<String, Object> data, List<String> judgeFields) {
        if (judgeFields.size() == 1) {
            String key = judgeFields.get(0);
            Object value = data.get(key);
            return String.valueOf(value);
        }
        StringBuilder sb = new StringBuilder();
        for (String field : judgeFields) {
            if (sb.length() > 0) {
                sb.append('+');
            }
            sb.append(data.get(field));
        }
        return sb.toString();
    }

    public static String getKey(List<Map<String, Object>> filters) {
        if (filters.size() == 1) {
            Map<String, Object> filter = filters.get(0);
            return String.valueOf(filter.get("filter_value_fixed"));
        }
        StringBuilder sb = new StringBuilder();
        for (Map<String, Object> filter : filters) {
            Object value = filter.get("filter_value_fixed");
            if (sb.length() > 0) {
                sb.append('+');
            }
            sb.append(value);
        }
        return sb.toString();
    }

    public static Object getFilterValue(AbstractDataModel model, Map<String, Object> filter, Map<String, Object> params) {
        Field f = QueryUtil.getField(model.getDataType(), D.s((Object)filter.get("filter_column")), model.getNumber());
        Object value = QueryUtil.cast(f, filter.get("filter_value_fixed"), params);
        return value;
    }

    public static class Item {
        private String field;
        private int index;

        public Item(String field) {
            this.field = field;
            this.index = 0;
        }

        public String getField() {
            return this.field;
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            if (this.index <= 0) {
                return this.field;
            }
            return this.field + "[" + this.index + "]";
        }
    }
}

