/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.dw;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.util.debugger.DebuggerAction;
import kd.isc.iscb.util.debugger.InlineScriptDebuggerAction;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.flow.core.ProcessElement;
import kd.isc.iscb.util.flow.core.VariableScope;
import kd.isc.iscb.util.flow.core.plugin.Application;
import kd.isc.iscb.util.script.parser.Program;
import kd.isc.iscx.platform.core.res.meta.dw.DataFilter;
import kd.isc.iscx.platform.core.res.runtime.Connector;
import kd.isc.iscx.platform.core.res.runtime.DataFlowException;
import kd.isc.iscx.platform.core.res.runtime.job.DataStream;
import kd.isc.iscx.platform.core.res.runtime.job.Util;
import kd.isc.iscx.platform.core.res.runtime.job.task.FiberTask;

public final class DataFilterApplication
implements Application,
DebuggerAction {
    private final Connector connector;
    private final DataFilter filter;

    public DataFilterApplication(Connector connector, DataFilter filter) {
        this.connector = connector;
        this.filter = filter;
    }

    public void compile(VariableScope scope) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Execution e) {
        long startTime = System.currentTimeMillis();
        try {
            this.doFilter(e);
        }
        finally {
            DataStream.addElapsedTime(e, startTime);
        }
    }

    private void doFilter(Execution e) {
        Object result = this.eval(e);
        if (!Boolean.FALSE.equals(result)) {
            if (Boolean.TRUE.equals(result)) {
                return;
            }
            ProcessElement node = e.getDefine();
            throw new DataFlowException(node.getId(), node.getTitle(), String.format(ResManager.loadKDString((String)"\u6570\u636e\u8fc7\u6ee4\u811a\u672c\u5fc5\u987b\u8fd4\u56detrue/false\uff0c\u5f53\u524d\u8fd4\u56de\u503c\u662f\uff1a%s", (String)"DataFilterApplication_1", (String)"isc-iscx-platform-core", (Object[])new Object[0]), result));
        }
        FiberTask.stopCurrentFiber(e);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object eval(Execution e) {
        Map<String, Object> data = Util.getInputData(e, this.filter);
        try {
            if (!this.filter.isConnectionRequired()) {
                HashMap<String, Map<String, Object>> ctx = new HashMap<String, Map<String, Object>>();
                ctx.put("$data", data);
                return this.filter.getCondition().eval(ctx);
            }
            try (ConnectionWrapper cn = this.connector.getConnection();){
                HashMap<String, Object> ctx = new HashMap<String, Object>();
                ctx.put("$connection", cn);
                ctx.put("$data", data);
                Object object = this.filter.getCondition().eval(ctx);
                return object;
            }
        }
        catch (Throwable err) {
            ProcessElement node = e.getDefine();
            throw new DataFlowException(node.getId(), node.getTitle(), this.filter.getInput(), data, err);
        }
    }

    public void onAttachBreakpoint() {
        InlineScriptDebuggerAction.onAttachBreakpoint((Program)this.filter.getCondition().getProgram());
    }

    public void onDetachBreakpoint() {
        InlineScriptDebuggerAction.onDetachBreakpoint((Program)this.filter.getCondition().getProgram());
    }
}

