/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.dw;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.util.debugger.DebuggerAction;
import kd.isc.iscb.util.debugger.InlineScriptDebuggerAction;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.script.parser.Program;
import kd.isc.iscx.platform.core.res.meta.dw.DataFilterX;
import kd.isc.iscx.platform.core.res.runtime.Connector;
import kd.isc.iscx.platform.core.res.runtime.job.AbstractBatchApplication;
import kd.isc.iscx.platform.core.res.runtime.job.DataStream;

public class DataFilterXApplication
extends AbstractBatchApplication
implements DebuggerAction {
    private DataFilterX filter;
    private Connector connector;

    public DataFilterXApplication(DataFilterX res, int batchSize, Connector connector) {
        super(res, batchSize);
        this.filter = res;
        this.connector = connector;
    }

    @Override
    public void doBatch(DataStream stream, List<AbstractBatchApplication.Data> values) {
        List<Map<String, Object>> batch = this.getBatch(values);
        List<?> result = this.doFilter(batch);
        this.handleResult(batch, result);
    }

    private void handleResult(List<Map<String, Object>> batch, List<?> result) {
        for (int i = 0; i < batch.size(); ++i) {
            if (D.x(result.get(i))) continue;
            batch.get(i).put("#_IGNORE_TAG", Boolean.TRUE);
        }
    }

    private List<?> doFilter(List<Map<String, Object>> batch) {
        List result;
        try (ConnectionWrapper cn = this.connector.getConnection();){
            HashMap<String, Object> ctx = new HashMap<String, Object>();
            ctx.put("$connection", cn);
            ctx.put("$batch", batch);
            result = (List)this.filter.getCondition().eval(ctx);
        }
        return result;
    }

    private List<Map<String, Object>> getBatch(List<AbstractBatchApplication.Data> values) {
        ArrayList<Map<String, Object>> batch = new ArrayList<Map<String, Object>>(values.size());
        for (AbstractBatchApplication.Data row : values) {
            batch.add(row.getInput());
        }
        return batch;
    }

    public void onAttachBreakpoint() {
        InlineScriptDebuggerAction.onAttachBreakpoint((Program)this.filter.getCondition().getProgram());
    }

    public void onDetachBreakpoint() {
        InlineScriptDebuggerAction.onDetachBreakpoint((Program)this.filter.getCondition().getProgram());
    }
}

