/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.dw;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscx.platform.core.res.ResourceType;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.Resource;
import kd.isc.iscx.platform.core.res.meta.dw.ConnectorInfo;
import kd.isc.iscx.platform.core.res.meta.event.AbstractEventModel;

public class DataFlow
extends Resource {
    private String details;
    private List<ConnectorInfo> connectors;
    private AbstractEventModel eventModel;

    protected DataFlow(long id, String number, String name, ResourceType resourceType, Map<String, Object> details) {
        super(id, number, name, resourceType, details);
        this.initEventModel(details);
        this.initConnectors(details);
        this.details = Json.toString(details);
    }

    private void initEventModel(Map<String, Object> details) {
        List nodes = (List)ResourceUtil.getValue(details, "define", "nodes");
        if (nodes != null) {
            for (Map node : nodes) {
                if (!"1".equals(D.s(node.get("id")))) continue;
                long eventModelId = D.l(ResourceUtil.getValue(node, "details", "resource", "id"));
                if (eventModelId <= 0L) break;
                this.eventModel = (AbstractEventModel)ResourceUtil.getResource(eventModelId);
                break;
            }
        }
    }

    private void initConnectors(Map<String, Object> details) {
        List list = (List)details.get("connectors");
        if (list == null) {
            this.connectors = Collections.emptyList();
        } else {
            ArrayList<ConnectorInfo> connectors = new ArrayList<ConnectorInfo>(list.size());
            for (Map item : list) {
                String connector_number = D.s(item.get("connector_number"));
                String connector_type = D.s(item.get("connector_type"));
                String connector_name = D.s(item.get("connector_name"));
                connectors.add(new ConnectorInfo(connector_number, connector_name, connector_type));
            }
            this.connectors = Collections.unmodifiableList(connectors);
        }
    }

    public AbstractEventModel getEventModel() {
        return this.eventModel;
    }

    public String getDetailsJson() {
        return this.details;
    }

    public List<ConnectorInfo> getConnectors() {
        return this.connectors;
    }

    public static class DataFlowResourceParser
    extends ResourceType {
        public DataFlowResourceParser(String number, String formId) {
            super(number, formId);
        }

        @Override
        public Resource parse(long id, String number, String name, Map<String, Object> details) {
            return new DataFlow(id, number, name, this, details);
        }

        @Override
        public boolean isExtensible() {
            return true;
        }
    }
}

