/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.event;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.platform.core.cache.CacheableObjectManager;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscx.platform.core.res.ResourceType;
import kd.isc.iscx.platform.core.res.meta.Resource;
import kd.isc.iscx.platform.core.res.meta.dm.AbstractDataModel;
import kd.isc.iscx.platform.core.res.meta.event.AbstractEventModel;
import kd.isc.iscx.platform.core.res.runtime.Connector;
import kd.isc.iscx.platform.core.res.runtime.DataStreamTrigger;
import kd.isc.iscx.platform.core.res.runtime.trigger.BizEventTrigger;

public class BizEvent
extends AbstractEventModel {
    private String eventStr;
    private List<Map<String, Object>> selectFields;
    private int batchSize;
    private AbstractDataModel dataModel;
    private String entityNumber;
    private Map<String, Object> metaData;

    protected BizEvent(long id, String number, String name, ResourceType resourceType, Map<String, Object> details) {
        super(id, number, name, resourceType, details);
        Map entity = (Map)details.get("entity");
        this.entityNumber = D.s(entity.get("number"));
        this.dataModel = (AbstractDataModel)CacheableObjectManager.get(Resource.class, (Long)D.l(entity.get("id")));
        this.eventStr = D.s((Object)details.get("event"));
        this.selectFields = (List)details.get("select_fields");
        this.batchSize = D.i((Object)details.get("batch_size"));
        this.metaData = new HashMap<String, Object>(8);
        this.metaData.put("entityId", entity.get("id"));
        this.metaData.put("entityNumber", this.entityNumber);
        this.metaData.put("entityName", entity.get("name"));
        this.metaData.put("eventStr", this.eventStr);
        this.metaData.put("selectFields", this.selectFields);
        this.metaData.put("batchSize", this.batchSize);
    }

    @Override
    public Map<String, Object> getMetaData() {
        return this.metaData;
    }

    @Override
    public AbstractDataModel getParams() {
        return this.dataModel;
    }

    @Override
    public AbstractDataModel getOutput() {
        return this.dataModel;
    }

    @Override
    public boolean isDataPulling() {
        return false;
    }

    public String[] getEvents() {
        return this.eventStr == null ? new String[]{} : this.eventStr.split(",");
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public List<Map<String, Object>> getSelectFields() {
        return Collections.unmodifiableList(this.selectFields);
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public DataStreamTrigger createTrigger(Connector connector, long dataFlowTriggerId, String startNodeId) {
        return new BizEventTrigger(connector, this, dataFlowTriggerId, startNodeId);
    }

    public static final class BizEventParser
    extends ResourceType {
        public BizEventParser(String number, String formId) {
            super(number, formId);
        }

        @Override
        public Resource parse(long id, String number, String name, Map<String, Object> details) {
            return new BizEvent(id, number, name, this, details);
        }

        @Override
        public boolean isExtensible() {
            return true;
        }
    }
}

