/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.fm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.dt.ListType;
import kd.isc.iscx.platform.core.res.meta.dt.Field;
import kd.isc.iscx.platform.core.res.meta.dt.RefSchema;
import kd.isc.iscx.platform.core.res.meta.dt.StructSchema;

public class PropModel {
    private String name;
    private String label;
    private boolean isMultiple;
    private boolean isStruct;
    private boolean isEntry;
    private boolean isRequired;
    private String dataType;
    private String fullname;
    private boolean is_primary_key;
    private PropModel parent;
    private List<PropModel> childProps;

    public PropModel() {
    }

    public PropModel(Field field) {
        this("", field, null);
    }

    public PropModel(String prefix, Field field, PropModel parent) {
        this.name = field.getName();
        this.fullname = prefix + this.name;
        this.label = parent == null ? field.getLabel() : parent.getRealLabel() + '.' + field.getLabel();
        this.parent = parent;
        this.isRequired = field.isRequired();
        this.isMultiple = field.isMultiple();
        this.is_primary_key = field.isPrimaryKey();
        if (this.isMultiple) {
            ListType listType = (ListType)field.getType();
            DataType type = listType.getElementType();
            this.handleInnerType(prefix + this.name + ".", type);
        } else {
            this.handleInnerType(prefix + this.name + ".", field.getType());
        }
    }

    private void handleInnerType(String prefix, DataType type) {
        if (type instanceof StructSchema) {
            StructSchema structSchema = (StructSchema)type;
            this.initChilds(prefix, structSchema);
            this.dataType = "STRUCT";
            this.isEntry = true;
        } else if (type instanceof RefSchema) {
            RefSchema refSchema = (RefSchema)type;
            this.initChilds(prefix, refSchema.getEntity());
            this.dataType = "REF";
        } else {
            this.dataType = type.toString();
            this.childProps = Collections.emptyList();
        }
    }

    private void initChilds(String prefix, StructSchema structSchema) {
        this.isStruct = true;
        List<Field> fields = structSchema.getFields();
        this.childProps = new ArrayList<PropModel>(fields.size());
        for (Field subField : fields) {
            this.childProps.add(new PropModel(prefix, subField, this));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRealLabel() {
        return this.label;
    }

    public String getLabel() {
        StringBuilder sb = new StringBuilder(this.label);
        sb.append('-').append(this.getDataType());
        if (this.isPrimaryKey()) {
            sb.append('-').append(ResManager.loadKDString((String)"\u4e3b\u952e", (String)"PropModel_0", (String)"isc-iscx-platform-core", (Object[])new Object[0]));
        }
        if (this.isRequired) {
            sb.append('-').append(ResManager.loadKDString((String)"\u5fc5\u586b", (String)"PropModel_1", (String)"isc-iscx-platform-core", (Object[])new Object[0]));
        }
        return sb.toString();
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public void setRequired(boolean required) {
        this.isRequired = required;
    }

    public boolean isIs_primary_key() {
        return this.is_primary_key;
    }

    public void setIs_primary_key(boolean is_primary_key) {
        this.is_primary_key = is_primary_key;
    }

    public boolean isMultiple() {
        return this.isMultiple;
    }

    public void setMultiple(boolean multiple) {
        this.isMultiple = multiple;
    }

    public boolean isStruct() {
        return this.isStruct;
    }

    public void setStruct(boolean struct) {
        this.isStruct = struct;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public PropModel getParent() {
        return this.parent;
    }

    public void setParent(PropModel parent) {
        this.parent = parent;
    }

    public List<PropModel> getChildProps() {
        return this.childProps;
    }

    public void setChildProps(List<PropModel> childProps) {
        this.childProps = childProps;
    }

    public boolean isEntry() {
        return this.isEntry;
    }

    public void setEntry(boolean entry) {
        this.isEntry = entry;
    }

    public boolean isPrimaryKey() {
        return this.is_primary_key;
    }

    public void set_is_primary_key(boolean is_primary_key) {
        this.is_primary_key = is_primary_key;
    }
}

