/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.fm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.isc.iscb.platform.core.mapping.stringsimilarity.LongestCommonSubsquence;
import kd.isc.iscb.platform.core.mapping.stringsimilarity.StringSimilarity;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscx.platform.core.res.meta.fm.PropModel;
import kd.isc.iscx.platform.core.res.meta.fm.PropModelMappingItem;

public class PropModelMappingProcess {
    private Map<String, PropModel> srcPropModels;
    private Map<String, PropModel> tarPropModels;
    private StringSimilarity algorithm;
    private double matchRatio;

    public double getMatchRatio() {
        return this.matchRatio;
    }

    public PropModelMappingProcess(Map<String, PropModel> srcPropModels, Map<String, PropModel> tarPropModels) {
        this.srcPropModels = srcPropModels;
        this.tarPropModels = tarPropModels;
        this.algorithm = LongestCommonSubsquence.INSTANCE;
        this.matchRatio = 0.8;
    }

    public List<PropModelMappingItem> handle() {
        Map<String, PropModel> srcMapWithNameKey = this.initMapWithName(this.srcPropModels);
        ArrayList<PropModelMappingItem> list = new ArrayList<PropModelMappingItem>(this.tarPropModels.size());
        for (Map.Entry<String, PropModel> tarEntry : this.tarPropModels.entrySet()) {
            this.addMappingItem(srcMapWithNameKey, list, tarEntry, null);
        }
        this.sort(list);
        return list;
    }

    private void sort(List<PropModelMappingItem> list) {
        Collections.sort(list, new Comparator<PropModelMappingItem>(){

            @Override
            public int compare(PropModelMappingItem o1, PropModelMappingItem o2) {
                PropModel o2TarPropModel;
                PropModel o1TarPropModel = o1.getTarPropModel();
                if (PropModelMappingProcess.this.bothAreStruct(o1TarPropModel, o2TarPropModel = o2.getTarPropModel())) {
                    return 0;
                }
                if (PropModelMappingProcess.this.bothAreNotStruct(o1TarPropModel, o2TarPropModel)) {
                    return 0;
                }
                if (o1TarPropModel.isEntry()) {
                    return 1;
                }
                return -1;
            }
        });
    }

    private void addMappingItem(Map<String, PropModel> srcMapWithNameKey, List<PropModelMappingItem> list, Map.Entry<String, PropModel> tarEntry, PropModelMappingItem parentItem) {
        PropModel tarPropModel = tarEntry.getValue();
        PropModelMappingItem mappingItem = this.initMappingItem(tarPropModel, this.srcPropModels, srcMapWithNameKey, parentItem);
        if (this.hasFoundMappingItem(mappingItem) && mappingItem.getSimilar() >= this.matchRatio) {
            list.add(mappingItem);
        } else {
            list.add(new PropModelMappingItem(tarPropModel, null, 0.0));
        }
    }

    private boolean hasFoundMappingItem(PropModelMappingItem mappingItem) {
        return mappingItem != null && mappingItem.getSrcPropModel() != null;
    }

    private PropModelMappingItem initMappingItem(PropModel tarPropModel, Map<String, PropModel> srcPropModels, Map<String, PropModel> srcMapWithNameKey, PropModelMappingItem parentItem) {
        if (srcPropModels == null || srcPropModels.size() == 0) {
            return null;
        }
        PropModel matchProp = srcPropModels.get(tarPropModel.getName());
        if (matchProp != null) {
            return this.checkEntryTypeAndMapping(tarPropModel, matchProp, srcPropModels, parentItem);
        }
        matchProp = srcMapWithNameKey.get(tarPropModel.getLabel());
        if (matchProp != null) {
            return this.checkEntryTypeAndMapping(tarPropModel, matchProp, srcPropModels, parentItem);
        }
        return this.getPropModelMappingItem(tarPropModel, srcPropModels);
    }

    private PropModelMappingItem getPropModelMappingItem(PropModel tarPropModel, Map<String, PropModel> srcPropModels) {
        Pair<PropModel, Double> pair = this.findMostSimilarPropFromModels(tarPropModel, srcPropModels.values());
        return new PropModelMappingItem(tarPropModel, (PropModel)pair.getKey(), (Double)pair.getValue());
    }

    private Pair<PropModel, Double> findMostSimilarPropFromModels(PropModel srcPropModel, Collection<PropModel> tarPropModels) {
        PropModel mostSimilarProp = null;
        double mostSimilar = 0.0;
        for (PropModel tarPropModel : tarPropModels) {
            if (this.onlyOnePropTypeIsEntry(srcPropModel, tarPropModel)) continue;
            double similar = this.calcSimilarIgnoreCase(srcPropModel.getName(), tarPropModel.getName());
            int compare = Double.compare(similar, 1.0);
            if (compare == 0) {
                return new Pair((Object)tarPropModel, (Object)1.0);
            }
            if (!(similar > mostSimilar)) continue;
            mostSimilar = similar;
            mostSimilarProp = tarPropModel;
        }
        return new Pair(mostSimilarProp, (Object)mostSimilar);
    }

    private double calcSimilarIgnoreCase(String srcPropName, String tarPropName) {
        return this.algorithm.calculate((CharSequence)srcPropName.toLowerCase(Locale.ENGLISH), (CharSequence)tarPropName.toLowerCase(Locale.ENGLISH));
    }

    private boolean onlyOnePropTypeIsEntry(PropModel srcPropModel, PropModel tarPropModel) {
        if (srcPropModel.isEntry() && !tarPropModel.isEntry()) {
            return true;
        }
        return !srcPropModel.isEntry() && tarPropModel.isEntry();
    }

    private PropModelMappingItem checkEntryTypeAndMapping(PropModel tarPropModel, PropModel srcPropModel, Map<String, PropModel> srcPropModels, PropModelMappingItem parentItem) {
        if (this.bothAreStruct(tarPropModel, srcPropModel)) {
            return new PropModelMappingItem(tarPropModel, srcPropModel, 1.0);
        }
        if (this.bothAreNotStruct(tarPropModel, srcPropModel)) {
            return new PropModelMappingItem(tarPropModel, srcPropModel, 1.0);
        }
        return this.getPropModelMappingItem(tarPropModel, srcPropModels);
    }

    private boolean bothAreNotStruct(PropModel tarPropModel, PropModel srcPropModel) {
        return !srcPropModel.isEntry() && !tarPropModel.isEntry();
    }

    private boolean bothAreStruct(PropModel tarPropModel, PropModel srcPropModel) {
        return srcPropModel.isEntry() && tarPropModel.isEntry();
    }

    private Map<String, PropModel> initMapWithName(Map<String, PropModel> srcPropModels) {
        Collection<PropModel> values = srcPropModels.values();
        HashMap<String, PropModel> map = new HashMap<String, PropModel>(values.size());
        for (PropModel PropModel2 : values) {
            map.put(PropModel2.getLabel(), PropModel2);
        }
        return map;
    }
}

