/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.fn;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.platform.core.apic.IscApiParam;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscb.util.script.core.Reference;
import kd.isc.iscx.platform.core.res.ResourceType;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.Resource;
import kd.isc.iscx.platform.core.res.meta.fn.AbstractFunction;

public final class ScriptFunction
extends AbstractFunction {
    private Script script;
    private List<IscApiParam.Field> inputs;
    private List<IscApiParam.Field> outputs;

    protected ScriptFunction(long id, String number, String name, ResourceType resourceType, Map<String, Object> details) {
        super(id, number, name, resourceType, details);
        this.initInputFields(details);
        this.initOutputFields(details);
        this.compileScript(details);
    }

    @Override
    public boolean requiresConnector() {
        return false;
    }

    private void compileScript(Map<String, Object> details) {
        Map<String, Object> ctx = this.createCompileTimeContext();
        this.script = Script.compile((String)D.s((Object)details.get("script_tag")), ctx);
    }

    private Map<String, Object> createCompileTimeContext() {
        HashMap<String, Object> ctx = new HashMap<String, Object>(this.inputs.size() + this.outputs.size());
        for (IscApiParam.Field f : this.inputs) {
            ctx.put(f.getName(), Reference.create((String)f.getName()));
        }
        for (IscApiParam.Field f : this.outputs) {
            ctx.put(f.getName(), Reference.create((String)f.getName()));
        }
        return ctx;
    }

    private void initOutputFields(Map<String, Object> details) {
        List list = (List)ResourceUtil.getValue(details, "results");
        this.outputs = new ArrayList<IscApiParam.Field>(list.size());
        for (Map item : list) {
            String result_field = (String)item.get("result_field");
            String result_type = (String)item.get("result_type");
            String result_label = (String)item.get("param_label");
            IscApiParam.Field field = new IscApiParam.Field(result_field, result_type, result_label, false, false, null);
            this.outputs.add(field);
        }
    }

    private void initInputFields(Map<String, Object> details) {
        List list = (List)ResourceUtil.getValue(details, "params");
        this.inputs = new ArrayList<IscApiParam.Field>(list.size());
        for (Map item : list) {
            String param_field = (String)item.get("param_field");
            String param_type = (String)item.get("param_type");
            String param_label = (String)item.get("param_label");
            IscApiParam.Field field = new IscApiParam.Field(param_field, param_type, param_label, false, false, null);
            this.inputs.add(field);
        }
    }

    public Script getScript() {
        return this.script;
    }

    @Override
    public List<IscApiParam.Field> getInputs() {
        return Collections.unmodifiableList(this.inputs);
    }

    @Override
    public List<IscApiParam.Field> getOutputs() {
        return Collections.unmodifiableList(this.outputs);
    }

    @Override
    public Object invoke(ConnectionWrapper cn, Object[] args) {
        Map<String, Object> ctx = this.createRuntimeContext(args);
        this.script.eval(ctx);
        return this.getResult(ctx);
    }

    private Map<String, Object> createRuntimeContext(Object[] args) {
        HashMap<String, Object> ctx = new HashMap<String, Object>(this.inputs.size());
        int j = Math.min(args.length, this.inputs.size());
        for (int i = 0; i < j; ++i) {
            IscApiParam.Field f = this.inputs.get(i);
            ctx.put(f.getName(), f.narrow(args[i]));
        }
        return ctx;
    }

    private Object getResult(Map<String, Object> ctx) {
        switch (this.outputs.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return this.getSingleResult(ctx);
            }
        }
        return this.getMultiResult(ctx);
    }

    private Object getSingleResult(Map<String, Object> ctx) {
        IscApiParam.Field f = this.outputs.get(0);
        return f.narrow(ctx.get(f.getName()));
    }

    private Object getMultiResult(Map<String, Object> ctx) {
        ArrayList<Object> result = new ArrayList<Object>(this.outputs.size());
        for (IscApiParam.Field f : this.outputs) {
            Object value = f.narrow(ctx.get(f.getName()));
            result.add(value);
        }
        return result;
    }

    public static class ScriptFunctionParser
    extends ResourceType {
        public ScriptFunctionParser(String number, String formId) {
            super(number, formId);
        }

        @Override
        public Resource parse(long id, String number, String name, Map<String, Object> details) {
            return new ScriptFunction(id, number, name, this, details);
        }
    }
}

