/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.dc.e.v.Aggregation;
import kd.isc.iscb.platform.core.dc.e.v.AggregationFactory;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.NodeBuilder;
import kd.isc.iscb.util.flow.core.plugin.Application;
import kd.isc.iscb.util.misc.Quad;
import kd.isc.iscx.platform.core.res.ResourceType;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.Resource;
import kd.isc.iscx.platform.core.res.meta.map.AbstractDataMapping;
import kd.isc.iscx.platform.core.res.meta.map.FieldMappingApplication;
import kd.isc.iscx.platform.core.res.meta.map.f.EvaluatorX;
import kd.isc.iscx.platform.core.res.meta.map.f.EvaluatorXFactory;
import kd.isc.iscx.platform.core.res.meta.map.f.PropertyAssemblerX;
import kd.isc.iscx.platform.core.res.meta.vc.AbstractValueConverter;
import kd.isc.iscx.platform.core.res.runtime.Connector;

public class FieldMapping
extends AbstractDataMapping {
    private List<Quad<PropertyAssemblerX, EvaluatorX, AbstractValueConverter, Aggregation>> mapping_before_assembling;
    private List<Quad<PropertyAssemblerX, EvaluatorX, AbstractValueConverter, Aggregation>> mapping_after_assembling;

    private FieldMapping(long id, String number, String name, ResourceType resourceType, Map<String, Object> details) {
        super(id, number, name, resourceType, details);
        this.buildMappingItems(details);
    }

    private void buildMappingItems(Map<String, Object> details) {
        List entries = (List)details.get("mapping_entries");
        this.mapping_before_assembling = new ArrayList<Quad<PropertyAssemblerX, EvaluatorX, AbstractValueConverter, Aggregation>>(entries.size());
        this.mapping_after_assembling = new ArrayList<Quad<PropertyAssemblerX, EvaluatorX, AbstractValueConverter, Aggregation>>(4);
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
        for (Map item : entries) {
            String tarColumn = D.s(item.get("tar_column"));
            String srcColumn = D.s(item.get("src_column"));
            String fixed_value = D.s(item.get("fixed_value"));
            if (tarColumn == null || srcColumn == null && fixed_value == null) continue;
            int index = this.getTargetColumnIndex(indexMap, tarColumn);
            PropertyAssemblerX a = new PropertyAssemblerX(tarColumn, index);
            EvaluatorX e = EvaluatorXFactory.get(srcColumn, fixed_value, a);
            AbstractValueConverter rule = this.getValueConversion(item);
            Aggregation aggr = AggregationFactory.get((String)srcColumn, (String)D.s(item.get("aggr_fn")));
            this.checkAggrCompatibility(rule, aggr);
            if (e.runOnSource()) {
                this.mapping_before_assembling.add((Quad<PropertyAssemblerX, EvaluatorX, AbstractValueConverter, Aggregation>)new Quad((Object)a, (Object)e, (Object)rule, (Object)aggr));
                continue;
            }
            this.mapping_after_assembling.add((Quad<PropertyAssemblerX, EvaluatorX, AbstractValueConverter, Aggregation>)new Quad((Object)a, (Object)e, (Object)rule, (Object)aggr));
        }
        if (this.mapping_after_assembling.isEmpty()) {
            this.mapping_after_assembling = Collections.emptyList();
        }
    }

    private AbstractValueConverter getValueConversion(Map<String, Object> item) {
        long ruleId = D.l(ResourceUtil.getValue(item, "vc_rule", "id"));
        AbstractValueConverter rule = ruleId == 0L ? null : (AbstractValueConverter)ResourceUtil.getResource(ruleId);
        return rule;
    }

    private int getTargetColumnIndex(Map<String, Integer> indexMap, String tarColumn) {
        int index = D.i((Object)indexMap.get(tarColumn));
        indexMap.put(tarColumn, index + 1);
        return index;
    }

    private void checkAggrCompatibility(AbstractValueConverter rule, Aggregation ag) {
        if (rule == null || ag == null) {
            return;
        }
        if (ag.runAt() == Aggregation.RunAt.WITHOUT_VALUE_CONVER) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u805a\u5408\u8fd0\u7b97\uff08%s\uff09\u4e0d\u80fd\u4e0e\u503c\u8f6c\u6362\u89c4\u5219\u4e00\u8d77\u4f7f\u7528\uff01", (String)"FieldMapping_2", (String)"isc-iscx-platform-core", (Object[])new Object[0]), ag));
        }
    }

    List<Quad<PropertyAssemblerX, EvaluatorX, AbstractValueConverter, Aggregation>> getMappingAfterAssembling() {
        return this.mapping_after_assembling;
    }

    List<Quad<PropertyAssemblerX, EvaluatorX, AbstractValueConverter, Aggregation>> getMappingBeforeAssembling() {
        return this.mapping_before_assembling;
    }

    @Override
    protected void build(NodeBuilder node, Map<String, Object> details, Connector $src, Connector $tar) {
        node.biz((Application)new FieldMappingApplication(this, $src, $tar));
    }

    @Override
    public void doMapping(ConnectionWrapper $src, ConnectionWrapper $tar, Map<String, Object> src, Map<String, Object> tar) {
        FieldMappingApplication.mapping(this, $src, $tar, src, tar);
    }

    public static final class FieldMappingParser
    extends ResourceType {
        public FieldMappingParser(String number, String formId) {
            super(number, formId);
        }

        @Override
        public Resource parse(long id, String number, String name, Map<String, Object> details) {
            return new FieldMapping(id, number, name, this, details);
        }

        @Override
        public boolean isExtensible() {
            return true;
        }
    }
}

