/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.map;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.util.debugger.DebuggerAction;
import kd.isc.iscx.platform.core.res.meta.map.ScriptMapping;
import kd.isc.iscx.platform.core.res.meta.map.ScriptMappingApplication;
import kd.isc.iscx.platform.core.res.runtime.Connector;
import kd.isc.iscx.platform.core.res.runtime.job.AbstractBatchApplication;
import kd.isc.iscx.platform.core.res.runtime.job.AbstractMappingApplication;
import kd.isc.iscx.platform.core.res.runtime.job.DataStream;
import kd.isc.iscx.platform.core.res.runtime.job.task.DataTaskUtil;

public class ScriptMappingXApplication
extends AbstractBatchApplication
implements DebuggerAction {
    private ScriptMapping res;
    private Connector $src;
    private Connector $tar;

    protected ScriptMappingXApplication(ScriptMapping res, Connector $src, Connector $tar, int batchSize) {
        super(res, batchSize);
        AbstractMappingApplication.checkConnectors(res, $src, $tar);
        this.res = res;
        this.$src = $src;
        this.$tar = $tar;
    }

    @Override
    public void doBatch(DataStream stream, List<AbstractBatchApplication.Data> values) {
        List<Map<String, Object>> _srcs = this.getSrcList(values);
        List<Map<String, Object>> _tars = this.getTarList(values);
        try (ConnectionWrapper $src = this.$src.getConnection();
             ConnectionWrapper $tar = this.$tar.getConnection();){
            Map<String, Object> ctx = ScriptMappingXApplication.createContext($src, $tar, _srcs, _tars);
            DataTaskUtil.appendStreamContext(stream, ctx);
            this.res.getScript().eval(ctx);
        }
    }

    private List<Map<String, Object>> getTarList(List<AbstractBatchApplication.Data> values) {
        ArrayList<Map<String, Object>> _tars = new ArrayList<Map<String, Object>>(values.size());
        for (AbstractBatchApplication.Data i : values) {
            _tars.add(i.getOutput());
        }
        return _tars;
    }

    private List<Map<String, Object>> getSrcList(List<AbstractBatchApplication.Data> values) {
        ArrayList<Map<String, Object>> _srcs = new ArrayList<Map<String, Object>>(values.size());
        for (AbstractBatchApplication.Data i : values) {
            _srcs.add(i.getInput());
        }
        return _srcs;
    }

    public static void doMapping(ScriptMapping res, ConnectionWrapper $src, ConnectionWrapper $tar, List<Map<String, Object>> _srcs, List<Map<String, Object>> _tars) {
        Map<String, Object> ctx = ScriptMappingXApplication.createContext($src, $tar, _srcs, _tars);
        res.getScript().eval(ctx);
    }

    private static Map<String, Object> createContext(ConnectionWrapper $src, ConnectionWrapper $tar, List<Map<String, Object>> _srcs, List<Map<String, Object>> _tars) {
        Map<String, Object> ctx = ScriptMappingApplication.createMappingContext($src, $tar);
        ctx.put("_srcs", _srcs);
        ctx.put("_tars", _tars);
        return ctx;
    }

    public void onAttachBreakpoint() {
        this.res.getScript().onAttachBreakpoint();
    }

    public void onDetachBreakpoint() {
        this.res.getScript().onDetachBreakpoint();
    }
}

