/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.map.e;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscx.platform.core.res.meta.map.e.BoidX;
import kd.isc.iscx.platform.core.res.meta.map.e.CtxUserIdX;
import kd.isc.iscx.platform.core.res.meta.map.e.Expression;
import kd.isc.iscx.platform.core.res.meta.map.e.NewIdX;
import kd.isc.iscx.platform.core.res.meta.map.e.NowX;
import kd.isc.iscx.platform.core.res.meta.map.e.NullX;
import kd.isc.iscx.platform.core.res.meta.map.e.ReplaceX;
import kd.isc.iscx.platform.core.res.meta.map.e.RtrimX;
import kd.isc.iscx.platform.core.res.meta.map.e.TenantX;
import kd.isc.iscx.platform.core.res.meta.map.e.TimeStampX;
import kd.isc.iscx.platform.core.res.meta.map.e.TodayX;

public class ExpressionParser {
    private static Map<String, Expression> exprs = new LinkedHashMap<String, Expression>();
    private static List<String> keysStartedWith = new ArrayList<String>();

    public static Expression getExpression(String expr) {
        Expression expression = ExpressionParser.innerGetExpression(expr);
        if (expression != null) {
            return expression;
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6d41\u4e0d\u652f\u6301\u8868\u8fbe\u5f0f %s\uff0c\u8bf7\u4f7f\u7528\u811a\u672c\u65b9\u5f0f\u8d4b\u503c\u3002", (String)"ExpressionParser_2", (String)"isc-iscx-platform-core", (Object[])new Object[0]), expr));
    }

    private static Expression innerGetExpression(String expr) {
        Expression expression = exprs.get(expr);
        if (expression == null) {
            for (String key : keysStartedWith) {
                if (!expr.startsWith(key)) continue;
                expression = exprs.get(key);
                break;
            }
        }
        return expression;
    }

    static {
        exprs.put("#{null}", new NullX());
        exprs.put("#{now}", new NowX());
        exprs.put("#{today}", new TodayX());
        exprs.put("#{tenant}", new TenantX());
        exprs.put("#{ctx_user_id}", new CtxUserIdX());
        exprs.put("#{new_", new NewIdX());
        exprs.put("#{now-", new TimeStampX());
        exprs.put("#{replace(", new ReplaceX());
        exprs.put("#{rtrim(", new RtrimX());
        exprs.put("#{boid(", new BoidX());
        keysStartedWith.add("#{new_");
        keysStartedWith.add("#{now-");
        keysStartedWith.add("#{replace(");
        keysStartedWith.add("#{rtrim(");
        keysStartedWith.add("#{boid(");
    }
}

