/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.vc;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.cache.CacheableObjectManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.vc.ValueConversionRuleFactory;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscx.platform.core.res.ResourceType;
import kd.isc.iscx.platform.core.res.meta.Resource;
import kd.isc.iscx.platform.core.res.meta.dm.AbstractDataModel;
import kd.isc.iscx.platform.core.res.meta.dt.Field;

public abstract class AbstractValueConverter
extends Resource {
    private AbstractDataModel input;
    private AbstractDataModel output;
    private String src_field;
    private String tar_field;
    private DataType srcDataType;
    private DataType tarDataType;
    private String default_value;

    protected AbstractValueConverter(long id, String number, String name, ResourceType resourceType, Map<String, Object> details) {
        super(id, number, name, resourceType, details);
        Map output;
        this.src_field = D.s((Object)details.get("src_field"));
        this.tar_field = D.s((Object)details.get("tar_field"));
        Map input = (Map)details.get("input");
        if (input != null) {
            this.input = (AbstractDataModel)CacheableObjectManager.get(Resource.class, (Long)D.l(input.get("id")));
            Field field = this.input.getDataType().findField(this.src_field);
            if (field != null) {
                this.srcDataType = field.getType();
            }
        }
        if ((output = (Map)details.get("output")) != null) {
            this.output = (AbstractDataModel)CacheableObjectManager.get(Resource.class, (Long)D.l(output.get("id")));
            Field field = this.output.getDataType().findField(this.tar_field);
            if (field != null) {
                this.tarDataType = field.getType();
            }
        }
        this.default_value = D.s((Object)details.get("default_value"));
    }

    public final AbstractDataModel getInput() {
        return this.input;
    }

    public final AbstractDataModel getOutput() {
        return this.output;
    }

    public final String getDefaultValue() {
        return this.default_value;
    }

    public DataType getSrcDataType() {
        return this.srcDataType;
    }

    public DataType getTarDataType() {
        return this.tarDataType;
    }

    public String getSrcField() {
        return this.src_field;
    }

    public String getTarField() {
        return this.tar_field;
    }

    public final Object cast(ConnectionWrapper src, ConnectionWrapper tar, Object param) {
        if (param != null) {
            if (this.srcDataType == null) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u503c\u8f6c\u6362\u89c4\u5219\u3010%1$s\u3011\u4e2d\uff0c\u6e90\u6570\u636e\u5b57\u6bb5\uff1a%2$s \u5728\u6e90\u6570\u636e\u6a21\u578b\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"AbstractValueConverter_1", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.getNumber(), this.src_field));
            }
            if (this.tarDataType == null) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u503c\u8f6c\u6362\u89c4\u5219\u3010%1$s\u3011\u4e2d\uff0c\u76ee\u6807\u6570\u636e\u5b57\u6bb5\uff1a%2$s \u5728\u76ee\u6807\u6570\u636e\u6a21\u578b\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"AbstractValueConverter_2", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.getNumber(), this.tar_field));
            }
            try {
                Object input = this.srcDataType.narrow(param);
                Object v = this.innerCast(src, tar, input);
                if (v != null) {
                    return this.tarDataType.narrow(v);
                }
            }
            catch (Exception e) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u503c\u8f6c\u6362\u89c4\u5219 (%1$s:%2$s)", (String)"AbstractValueConverter_3", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.getNumber(), this.getName()), (Throwable)e);
            }
        }
        if (this.default_value != null) {
            return ValueConversionRuleFactory.parseDefaultValue((String)D.s((Object)param), (String)this.getNumber(), (String)this.getName(), (String)this.default_value);
        }
        if (param == null) {
            return "";
        }
        String message = String.format(ResManager.loadKDString((String)"\u6839\u636e\u8f6c\u6362\u89c4\u5219\uff08%1$s\uff1a%2$s\uff09\u5bf9\u6e90\u7cfb\u7edf\u5b57\u6bb5\u503c\uff08%3$s\uff09\u8fdb\u884c\u8f6c\u6362\u7684\u7ed3\u679c\u4e3a\u201c\u7a7a\u201d\u3002", (String)"AbstractValueConverter_0", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.getNumber(), this.getName(), param);
        throw new IscBizException(message);
    }

    protected abstract Object innerCast(ConnectionWrapper var1, ConnectionWrapper var2, Object var3);
}

