/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.vc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.vc.ValueConversionRuleFactory;
import kd.isc.iscb.util.connector.TableUtil;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscx.platform.core.res.ResourceType;
import kd.isc.iscx.platform.core.res.meta.Resource;
import kd.isc.iscx.platform.core.res.meta.vc.AbstractValueConverter;
import kd.isc.iscx.platform.core.res.meta.vc.CandidateFieldRow;

public class AutoMappingRule
extends AbstractValueConverter {
    private List<CandidateFieldRow> fieldMappings;

    private AutoMappingRule(long id, String number, String name, ResourceType resourceType, Map<String, Object> details) {
        super(id, number, name, resourceType, details);
        this.fieldMappings = CandidateFieldRow.createCandidateRowList((List)details.get("fields_mapping"));
        if (this.fieldMappings.isEmpty()) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5019\u9009\u952e\u89c4\u5219\uff08%s\uff09\u6ca1\u6709\u914d\u7f6e\u5019\u9009\u952e\u5b57\u6bb5\u6620\u5c04\uff0c\u8bf7\u68c0\u67e5\u5e76\u914d\u7f6e", (String)"AutoMappingRule_11", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.getNumber()));
        }
    }

    @Override
    protected Object innerCast(ConnectionWrapper src, ConnectionWrapper tar, Object param) {
        Map<String, Object> src_data = this.loadSourceJudgeKeys(param, src);
        if (src_data == null) {
            if (this.getDefaultValue() == null) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5%1$s=%2$s\u7684\u8d44\u6e90\u201c%3$s\u201d\u4e0d\u5b58\u5728\uff01", (String)"AutoMappingRule_12", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.getSrcField(), D.s((Object)param), this.getInput().getName()));
            }
            return null;
        }
        Map<String, Object> tar_data = this.translateJudgeFieldsOnly(src_data);
        Object target = this.loadTargetValue(tar_data, tar);
        this.checkTarget(src_data, target);
        return target;
    }

    private void checkTarget(Map<String, Object> src_data, Object target) {
        if (target == null && this.getDefaultValue() == null) {
            if (this.getInput().getResourceType().getNumber().equals("DataModel.Entity")) {
                src_data.remove("$id");
                src_data.remove("$pk");
            }
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u8f6c\u6362\u89c4\u5219\uff08%1$s\uff1a%2$s\uff09\u65e0\u6cd5\u5c06\u6e90\u7cfb\u7edf\u5b57\u6bb5\u503c\uff08%3$s\uff09\u8f6c\u6362\u4e3a\u76ee\u6807\u7cfb\u7edf\u503c\uff01", (String)"AutoMappingRule_13", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.getNumber(), this.getName(), src_data) + "\r\n" + ValueConversionRuleFactory.getExTips());
        }
    }

    private Object loadTargetValue(Map<String, Object> data, ConnectionWrapper tar) {
        ResourceType resourceType = this.getOutput().getResourceType();
        if (resourceType.getNumber().equals("DataModel.Entity")) {
            return this.loadTargetValueFromEntity(data, tar);
        }
        if (resourceType.getNumber().equals("DataModel.Table")) {
            return this.loadTargetValueFromTable(data, tar);
        }
        throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u5019\u9009\u952e\u8f6c\u6362\u89c4\u5219\uff08%1$s\uff09\u7684\u76ee\u6807\u6570\u636e\u4e0d\u662f\u6570\u636e\u8868\u6216\u5b9e\u4f53\uff0c\u4e0d\u80fd\u7528\u4e8e\u5019\u9009\u952e\u8f6c\u6362\u89c4\u5219\uff08%2$s\uff09\uff01", (String)"AutoMappingRule_14", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.getNumber(), this.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object loadTargetValueFromTable(Map<String, Object> data, ConnectionWrapper tar) {
        Table table = ConnectionManager.getTable((ConnectionWrapper)tar, (String)this.getOutput().getNumber());
        List<String> judgeFields = this.getJudgeFields();
        String jf = judgeFields.get(0);
        String attribute = this.getTargetValueAttribute();
        ArrayList values = new ArrayList();
        ArrayList types = new ArrayList();
        String sql = TableUtil.generateQuerySingleValueSQL((Table)table, (String)attribute, data, (String)jf, judgeFields, values, types);
        try (ObjectReader reader = tar.executeQuery(sql, values, types);){
            DataRow row = (DataRow)reader.read();
            if (row != null) {
                Object object = row.getValue(0);
                return object;
            }
            Object var12_13 = null;
            return var12_13;
        }
    }

    private List<String> getJudgeFields() {
        ArrayList<String> judgeFields = new ArrayList<String>(this.fieldMappings.size());
        for (CandidateFieldRow key : this.fieldMappings) {
            judgeFields.add(key.getTarColumn());
        }
        return judgeFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object loadTargetValueFromEntity(Map<String, Object> tar_data, ConnectionWrapper tar) {
        HashMap<String, Integer> requires = new HashMap<String, Integer>();
        String attribute = this.getTargetValueAttribute();
        requires.put(attribute, 1);
        ArrayList filter = new ArrayList(this.fieldMappings.size());
        for (CandidateFieldRow key : this.fieldMappings) {
            HashMap<String, Object> item = new HashMap<String, Object>();
            filter.add(item);
            item.put("filter_column", key.getTarColumn());
            item.put("filter_compare", "=");
            item.put("filter_value", tar_data.get(key.getTarColumn()));
            item.put("filter_link", "AND");
        }
        ((Map)filter.get(filter.size() - 1)).remove("filter_link");
        String entity = this.getOutput().getNumber();
        try (ObjectReader reader = tar.getFactory().query(tar, entity, requires, filter, null);){
            Map map = (Map)reader.read();
            Object var9_9 = map == null ? null : map.get(attribute);
            return var9_9;
        }
    }

    private String getTargetValueAttribute() {
        if (this.getTarField() == null) {
            return this.getOutput().getDataType().getPrimaryKey().getName();
        }
        return this.getTarField();
    }

    private Map<String, Object> translateJudgeFieldsOnly(Map<String, Object> src_data) {
        HashMap<String, Object> tar_data = new HashMap<String, Object>(this.fieldMappings.size());
        for (CandidateFieldRow key : this.fieldMappings) {
            Pair<String, Object> pair = key.mapping(src_data);
            tar_data.put((String)pair.getA(), pair.getB());
        }
        return tar_data;
    }

    private Map<String, Object> loadSourceJudgeKeys(Object param, ConnectionWrapper src) {
        ResourceType resourceType = this.getInput().getResourceType();
        if (resourceType.getNumber().equals("DataModel.Entity")) {
            return this.loadSourceJudgeKeysFromEntity(param, src);
        }
        if (resourceType.getNumber().equals("DataModel.Table")) {
            return this.loadSourceJudgeKeysFromTable(param, src);
        }
        throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u5019\u9009\u952e\u8f6c\u6362\u89c4\u5219\uff08%1$s\uff09\u7684\u6e90\u6570\u636e\u4e0d\u662f\u6570\u636e\u8868\u6216\u5b9e\u4f53\uff0c\u4e0d\u80fd\u7528\u4e8e\u5019\u9009\u952e\u8f6c\u6362\u89c4\u5219\uff08%2$s\uff09\uff01", (String)"AutoMappingRule_15", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.getNumber(), this.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> loadSourceJudgeKeysFromEntity(Object param, ConnectionWrapper src) {
        HashMap<String, Integer> requires = new HashMap<String, Integer>(this.fieldMappings.size());
        for (CandidateFieldRow mapping : this.fieldMappings) {
            requires.put(mapping.getSrcColumn(), 1);
        }
        ArrayList filter = new ArrayList();
        HashMap<String, Object> item = new HashMap<String, Object>();
        filter.add(item);
        item.put("filter_column", this.getSrcField());
        item.put("filter_compare", "=");
        item.put("filter_value", param);
        String entity = this.getInput().getNumber();
        try (ObjectReader reader = src.getFactory().query(src, entity, requires, filter, null);){
            Map map = (Map)reader.read();
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> loadSourceJudgeKeysFromTable(Object param, ConnectionWrapper src) {
        Table table = ConnectionManager.getTable((ConnectionWrapper)src, (String)this.getInput().getNumber());
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        for (CandidateFieldRow mapping : this.fieldMappings) {
            Column f = table.getField(mapping.getSrcColumn());
            if (sql.length() > "SELECT ".length()) {
                sql.append(", ");
            }
            sql.append(f.getBinding());
        }
        sql.append(" FROM ").append(table.getQuotedName());
        Column filterField = table.getField(this.getSrcField());
        sql.append(" WHERE ").append(this.getSrcField()).append("=?");
        List<Object> values = Collections.singletonList(filterField.toSqlParam(param));
        List<Integer> types = Collections.singletonList(filterField.getSqlType());
        try (ObjectReader reader = src.executeQuery(sql.toString(), values, types);){
            Map map = (Map)reader.read();
            return map;
        }
    }

    public static class AutoMappingRuleParser
    extends ResourceType {
        public AutoMappingRuleParser(String number, String formId) {
            super(number, formId);
        }

        @Override
        public Resource parse(long id, String number, String name, Map<String, Object> details) {
            return new AutoMappingRule(id, number, name, this, details);
        }
    }
}

