/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.vc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscx.platform.core.res.ResourceType;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.Resource;
import kd.isc.iscx.platform.core.res.meta.vc.AbstractValueConverter;

public class CompositeRule
extends AbstractValueConverter {
    private List<AbstractValueConverter> rules;
    private Map<Long, Map<String, String>> connectionMap;

    private CompositeRule(long id, String number, String name, ResourceType resourceType, Map<String, Object> details) {
        super(id, number, name, resourceType, details);
        List list = (List)details.get("sub_rules");
        this.connectionMap = new HashMap<Long, Map<String, String>>(list.size());
        this.rules = new ArrayList<AbstractValueConverter>(list.size());
        for (Map map : list) {
            long ruleId = D.l(ResourceUtil.getValue(map, "rule", "id"));
            Map connMap = this.connectionMap.computeIfAbsent(ruleId, k -> new HashMap());
            connMap.put("src_conn", D.s(map.get("src_conn")));
            connMap.put("tar_conn", D.s(map.get("tar_conn")));
            this.rules.add((AbstractValueConverter)ResourceUtil.getResource(ruleId));
        }
    }

    @Override
    public Object innerCast(ConnectionWrapper src, ConnectionWrapper tar, Object param) {
        Pair<ConnectionWrapper, ConnectionWrapper> castConn;
        AbstractValueConverter rule;
        Object value = param;
        Iterator<AbstractValueConverter> iterator = this.rules.iterator();
        while (iterator.hasNext() && (value = (rule = iterator.next()).cast((ConnectionWrapper)(castConn = this.getCastConn(rule, src, tar)).getKey(), (ConnectionWrapper)castConn.getValue(), value)) != null) {
        }
        return value;
    }

    private Pair<ConnectionWrapper, ConnectionWrapper> getCastConn(AbstractValueConverter rule, ConnectionWrapper src, ConnectionWrapper tar) {
        Map<String, String> connMap = this.connectionMap.get(rule.getId());
        if (connMap == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u5408\u89c4\u5219\u3010%1$s\u3011\u4e2d\u7684\u5b50\u6362\u89c4\u5219\u3010%2$s\u3011\u6ca1\u6709\u914d\u7f6e\u6765\u6e90/\u76ee\u6807\u8fde\u63a5\uff0c\u8bf7\u6253\u5f00\u7f16\u7801\u4e3a\u3010%3$s\u3011\u7684\u7ec4\u5408\u89c4\u5219\u8fdb\u884c\u914d\u7f6e", (String)"CompositeRule_0", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.getName(), rule.getName(), this.getNumber()));
        }
        ConnectionWrapper castSrc = src;
        ConnectionWrapper castTar = tar;
        if ("tar".equals(connMap.get("src_conn"))) {
            castSrc = tar;
        }
        if ("src".equals(connMap.get("tar_conn"))) {
            castTar = src;
        }
        return new Pair((Object)castSrc, (Object)castTar);
    }

    public static class CompositeRuleParser
    extends ResourceType {
        public CompositeRuleParser(String number, String formId) {
            super(number, formId);
        }

        @Override
        public Resource parse(long id, String number, String name, Map<String, Object> details) {
            return new CompositeRule(id, number, name, this, details);
        }
    }
}

