/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.runtime;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.cache.CacheableObjectFactory;
import kd.isc.iscb.platform.core.cache.CacheableObjectManager;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.mem.ObjectSizeIgnored;

public class Connector
implements ObjectSizeIgnored {
    private DynamicObject cfg;

    private Connector(DynamicObject cfg) {
        this.cfg = cfg;
    }

    public long getId() {
        return this.cfg.getLong("id");
    }

    public long getDbLink() {
        return this.cfg.getLong("connection_id");
    }

    public ConnectionWrapper getConnection() {
        String type = D.s((Object)this.cfg.get("type"));
        if ("isc_database_link".equals(type)) {
            long dbLink = this.cfg.getLong("connection_id");
            if (dbLink != 0L) {
                return ConnectionManager.getConnection((long)dbLink);
            }
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8fde\u63a5\u5668\uff08%s\uff09\u6ca1\u6709\u914d\u7f6e\u7cfb\u7edf\u8fde\u63a5\u3002", (String)"Connector_5", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.cfg.get("name")));
        }
        if ("isc_mq_server".equals(type)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8fde\u63a5\u5668\uff08%s\uff09\u7684\u7c7b\u578b\u662f\u201cMQ\u670d\u52a1\u201d\uff0c\u4e0d\u80fd\u7528\u4e8e\u5f53\u524d\u573a\u666f\u3002", (String)"Connector_6", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.cfg.get("name")));
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8fde\u63a5\u5668\uff08%1$s\uff09\u7684\u7c7b\u578b\u201c%2$s\u201d\u4e0d\u5408\u6cd5\u3002", (String)"Connector_7", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.cfg.get("name"), type));
    }

    public String toString() {
        return this.cfg.get("name") + "@" + this.cfg.get("id");
    }

    public static Connector get(long connectorId) {
        return (Connector)CacheableObjectManager.get(Connector.class, (Long)connectorId);
    }

    public static Connector get(String number) {
        return (Connector)CacheableObjectManager.getByNumber(Connector.class, (String)number);
    }

    static {
        CacheableObjectManager.registerFactory((CacheableObjectFactory)new CacheableObjectFactory<Connector>(){

            public String entityType() {
                return "iscx_connector";
            }

            public Connector create(DynamicObject cfg) {
                return new Connector(cfg);
            }

            public Class<Connector> target() {
                return Connector.class;
            }
        });
    }
}

