/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.runtime;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.cache.CacheableObjectFactory;
import kd.isc.iscb.platform.core.cache.CacheableObjectManager;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.Flow;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.mem.ObjectSizeIgnored;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.dm.AbstractDataModel;
import kd.isc.iscx.platform.core.res.meta.ds.NoticeSend;
import kd.isc.iscx.platform.core.res.meta.event.AbstractEventModel;
import kd.isc.iscx.platform.core.res.runtime.Connector;
import kd.isc.iscx.platform.core.res.runtime.DataFlowParser;
import kd.isc.iscx.platform.core.res.runtime.DataFlowTrigger;
import kd.isc.iscx.platform.core.res.runtime.DataStreamTrigger;
import kd.isc.iscx.platform.core.res.runtime.LoggerLevel;

public final class DataFlowDefine
implements ObjectSizeIgnored {
    private int max_threads;
    private LoggerLevel log_level;
    private int work_area_size;
    private long job_mutex;
    private int max_retry_times;
    private int[] retry_interval;
    private long id;
    private String number;
    private Object name;
    private int version;
    private long data_flow_trigger_id;
    private String data_flow_trigger_number;
    private long data_flow_res_id;
    private Map<String, Connector> connectors;
    private Map<String, Object> params;
    private Flow flow;
    private DataStreamTrigger trigger;
    private int checkpoint;
    private AbstractEventModel event;
    private NoticeSend failed_notice;
    private NoticeSend success_notice;
    private long start_mq_topic;
    private long end_mq_topic;
    private int terminal_node_count;
    private boolean enabled;
    private static int MAX_WORK_AREA_SIZE;

    DataFlowDefine(DynamicObject cfg) {
        Map json = (Map)Json.toObject((String)cfg.getString("define_json_tag"));
        this.setBasics(cfg);
        this.setEventModel(json);
        this.setConnectors(json);
        this.setParams(json);
        this.flow = DataFlowParser.parse(this, (Map)json.get("diagram"));
        this.terminal_node_count = DataFlowParser.calcTerminalNodeCount(this.flow);
        this.setFailedNotice(cfg);
        this.setSuccessNotice(cfg);
    }

    private void setFailedNotice(DynamicObject cfg) {
        long failed_notice = D.l((Object)cfg.get("failed_notice_id"));
        if (failed_notice != 0L) {
            this.failed_notice = (NoticeSend)ResourceUtil.getResource(failed_notice);
            if (!this.getEventParams().equals(this.failed_notice.getInput())) {
                String message = String.format(ResManager.loadKDString((String)"\u5931\u8d25\u65f6\u901a\u77e5\u7684\u6570\u636e\u6a21\u578b\u4e0e\u542f\u52a8\u65b9\u6848\u4e8b\u4ef6\u6a21\u578b\u7684\u53c2\u6570\u4e0d\u4e00\u81f4\uff0c\u8bf7\u9009\u62e9\u6570\u636e\u6a21\u578b\u662f\u201c%s\u201d\u7684\u901a\u77e5\u53d1\u9001\u3002", (String)"DataFlowDefine_6", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.getEventParams());
                throw new IscBizException(message);
            }
        }
    }

    private void setSuccessNotice(DynamicObject cfg) {
        long failed_notice = D.l((Object)cfg.get("success_notice_id"));
        if (failed_notice != 0L) {
            this.success_notice = (NoticeSend)ResourceUtil.getResource(failed_notice);
            if (!this.getEventParams().equals(this.success_notice.getInput())) {
                String message = String.format(ResManager.loadKDString((String)"\u5b8c\u6210\u65f6\u901a\u77e5\u7684\u6570\u636e\u6a21\u578b\u4e0e\u542f\u52a8\u65b9\u6848\u4e8b\u4ef6\u6a21\u578b\u7684\u53c2\u6570\u4e0d\u4e00\u81f4\uff0c\u8bf7\u9009\u62e9\u6570\u636e\u6a21\u578b\u662f\u201c%s\u201d\u7684\u901a\u77e5\u53d1\u9001\u3002", (String)"DataFlowDefine_7", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.getEventParams());
                throw new IscBizException(message);
            }
        }
    }

    private void setEventModel(Map<String, Object> json) {
        this.event = (AbstractEventModel)ResourceUtil.getResource(D.l((Object)json.get("event")));
    }

    public Flow getFiberFlow() {
        return this.flow;
    }

    public DataStreamTrigger getTrigger() {
        return this.trigger;
    }

    public long getId() {
        return this.id;
    }

    public String getNumber() {
        return this.number;
    }

    public String getName() {
        return D.s((Object)this.name);
    }

    public int getVesion() {
        return this.version;
    }

    public long getDataFlowResId() {
        return this.data_flow_res_id;
    }

    public long getDataFlowTriggerId() {
        return this.data_flow_trigger_id;
    }

    public String getDataFlowTriggerNumber() {
        return this.data_flow_trigger_number;
    }

    public int getTerminalNodeCount() {
        return this.terminal_node_count;
    }

    public int getMaxRetryTimes() {
        return this.max_retry_times;
    }

    public int getRetryInterval(int index) {
        if (index < this.retry_interval.length) {
            return this.retry_interval[index];
        }
        return Math.max(7, index * 7);
    }

    public int getMaxThreads() {
        return this.max_threads;
    }

    public String getEventType() {
        return this.event.getResourceType().getNumber();
    }

    public AbstractEventModel getEventModel() {
        return this.event;
    }

    public long getStartMqTopic() {
        return this.start_mq_topic;
    }

    public long getEndMqTopic() {
        return this.end_mq_topic;
    }

    public long getJobMutex() {
        return this.job_mutex;
    }

    public LoggerLevel getLoggerLevel() {
        return this.log_level;
    }

    public int getWorkAreaSize() {
        return this.work_area_size;
    }

    public int getCheckPoint() {
        return this.checkpoint;
    }

    public int getMaxBatchSize() {
        return Math.max(2, this.work_area_size / this.max_threads);
    }

    public Map<String, Object> evalParamValues() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>(this.params.size());
        for (Map.Entry<String, Object> e : this.params.entrySet()) {
            Object value = e.getValue();
            if (value instanceof Script) {
                value = ((Script)value).eval();
            }
            params.put(e.getKey(), value);
        }
        return this.getEventParams().getDataType().narrow(params);
    }

    public String digest(Map<String, Object> params) {
        return this.getEventParams().digest(params);
    }

    private AbstractDataModel getEventParams() {
        return this.event.getParams();
    }

    public Map<String, Connector> getConnectors() {
        return this.connectors;
    }

    public Connector getConnector(String alias) {
        Connector c = this.connectors.get(alias);
        if (c != null) {
            return c;
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6d41\u5b9a\u4e49\u6ca1\u6709\u6307\u5b9a\u522b\u540d\u4e3a\u201c%s\u201d\u7684\u8fde\u63a5\u5668\u3002", (String)"DataFlowDefine_8", (String)"isc-iscx-platform-core", (Object[])new Object[0]), alias));
    }

    public NoticeSend getFailedNotice() {
        return this.failed_notice;
    }

    public NoticeSend getSuccessNotice() {
        return this.success_notice;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private void setBasics(DynamicObject cfg) {
        this.id = cfg.getLong("id");
        this.number = cfg.getString("number");
        this.name = cfg.get("data_flow_trigger.name");
        this.data_flow_res_id = cfg.getLong("data_flow_id");
        this.data_flow_trigger_id = cfg.getLong("data_flow_trigger_id");
        this.data_flow_trigger_number = cfg.getString("data_flow_trigger.number");
        this.enabled = DataFlowTrigger.get(this.data_flow_trigger_id).isEnabled();
        this.max_threads = Math.max(1, cfg.getInt("max_threads"));
        this.log_level = LoggerLevel.valueOf(cfg.getString("log_level"));
        this.work_area_size = Math.max(1, cfg.getInt("work_area_size"));
        this.work_area_size = Math.max(this.work_area_size, (this.terminal_node_count + 1) * 2);
        this.work_area_size = Math.min(this.work_area_size, MAX_WORK_AREA_SIZE);
        this.job_mutex = cfg.getLong("job_mutex_id");
        this.max_retry_times = cfg.getInt("max_retry_times");
        this.retry_interval = this.parseRetryInterval(cfg);
        this.version = cfg.getInt("version");
        this.checkpoint = Math.max(5, cfg.getInt("checkpoint"));
        this.start_mq_topic = cfg.getLong("start_mq_topic_id");
        this.end_mq_topic = cfg.getLong("end_mq_topic_id");
    }

    private int[] parseRetryInterval(DynamicObject cfg) {
        List list = (List)Script.compileSimpleScript((String)("[" + cfg.getString("retry_interval") + "]")).eval();
        int[] retry_interval = new int[list.size()];
        int index = -1;
        for (Object o : list) {
            int minutes = D.i(o);
            retry_interval[++index] = minutes <= 0 ? 7 : minutes;
        }
        return retry_interval;
    }

    private void setParams(Map<String, Object> json) {
        Map params = (Map)json.get("params");
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(params.size());
        for (Map.Entry e : params.entrySet()) {
            String value = (String)e.getValue();
            if (value.startsWith("<%") && value.endsWith("%>")) {
                Script expr = Script.compileSimpleScript((String)value.substring(2, value.length() - 2));
                map.put((String)e.getKey(), expr);
                continue;
            }
            map.put((String)e.getKey(), value);
        }
        this.params = map;
    }

    private void setConnectors(Map<String, Object> json) {
        Map connectors = (Map)json.get("connectors");
        LinkedHashMap map = new LinkedHashMap(connectors.size());
        for (Map.Entry e : connectors.entrySet()) {
            Connector c = Connector.get(D.l(((Map)e.getValue()).get("id")));
            map.put(e.getKey(), c);
        }
        this.connectors = Collections.unmodifiableMap(map);
    }

    void initTrigger(Connector connector, String startNodeId) {
        if (this.trigger != null) {
            throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u89e6\u53d1\u5668\u5df2\u8bbe\u7f6e\u3002", (String)"DataFlowDefine_5", (String)"isc-iscx-platform-core", (Object[])new Object[0]));
        }
        this.trigger = this.event.createTrigger(connector, this.data_flow_trigger_id, startNodeId);
    }

    public static DataFlowDefine get(long id) {
        return (DataFlowDefine)CacheableObjectManager.get(DataFlowDefine.class, (Long)id);
    }

    static {
        CacheableObjectManager.registerFactory((CacheableObjectFactory)new CacheableObjectFactory<DataFlowDefine>(){

            public String entityType() {
                return "iscx_data_flow_define";
            }

            public DataFlowDefine create(DynamicObject cfg) {
                return new DataFlowDefine(cfg);
            }

            public Class<DataFlowDefine> target() {
                return DataFlowDefine.class;
            }
        });
        MAX_WORK_AREA_SIZE = 5000;
        try {
            MAX_WORK_AREA_SIZE = D.i((Object)System.getProperty("ISCX_MAX_WORK_AREA_SIZE", "5000"));
        }
        catch (Throwable e) {
            MAX_WORK_AREA_SIZE = 4999;
        }
    }
}

