/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.runtime;

import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.id.IDService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.IscRuntimeInfo;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.license.IscLicenseUtil;
import kd.isc.iscb.platform.core.license.n.LicenseCache;
import kd.isc.iscb.platform.core.license.n.TenantInfo;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscx.platform.core.res.meta.dt.StructSchema;
import kd.isc.iscx.platform.core.res.runtime.Connector;
import kd.isc.iscx.platform.core.res.runtime.DataFlowDefine;
import kd.isc.iscx.platform.core.res.runtime.job.task.FiberUtil;

public class DataFlowEngine {
    public static DataFlowDefine getDataFlowDefine(long id) {
        return DataFlowDefine.get(id);
    }

    public static Connector getConnector(long id) {
        return Connector.get(id);
    }

    public static void enable(DynamicObject flow) {
        ConnectionManager.pushResLicense((boolean)IscLicenseUtil.resHasLicense((String)"iscx_resource", (long)flow.getLong("data_flow_id")));
        try {
            DataFlowEngine.checkLicense();
            DataFlowDefine define = new DataFlowDefine(flow);
            define.getTrigger().enable();
        }
        finally {
            ConnectionManager.popResLicense();
        }
    }

    public static void checkLicense() {
        if (ConnectionManager.hasResLicense()) {
            return;
        }
        TenantInfo t = LicenseCache.getTenant();
        if (!t.isLicenseValid()) {
            IscBizException e = new IscBizException(ResManager.loadKDString((String)"\u96c6\u6210\u4e91\u8bb8\u53ef\u5df2\u8fc7\u671f\u3002", (String)"DataFlowEngine_1", (String)"isc-iscx-platform-core", (Object[])new Object[0]));
            e.setStackTrace(new StackTraceElement[0]);
            throw e;
        }
        if (!t.iscxEnabled()) {
            IscBizException e = new IscBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u6d41\u5f0f\u96c6\u6210\uff08PRO_ISCX\uff09\u201d\u7684\u8bb8\u53ef\u3002", (String)"DataFlowEngine_2", (String)"isc-iscx-platform-core", (Object[])new Object[0]));
            e.setStackTrace(new StackTraceElement[0]);
            throw e;
        }
    }

    public static void disable(DynamicObject flow) {
        ConnectionManager.pushResLicense((boolean)IscLicenseUtil.resHasLicense((String)"iscx_resource", (long)flow.getLong("data_flow_id")));
        try {
            new DataFlowDefine(flow).getTrigger().disable();
        }
        finally {
            ConnectionManager.popResLicense();
        }
    }

    public static DynamicObject createDataStream(DataFlowDefine flow, List<Map<String, Object>> params) {
        return DataFlowEngine.innerCreateDataStream(flow, params, null);
    }

    public static DynamicObject createDataStream(DataFlowDefine flow, List<Map<String, Object>> params, String debug) {
        return DataFlowEngine.innerCreateDataStream(flow, params, debug);
    }

    public static DynamicObject createDataStream(DataFlowDefine flow, Map<String, Object> params) {
        return DataFlowEngine.innerCreateDataStream(flow, params, null);
    }

    public static DynamicObject createDataStream(DataFlowDefine flow, Map<String, Object> params, String debug) {
        return DataFlowEngine.innerCreateDataStream(flow, params, debug);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DynamicObject innerCreateDataStream(DataFlowDefine flow, Object params, String debug) {
        if (!flow.isEnabled()) {
            String number = flow.getDataFlowTriggerNumber();
            String tips = String.format(ResManager.loadKDString((String)"\u6570\u636e\u6d41\u542f\u52a8\u65b9\u6848\uff08%s\uff09\u4e3a\u7981\u7528\u72b6\u6001", (String)"DataFlowEngine_3", (String)"isc-iscx-platform-core", (Object[])new Object[0]), number);
            throw new IscBizException(tips);
        }
        ConnectionManager.pushResLicense((boolean)IscLicenseUtil.resHasLicense((String)"iscx_resource", (long)flow.getDataFlowResId()));
        try {
            DataFlowEngine.checkLicense();
        }
        finally {
            ConnectionManager.popResLicense();
        }
        DynamicObject o = BusinessDataServiceHelper.newDynamicObject((String)"iscx_data_stream");
        long id = IDService.get().genLongId();
        o.set("id", (Object)id);
        o.set("data_flow_trigger_id", (Object)flow.getDataFlowTriggerId());
        o.set("event_type", (Object)flow.getEventType());
        o.set("number", (Object)FiberUtil.buildNumber(id, debug));
        o.set("version", (Object)flow.getVesion());
        o.set("state", (Object)"C");
        o.set("params", (Object)StringUtil.trim((String)DataFlowEngine.generateDigest(flow, params), (int)80));
        o.set("params_tag", (Object)Json.toString((Object)params));
        o.set("creator_id", (Object)RequestContext.get().getCurrUserId());
        Timestamp now = new Timestamp(System.currentTimeMillis());
        o.set("createtime", (Object)now);
        o.set("modifytime", (Object)now);
        o.set("data_flow_def", (Object)flow.getId());
        o.set("execute_count", (Object)0);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{o});
        IscRuntimeInfo.get().incDataFlowStreamCount();
        return o;
    }

    private static String generateDigest(DataFlowDefine flow, Object params) {
        StructSchema schema = flow.getEventModel().getParams().getDataType();
        if (params instanceof Map) {
            return flow.digest(schema.narrow(params));
        }
        StringBuilder sb = new StringBuilder();
        for (Map item : (List)params) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(flow.digest(schema.narrow(item)));
        }
        return sb.toString();
    }
}

