/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscx.platform.core.res.meta.dm.AbstractDataModel;

public final class DataFlowException
extends IscBizException {
    private static final long serialVersionUID = 859909591316479852L;
    private AbstractDataModel model;
    private Map<String, Object> data;
    private List<Map<String, Object>> batch;
    private String nodeTitle;
    private String nodeId;

    public DataFlowException(String nodeId, String nodeTitle, AbstractDataModel model, Map<String, Object> data, String message, Throwable cause) {
        super(message, cause);
        this.nodeId = nodeId;
        this.nodeTitle = nodeTitle;
        this.model = model;
        this.data = data;
    }

    public DataFlowException(String nodeId, String nodeTitle, AbstractDataModel model, Map<String, Object> data, Throwable cause) {
        super(cause.getMessage(), cause);
        this.nodeId = nodeId;
        this.nodeTitle = nodeTitle;
        this.model = model;
        this.data = data;
    }

    public DataFlowException(String nodeId, String nodeTitle, AbstractDataModel model, List<Map<String, Object>> batch, Throwable cause) {
        super(cause.getMessage(), cause);
        this.nodeId = nodeId;
        this.nodeTitle = nodeTitle;
        this.model = model;
        this.batch = batch;
    }

    public DataFlowException(String nodeId, String nodeTitle, String message) {
        super(message);
        this.nodeId = nodeId;
        this.nodeTitle = nodeTitle;
    }

    public DataFlowException(String nodeId, String nodeTitle, String message, AbstractDataModel model, Map<String, Object> data) {
        super(message);
        this.nodeId = nodeId;
        this.nodeTitle = nodeTitle;
        this.model = model;
        this.data = data;
    }

    public String getDataDigest() {
        if (this.model == null) {
            return ResManager.loadKDString((String)"{\u7a7a}", (String)"DataFlowException_0", (String)"isc-iscx-platform-core", (Object[])new Object[0]);
        }
        try {
            if (this.data != null) {
                return this.model.digest(this.data);
            }
            if (this.batch != null) {
                return this.digestBatch();
            }
            return ResManager.loadKDString((String)"\u6570\u636e\u672a\u521d\u59cb\u5316", (String)"DataFlowException_1", (String)"isc-iscx-platform-core", (Object[])new Object[0]);
        }
        catch (Throwable err) {
            return StringUtil.getCascadeMessage((Throwable)err);
        }
    }

    private String digestBatch() {
        ArrayList<String> digests = new ArrayList<String>(this.batch.size());
        for (Map<String, Object> item : this.batch) {
            if (item != null) {
                digests.add(this.model.digest(item));
                continue;
            }
            digests.add(ResManager.loadKDString((String)"\u6570\u636e\u672a\u521d\u59cb\u5316", (String)"DataFlowException_1", (String)"isc-iscx-platform-core", (Object[])new Object[0]));
        }
        return StringUtil.join(digests, (String)";");
    }

    public String getDataJson() {
        if (this.data != null) {
            return Json.toString(this.data, (boolean)true);
        }
        if (this.batch != null) {
            return Json.toString(this.batch, (boolean)true);
        }
        return null;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getNodeTitle() {
        return this.nodeTitle;
    }
}

