/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.runtime;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobInfo;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscx.platform.core.res.runtime.DataFlowDefine;
import kd.isc.iscx.platform.core.res.runtime.DataFlowEngine;
import kd.isc.iscx.platform.core.res.runtime.DataFlowTrigger;
import kd.isc.iscx.platform.core.res.runtime.job.DataStream;
import kd.isc.iscx.platform.core.res.runtime.job.DataStreamJob;

public class DataFlowHelper {
    public static void start(long dataFlowTriggerId) {
        DataStreamJob job = DataFlowHelper.buildStreamJobByTriggerId(dataFlowTriggerId);
        JobEngine.submit((Job)job);
    }

    public static void start(String dataFlowTriggerNumber) {
        long task_id = DataFlowHelper.getIdByNumber(dataFlowTriggerNumber);
        DataFlowHelper.start(task_id);
    }

    public static long getIdByNumber(String dataFlowTriggerNumber) {
        DynamicObject task = BusinessDataServiceHelper.loadSingleFromCache((String)"iscx_data_flow_trigger", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)dataFlowTriggerNumber)});
        if (task == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u662f%s\u7684\u6570\u636e\u6d41\u542f\u52a8\u65b9\u6848\u4e0d\u5b58\u5728", (String)"DataFlowHelper_2", (String)"isc-iscx-platform-core", (Object[])new Object[0]), dataFlowTriggerNumber));
        }
        return task.getLong("id");
    }

    public static void execute(long dataFlowTriggerId) {
        DataStreamJob job = DataFlowHelper.buildStreamJobByTriggerId(dataFlowTriggerId);
        job.executeWithoutRetry();
    }

    public static long executeDataFlow(long dataFlowTriggerId) {
        DataStreamJob job = DataFlowHelper.buildStreamJobByTriggerId(dataFlowTriggerId);
        job.executeWithoutRetry();
        return job.getOwnerId();
    }

    public static Map<String, Object> getState(long procInstId) {
        DynamicObject o = BusinessDataServiceHelper.loadSingle((Object)procInstId, (String)"iscx_data_stream", (String)"state,context_tag");
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("state", o.get("state"));
        Map ctx = (Map)Json.toObject((String)D.s((Object)o.get("context_tag")));
        if (ctx != null) {
            m.put("total", ctx.get("total"));
            m.put("success", ctx.get("success"));
            m.put("terminated", ctx.get("terminated"));
            m.put("ommitted", ctx.get("ommitted"));
        }
        return m;
    }

    public static void execute(String dataFlowTriggerNumber) {
        long task_id = DataFlowHelper.getIdByNumber(dataFlowTriggerNumber);
        DataFlowHelper.execute(task_id);
    }

    private static DataStreamJob buildStreamJobByTriggerId(long dataFlowTriggerId) {
        DataFlowTrigger task = DataFlowTrigger.get(dataFlowTriggerId);
        DataFlowDefine flow = DataFlowDefine.get(task.getDataFlowId());
        return DataFlowHelper.buildJobByFlow(flow);
    }

    public static DataStreamJob buildJobByFlow(DataFlowDefine flow) {
        return DataFlowHelper.buildJobByFlow(flow, null);
    }

    public static DataStreamJob buildJobByFlow(DataFlowDefine flow, String debug) {
        Map<String, Object> params = flow.evalParamValues();
        return DataFlowHelper.buildJobByFlowWithParams(flow, params, debug);
    }

    public static DataStreamJob buildJobByFlowWithParams(DataFlowDefine flow, Map<String, Object> params, String debug) {
        DynamicObject info = DataFlowEngine.createDataStream(flow, params, debug);
        String title = info.getString("number") + " | " + flow.getName();
        long mutex = flow.getJobMutex();
        return new DataStreamJob(info.getLong("id"), title, mutex, !flow.getEventModel().isDataPulling());
    }

    public static Map<String, Object> execute(DynamicObject info) {
        DataFlowDefine flow = DataFlowDefine.get(info.getLong("data_flow_def"));
        String title = info.getString("number") + " | " + flow.getName();
        DataStreamJob job = new DataStreamJob(info.getLong("id"), title, 0L, false);
        job.executeWithoutRetry();
        DataStream stream = job.getStream();
        return stream.getState();
    }

    public static long[] start(long dataFlowTriggerId, List<Map<String, Object>> list) {
        return DataFlowHelper.start(dataFlowTriggerId, list, null);
    }

    public static long[] start(long dataFlowTriggerId, List<Map<String, Object>> list, String debug) {
        DataFlowTrigger task = DataFlowTrigger.get(dataFlowTriggerId);
        DataFlowDefine flow = DataFlowDefine.get(task.getDataFlowId());
        return DataFlowHelper.start(flow, list, debug);
    }

    public static long[] start(DataFlowDefine flow, List<Map<String, Object>> list, String debug) {
        int dataSize = list.size();
        if (dataSize == 1) {
            DataStreamJob job = DataFlowHelper.newDataStreamJob(flow, list, debug);
            long jobId = JobEngine.submit((Job)job);
            return new long[]{jobId};
        }
        List<DataStreamJob> jobList = DataFlowHelper.makeDataStreamJobs(list, flow, dataSize, debug);
        return JobEngine.submit((Job[])jobList.toArray(new DataStreamJob[0]));
    }

    private static List<DataStreamJob> makeDataStreamJobs(List<Map<String, Object>> list, DataFlowDefine flow, int dataSize, String debug) {
        int workAreaSize = Math.max(1, flow.getWorkAreaSize() / 2);
        ArrayList<DataStreamJob> jobList = new ArrayList<DataStreamJob>(dataSize);
        int batchSize = Math.min(dataSize, workAreaSize);
        for (int i = 0; i < dataSize; i += batchSize) {
            int to = Math.min(dataSize, i + batchSize);
            List<Map<String, Object>> subList = list.subList(i, to);
            DataStreamJob streamJob = DataFlowHelper.newDataStreamJob(flow, subList, debug);
            jobList.add(streamJob);
        }
        return jobList;
    }

    public static DataStreamJob newDataStreamJob(DataFlowDefine flow, List<Map<String, Object>> subList, String debug) {
        DynamicObject info = DataFlowEngine.createDataStream(flow, subList, debug);
        String title = info.getString("number") + " | " + flow.getName();
        long mutex = flow.getJobMutex();
        return new DataStreamJob(info.getLong("id"), title, mutex, !flow.getEventModel().isDataPulling());
    }

    public static void tryTerminate(long procInstId) {
        SignalManager.sendCancelSignal((String)String.valueOf(procInstId));
    }

    public static int retry(List<Long> ids) {
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObject[] list = BusinessDataServiceHelper.load((String)"iscx_data_stream", (String)"id,number,state,data_flow_trigger.name,data_flow_trigger.id,creator.id", (QFilter[])new QFilter[]{filter});
        Timestamp now = new Timestamp(System.currentTimeMillis());
        int jobs = 0;
        for (DynamicObject info : list) {
            String state = info.getString("state");
            if (!"C".equals(state) && !"H".equals(state) && !"B".equals(state) && !"P".equals(state) && !"F".equals(state) && !"U".equals(state)) continue;
            long id = info.getLong("id");
            List existsJobs = JobEngine.getJobsWithOwnerId((long)id);
            if (existsJobs.isEmpty()) {
                DataFlowHelper.submitJob(now, info, id);
            } else {
                JobEngine.startImmediately((long)((JobInfo)existsJobs.get(0)).getId());
            }
            ++jobs;
        }
        return jobs;
    }

    private static void submitJob(Timestamp now, DynamicObject info, long id) {
        String title = info.getString("number") + " | " + info.get("data_flow_trigger.name");
        long mutex = DataFlowTrigger.get(info.getLong("data_flow_trigger.id")).getJobMutex();
        DataStreamJob job = new DataStreamJob(id, title, mutex, false);
        long userId = info.getLong("creator.id");
        JobEngine.submitX((Job)job, (Timestamp)now, (long)userId);
    }
}

