/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.Event;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.flow.core.FC;
import kd.isc.iscb.util.flow.core.Flow;
import kd.isc.iscb.util.flow.core.FlowBuilder;
import kd.isc.iscb.util.flow.core.Logger;
import kd.isc.iscb.util.flow.core.Node;
import kd.isc.iscb.util.flow.core.NodeBuilder;
import kd.isc.iscb.util.flow.core.Transition;
import kd.isc.iscb.util.flow.core.TransitionBuilder;
import kd.isc.iscb.util.flow.core.plugin.Condition;
import kd.isc.iscb.util.g.Graph;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.Resource;
import kd.isc.iscx.platform.core.res.meta.SystemInfo;
import kd.isc.iscx.platform.core.res.meta.dm.AbstractDataModel;
import kd.isc.iscx.platform.core.res.meta.event.AbstractEventModel;
import kd.isc.iscx.platform.core.res.runtime.BatchSupportable;
import kd.isc.iscx.platform.core.res.runtime.Connector;
import kd.isc.iscx.platform.core.res.runtime.DataFlowDefine;
import kd.isc.iscx.platform.core.res.runtime.DataHandler;
import kd.isc.iscx.platform.core.res.runtime.ScriptCondition;
import kd.isc.iscx.platform.core.res.runtime.job.AbstractBatchApplication;
import kd.isc.iscx.platform.core.res.runtime.job.DataFlowFiberLogger;
import kd.isc.iscx.platform.core.res.runtime.job.DataFlowNodeExecutionSync;
import kd.isc.iscx.platform.core.res.runtime.job.task.FiberNodeCheckCancelSignalListener;
import kd.isc.iscx.platform.core.res.runtime.job.task.FiberNodeCompletedListener;
import kd.isc.iscx.platform.core.res.runtime.job.task.FiberNodeResumeListener;
import kd.isc.iscx.platform.core.res.runtime.job.task.FiberNodeSuspendListener;
import kd.isc.iscx.platform.core.res.runtime.job.task.FiberRuntimeCompletedListener;
import kd.isc.iscx.platform.core.res.runtime.job.task.FiberRuntimeTerminatedListener;

public class DataFlowParser {
    private static final Logger RUNTIME_LOG = new DataFlowFiberLogger();

    static Flow parse(DataFlowDefine def, Map<String, Object> diagram) {
        String title = def.getName() + "(" + def.getNumber() + ")";
        String id = String.valueOf(def.getId());
        FlowBuilder builder = FC.getFactory().newInstance(id, title);
        builder.setLogger(RUNTIME_LOG);
        DataFlowParser.buildNodes(diagram, builder, def);
        DataFlowParser.buildTransition(diagram, builder);
        DataFlowParser.setNodesFeature(diagram, builder);
        DataFlowParser.buildDataStreamTrigger(def, builder);
        builder.getRootBuilder().listener(Event.ON_TERMINATED, FiberRuntimeTerminatedListener.L);
        Flow flow = builder.end();
        DataFlowParser.checkPathCycle(flow);
        DataFlowParser.checkConcurrentBatchTask(flow);
        return flow;
    }

    private static void setNodesFeature(Map<String, Object> diagram, FlowBuilder builder) {
        List nodes = (List)ResourceUtil.getValue(diagram, "define", "nodes");
        for (Map item : nodes) {
            NodeBuilder node = builder.getNode(D.s(item.get("id")));
            if (node.inComingsCount() > 1) {
                node.smartMerge();
            }
            if (D.x((Object)node.getAttribute("MULTI_CHOICE"))) {
                node.multiChoice();
                continue;
            }
            if (node.outGoingsCount() <= 1) continue;
            node.andSplit();
        }
    }

    public static Resource getResource(Execution e) {
        return (Resource)e.getDefine().getAttribute("RESOURCE");
    }

    public static Pair<AbstractDataModel, AbstractDataModel> getDataModel(Execution e) {
        Resource res = DataFlowParser.getResource(e);
        if (res instanceof DataHandler) {
            DataHandler h = (DataHandler)((Object)res);
            return new Pair((Object)h.getInput(), (Object)h.getOutput());
        }
        if (res instanceof AbstractEventModel) {
            AbstractEventModel event = (AbstractEventModel)res;
            return new Pair((Object)event.getParams(), (Object)event.getOutput());
        }
        return new Pair(null, null);
    }

    public static Pair<Object, Object> getInputAndOutput(Execution e) {
        Resource res = DataFlowParser.getResource(e);
        if (res instanceof DataHandler) {
            DataHandler h = (DataHandler)((Object)res);
            String inputVar = h.getInput().getVariableName();
            String outputVar = h.getOutput().getVariableName();
            return new Pair(e.get(inputVar), e.get(outputVar));
        }
        if (res instanceof AbstractEventModel) {
            AbstractEventModel event = (AbstractEventModel)res;
            String inputVar = event.getParams().getVariableName();
            String outputVar = event.getOutput().getVariableName();
            return new Pair(e.get(inputVar), e.get(outputVar));
        }
        return new Pair(null, null);
    }

    public static Pair<AbstractDataModel, Map<String, Object>> getInput(Execution e) {
        Resource res = DataFlowParser.getResource(e);
        if (res instanceof DataHandler) {
            DataHandler h = (DataHandler)((Object)res);
            AbstractDataModel inputDataModel = h.getInput();
            String inputVar = inputDataModel.getVariableName();
            return new Pair((Object)inputDataModel, (Object)((Map)e.get(inputVar)));
        }
        if (res instanceof AbstractEventModel) {
            AbstractEventModel event = (AbstractEventModel)res;
            AbstractDataModel inputDataModel = event.getParams();
            String inputVar = inputDataModel.getVariableName();
            return new Pair((Object)inputDataModel, (Object)((Map)e.get(inputVar)));
        }
        return new Pair(null, null);
    }

    private static void buildNodes(Map<String, Object> diagram, FlowBuilder builder, DataFlowDefine def) {
        List nodes = (List)ResourceUtil.getValue(diagram, "define", "nodes");
        for (Map item : nodes) {
            NodeBuilder node = builder.node(D.s(item.get("id")), D.s(item.get("name")));
            Object resId = ResourceUtil.getValue(item, "details", "resource", "id");
            if (resId != null) {
                Object res = ResourceUtil.getResource(D.l(resId));
                node.setAttribute("RESOURCE", res);
                if (res instanceof DataHandler) {
                    DataFlowParser.buildNode(def, item, node, (DataHandler)res);
                } else if (res instanceof AbstractEventModel && node.getId().equals("1")) {
                    DataFlowParser.buildStartNode(builder, node, def, (AbstractEventModel)res, item);
                } else {
                    String message = String.format(ResManager.loadKDString((String)"\u8d44\u6e90\u201c%1$s\u201d\u6ca1\u6709\u5b9e\u73b0 ForDataFlow \u63a5\u53e3\uff0c\u4e0d\u80fd\u7528\u4e8e\u8282\u70b9\u201c%2$s\u201d\u3002", (String)"DataFlowParser_13", (String)"isc-iscx-platform-core", (Object[])new Object[0]), res, node.getTitle());
                    throw new IscBizException(message);
                }
            }
            if (node.getApplication() == null) {
                node.listener(Event.ON_COMPLETED, FiberNodeCompletedListener.L);
            }
            node.listener(Event.ON_SUSPENED, FiberNodeSuspendListener.L);
            node.listener(Event.ON_RESUMED, FiberNodeResumeListener.L);
            node.setSynchronizer(DataFlowNodeExecutionSync.IMPL);
            if (!"End".equals(item.get("type"))) continue;
            node.listener(Event.ON_COMPLETED, FiberRuntimeCompletedListener.L);
            node.smartMerge();
        }
    }

    private static void buildStartNode(FlowBuilder builder, NodeBuilder node, DataFlowDefine def, AbstractEventModel res, Map<String, Object> item) {
        DataFlowParser.createVariable(node.getFlowBuilder(), res.getOutput());
        builder.setAttribute("EVENT_CONNECTOR", (Object)DataFlowParser.getEventConnector(def, res, item));
        builder.setAttribute("EVENT_MODEL", (Object)res);
        builder.setAttribute("EVENT_NODE_ID", (Object)node.getId());
    }

    private static Connector getEventConnector(DataFlowDefine def, AbstractEventModel res, Map<String, Object> item) {
        Map<String, Connector> connectors = DataFlowParser.getConnectors(def, item);
        SystemInfo systemInfo = res.getSystemInfo();
        if (systemInfo == null) {
            return null;
        }
        String connectorAlias = systemInfo.getNumber();
        return connectors.get(connectorAlias);
    }

    private static void buildDataStreamTrigger(DataFlowDefine def, FlowBuilder builder) {
        AbstractEventModel eventModel = def.getEventModel();
        if (!eventModel.equals(builder.getAttribute("EVENT_MODEL"))) {
            throw new IscBizException(ResManager.loadKDString((String)"\u6570\u636e\u6d41\u5f00\u59cb\u8282\u70b9\u7684\u4e8b\u4ef6\u6a21\u578b\u4e0e\u542f\u52a8\u65b9\u6848\u7684\u4e8b\u4ef6\u6a21\u578b\u4e0d\u4e00\u81f4\u3002", (String)"DataFlowParser_2", (String)"isc-iscx-platform-core", (Object[])new Object[0]));
        }
        Connector connector = (Connector)builder.getAttribute("EVENT_CONNECTOR");
        String nodeId = (String)builder.getAttribute("EVENT_NODE_ID");
        def.initTrigger(connector, nodeId);
        DataFlowParser.createVariable(builder, eventModel.getOutput());
    }

    private static void buildNode(DataFlowDefine def, Map<String, Object> item, NodeBuilder node, DataHandler res) {
        DataFlowParser.createVariable(node.getFlowBuilder(), res.getInput());
        DataFlowParser.createVariable(node.getFlowBuilder(), res.getOutput());
        Map details = (Map)item.get("details");
        res.build(node, details, DataFlowParser.getConnectors(def, item), D.x((Object)item.get("batch_mode")));
        DataFlowParser.checkBatchMode(item, res, node);
        node.listener(Event.ON_READY, FiberNodeCheckCancelSignalListener.L);
        if (!res.isFiberTerminal()) {
            node.listener(Event.ON_COMPLETED, FiberNodeCompletedListener.L);
        }
        node.setAttribute("is_terminal", (Object)res.isFiberTerminal());
    }

    private static void checkBatchMode(Map<String, Object> item, DataHandler res, NodeBuilder node) {
        if (!(res instanceof BatchSupportable)) {
            DataFlowParser.checkNodeForNotBatchMode(node);
        } else {
            boolean batchMode = D.x((Object)item.get("batch_mode"));
            if (batchMode) {
                DataFlowParser.checkNodeForBatchMode(node);
            } else {
                DataFlowParser.checkNodeForNotBatchMode(node);
            }
        }
    }

    private static void checkNodeForNotBatchMode(NodeBuilder node) {
        if (node.getApplication() instanceof AbstractBatchApplication) {
            String message = String.format(ResManager.loadKDString((String)"\u8282\u70b9\u201c%s\u201d\u6ca1\u6709\u542f\u7528\u6279\u5904\u7406\u6a21\u5f0f\uff0c\u4f46\u5b83\u7684 application \u7ee7\u627f\u4e86 AbstractBatchApplication\u3002", (String)"DataFlowParser_14", (String)"isc-iscx-platform-core", (Object[])new Object[0]), node);
            throw new IscBizException(message);
        }
        if (node.getCallback() != null) {
            String message = String.format(ResManager.loadKDString((String)"\u8282\u70b9\u201c%s\u201d\u6ca1\u6709\u542f\u7528\u4e86\u6279\u5904\u7406\u6a21\u5f0f\uff0c\u4f46\u5b83\u8bbe\u7f6e\u4e86 callback\u3002", (String)"DataFlowParser_15", (String)"isc-iscx-platform-core", (Object[])new Object[0]), node);
            throw new IscBizException(message);
        }
    }

    private static void checkNodeForBatchMode(NodeBuilder node) {
        if (!(node.getApplication() instanceof AbstractBatchApplication)) {
            String message = String.format(ResManager.loadKDString((String)"\u8282\u70b9\u201c%s\u201d\u542f\u7528\u4e86\u6279\u5904\u7406\u6a21\u5f0f\uff0c\u4f46\u5b83\u7684 application \u6ca1\u6709\u7ee7\u627f AbstractBatchApplication\u3002", (String)"DataFlowParser_16", (String)"isc-iscx-platform-core", (Object[])new Object[0]), node);
            throw new IscBizException(message);
        }
        if (node.getCallback() == null) {
            String message = String.format(ResManager.loadKDString((String)"\u8282\u70b9\u201c%s\u201d\u542f\u7528\u4e86\u6279\u5904\u7406\u6a21\u5f0f\uff0c\u4f46\u5b83\u6ca1\u6709\u8bbe\u7f6e callback\uff0c\u5c06\u5bfc\u81f4\u6570\u636e\u7ebf\u4efb\u52a1\u65e0\u6cd5\u4e0e\u6279\u5904\u7406\u4efb\u52a1\u6b63\u786e\u4ea4\u4e92\u3002", (String)"DataFlowParser_17", (String)"isc-iscx-platform-core", (Object[])new Object[0]), node);
            throw new IscBizException(message);
        }
        if (node.getCallback() != BatchSupportable.WAIT_FOR_BATCH_TASK) {
            String message = String.format(ResManager.loadKDString((String)"\u8282\u70b9\u201c%s\u201d\u542f\u7528\u4e86\u6279\u5904\u7406\u6a21\u5f0f\uff0c\u4f46\u5b83\u8bbe\u7f6e\u7684 callback \u4e0d\u662f BatchSupportable.WAIT_FOR_BATCH_TASK\u3002", (String)"DataFlowParser_18", (String)"isc-iscx-platform-core", (Object[])new Object[0]), node);
            throw new IscBizException(message);
        }
    }

    private static void createVariable(FlowBuilder flow, AbstractDataModel m) {
        String name = m.getVariableName();
        if (flow.getVariable(name) == null) {
            flow.variable(name, name, m.getName(), (DataType)m.getDataType()).setAttribute("data_model", (Object)m);
        }
    }

    private static Map<String, Connector> getConnectors(DataFlowDefine def, Map<String, Object> item) {
        List bindings = (List)ResourceUtil.getValue(item, "details", "connctor_binding");
        if (bindings == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Connector> connectors = new LinkedHashMap<String, Connector>(bindings.size());
        for (Map e : bindings) {
            String key = D.s(e.get("system_number"));
            String alias = D.s(e.get("system_connector"));
            if (alias != null) {
                connectors.put(key, def.getConnector(alias));
                continue;
            }
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8282\u70b9\u201c%s\u201d\u6ca1\u6709\u6307\u5b9a\u8fde\u63a5\u5668\u3002", (String)"DataFlowParser_19", (String)"isc-iscx-platform-core", (Object[])new Object[0]), item.get("name")));
        }
        return connectors;
    }

    private static void buildTransition(Map<String, Object> diagram, FlowBuilder flow) {
        List edges = (List)ResourceUtil.getValue(diagram, "define", "edges");
        HashSet<String> trans = new HashSet<String>(edges.size());
        for (Map e : edges) {
            String from = D.s(e.get("src_node_id"));
            String to = D.s(e.get("dst_node_id"));
            String id = from + "-" + to;
            if (!trans.add(id)) continue;
            Transition.Type type = DataFlowParser.getTransitionType(e);
            TransitionBuilder t = flow.transition(id, id, from, to, type);
            ScriptCondition c = DataFlowParser.getTransitionCondition(e);
            if (c == null) continue;
            t.setCondition((Condition)c);
            if (type != Transition.Type.NORMAL) continue;
            flow.getNode(from).setAttribute("MULTI_CHOICE", (Object)true);
        }
    }

    private static ScriptCondition getTransitionCondition(Map<String, Object> e) {
        String s = D.s((Object)e.get("line_script"));
        if (s == null) {
            return null;
        }
        return new ScriptCondition(s);
    }

    private static Transition.Type getTransitionType(Map<String, Object> e) {
        String type = D.s((Object)e.get("line_type"));
        if (type == null || "NormalTransition".equals(type)) {
            return Transition.Type.NORMAL;
        }
        if ("ErrorTransition".equals(type)) {
            return Transition.Type.ERROR;
        }
        if ("CompensationTransition".equals(type)) {
            return Transition.Type.COMPENSATION;
        }
        throw new IllegalArgumentException("Illegal transition type '" + type + "'.");
    }

    private static void checkPathCycle(Flow flow) {
        Graph g = new Graph();
        for (Node n : flow.getRoot().getChildren()) {
            g.appendVertex(n.getId(), (Object)n.getId());
        }
        for (Node n : flow.getRoot().getChildren()) {
            for (Transition t : n.getOutGoing()) {
                if (D.x((Object)t.getSource().getAttribute("is_terminal"))) continue;
                g.appendEdge(t.getSource().getId(), t.getTarget().getId(), (Object)t);
            }
        }
        List sequence = g.topSort();
        if (sequence.size() != flow.getRoot().getChildren().size()) {
            throw new IscBizException(ResManager.loadKDString((String)"\u6570\u636e\u6d41\u56fe\u4e2d\u5b58\u5728\u73af\uff0c\u4e0d\u53ef\u542f\u7528\u3002", (String)"DataFlowParser_10", (String)"isc-iscx-platform-core", (Object[])new Object[0]));
        }
    }

    static int calcTerminalNodeCount(Flow flow) {
        int count = 0;
        for (Node n : flow.getRoot().getChildren()) {
            if (!D.x((Object)n.getAttribute("is_terminal"))) continue;
            ++count;
        }
        return count;
    }

    private static void checkConcurrentBatchTask(Flow flow) {
        ArrayList<Node> batchTasks = new ArrayList<Node>();
        for (Node node : flow.getRoot().getChildren()) {
            if (!(node.getApplication() instanceof AbstractBatchApplication)) continue;
            batchTasks.add(node);
        }
        if (batchTasks.size() <= 1) {
            return;
        }
        kd.isc.iscb.util.flow.core.i.arithmetic.Graph g = flow.getRoot().getGraph();
        Node[] nodes = batchTasks.toArray(new Node[batchTasks.size()]);
        int k = nodes.length - 1;
        for (int i = 0; i < k; ++i) {
            for (int j = 1; j < nodes.length; ++j) {
                Node a = nodes[i];
                Node b = nodes[j];
                if (DataFlowParser.isReachable(g, a, b)) continue;
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8282\u70b9\u201c%1$s\u201d\u4e0e\u8282\u70b9\u201c%2$s\u201d\u4e4b\u95f4\u7684\u6267\u884c\u987a\u5e8f\u4e0d\u786e\u5b9a\uff0c\u8bf7\u5728\u4e8c\u8005\u4e4b\u95f4\u6dfb\u52a0\u8fde\u7ebf\u786e\u5b9a\u6267\u884c\u7684\u5148\u540e\u987a\u5e8f\u3002", (String)"DataFlowParser_20", (String)"isc-iscx-platform-core", (Object[])new Object[0]), a, b));
            }
        }
    }

    private static boolean isReachable(kd.isc.iscb.util.flow.core.i.arithmetic.Graph g, Node a, Node b) {
        return g.reach(a.getId(), b.getId()) || g.reach(b.getId(), a.getId());
    }
}

