/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.runtime;

import java.sql.Connection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.isc.iscb.platform.core.cache.CacheableObjectFactory;
import kd.isc.iscb.platform.core.cache.CacheableObjectManager;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.mem.ObjectSizeIgnored;

public final class DataFlowTrigger
implements ObjectSizeIgnored {
    private long id;
    private String number;
    private String name;
    private String event_type;
    private boolean enabled;
    private long dataFlowId = 0L;
    private long jobMutex;
    private long event_model;

    public DataFlowTrigger(DynamicObject cfg) {
        this.id = D.l((Object)cfg.get("id"));
        this.number = D.s((Object)cfg.get("number"));
        this.name = D.s((Object)cfg.get("name"));
        this.event_type = D.s((Object)cfg.get("event_type"));
        this.enabled = D.x((Object)cfg.get("enable"));
        this.jobMutex = cfg.getLong("job_mutex.id");
        this.event_model = D.l((Object)cfg.get("event_model_id"));
    }

    public long getJobMutex() {
        return this.jobMutex;
    }

    public long getEventModel() {
        return this.event_model;
    }

    public long getDataFlowId() {
        long dataFlowId = this.dataFlowId;
        if (dataFlowId == 0L) {
            dataFlowId = DataFlowTrigger.queryMaxDataFlowId(this.id);
        }
        return dataFlowId;
    }

    public String getEventType() {
        return this.event_type;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getNumber() {
        return this.number;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public static DataFlowTrigger get(long id) {
        return (DataFlowTrigger)CacheableObjectManager.get(DataFlowTrigger.class, (Long)id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long queryMaxDataFlowId(long dataFlowTriggerId) {
        String sql = "SELECT fid FROM t_iscx_data_flow_define WHERE fdata_flow_trigger = ? ORDER BY fversion DESC";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            Object value = DbUtil.executeScalar((Connection)cn, (String)sql, (List)D.asList((Object[])new Object[]{dataFlowTriggerId}), (List)D.asList((Object[])new Integer[]{-5}));
            long l = D.l((Object)value);
            return l;
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    static {
        CacheableObjectManager.registerFactory((CacheableObjectFactory)new CacheableObjectFactory<DataFlowTrigger>(){

            public String entityType() {
                return "iscx_data_flow_trigger";
            }

            public DataFlowTrigger create(DynamicObject cfg) {
                return new DataFlowTrigger(cfg);
            }

            public Class<DataFlowTrigger> target() {
                return DataFlowTrigger.class;
            }
        });
    }
}

