/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.runtime.job;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.flow.core.VariableScope;
import kd.isc.iscb.util.flow.core.plugin.Application;
import kd.isc.iscx.platform.core.res.runtime.DataHandler;
import kd.isc.iscx.platform.core.res.runtime.job.DataStream;
import kd.isc.iscx.platform.core.res.runtime.job.DataTask;
import kd.isc.iscx.platform.core.res.runtime.job.task.FiberTask;

public abstract class AbstractBatchApplication
implements Application {
    private int batchSize;
    private DataHandler res;

    protected AbstractBatchApplication(DataHandler res, int batchSize) {
        if (batchSize <= 1) {
            batchSize = 50;
        }
        this.batchSize = batchSize;
        this.res = res;
    }

    public final void compile(VariableScope scope) {
    }

    public final void invoke(final Execution e) {
        final FiberTask task = FiberTask.getCurrentTask(e);
        task.setOnRelease(new DataTask.OnRelease(){

            @Override
            public void doSomething() {
                DataStream stream = task.getStream();
                stream.getWorkArea().appendBatch(e, AbstractBatchApplication.this.batchSize);
            }
        });
    }

    public DataHandler getDataHandler() {
        return this.res;
    }

    public abstract void doBatch(DataStream var1, List<Data> var2);

    public static final class Data {
        private FiberTask task;
        private Map<String, Object> input;
        private Map<String, Object> output;
        private String executionId;

        public Data(FiberTask task, String executionId, Map<String, Object> input, Map<String, Object> output) {
            this.task = task;
            this.executionId = executionId;
            this.input = input;
            this.output = output != null ? output : new HashMap();
        }

        public String getExecutionId() {
            return this.executionId;
        }

        public Map<String, Object> getInput() {
            return this.input;
        }

        public Map<String, Object> getOutput() {
            return this.output;
        }

        public FiberTask getTask() {
            return this.task;
        }
    }
}

