/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.runtime.job;

import java.util.concurrent.atomic.AtomicInteger;

public class DataFiberCounter {
    private AtomicInteger total_count;
    private AtomicInteger completed_count;
    private AtomicInteger ommitted_count;
    private AtomicInteger terminated_count;
    private AtomicInteger failed_count = new AtomicInteger(0);

    DataFiberCounter(int total_count, int success_count, int terminated_count, int ommitted_count) {
        this.total_count = new AtomicInteger(total_count);
        this.completed_count = new AtomicInteger(success_count);
        this.terminated_count = new AtomicInteger(terminated_count);
        this.ommitted_count = new AtomicInteger(ommitted_count);
    }

    public void incTotalCount() {
        this.total_count.incrementAndGet();
    }

    public void incCompletedCount() {
        this.completed_count.incrementAndGet();
    }

    public void incTerminatedCount() {
        this.terminated_count.incrementAndGet();
    }

    public void incOmmittedCount() {
        this.ommitted_count.incrementAndGet();
    }

    public int getTerminatedCount() {
        return this.terminated_count.get();
    }

    public int getOmmittedCount() {
        return this.ommitted_count.get();
    }

    public int getTotalCount() {
        return this.total_count.get();
    }

    public int getCompletedCount() {
        return this.completed_count.get();
    }

    public void incTotalCount(int total) {
        this.total_count.addAndGet(total);
    }

    public void incFailedCount() {
        this.failed_count.incrementAndGet();
    }

    public int getFailedCount() {
        return this.failed_count.get();
    }
}

