/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.runtime.job;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.isc.iscb.platform.core.trace.TraceType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.flow.core.FlowRuntime;
import kd.isc.iscb.util.flow.core.Node;
import kd.isc.iscb.util.flow.core.ProcessElement;
import kd.isc.iscb.util.flow.core.VariableScope;
import kd.isc.iscb.util.flow.core.plugin.NodeExecutionSync;
import kd.isc.iscx.platform.core.res.runtime.job.task.FiberTask;

public class DataFlowNodeExecutionSync
implements NodeExecutionSync {
    public static final NodeExecutionSync IMPL = new DataFlowNodeExecutionSync();

    private DataFlowNodeExecutionSync() {
    }

    public String newId(VariableScope define, FlowRuntime runtime) {
        return null;
    }

    public void begin(Execution e) {
        this.setPath(e);
        DataFlowNodeExecutionSync.setState(e, "state", "arrived");
    }

    public void complete(Execution e) {
        DataFlowNodeExecutionSync.setState(e, "state", "completed");
        DataFlowNodeExecutionSync.setState(e, "end_time", new Timestamp(System.currentTimeMillis()).toString());
        DataFlowNodeExecutionSync.setElapsedTime(e);
    }

    public void suspend(Execution e) {
        DataFlowNodeExecutionSync.setState(e, "state", "suspended");
    }

    public void resume(Execution e) {
        DataFlowNodeExecutionSync.setState(e, "state", "running");
    }

    public void fail(Execution e) {
        DataFlowNodeExecutionSync.setState(e, "state", "failed");
        DataFlowNodeExecutionSync.setState(e, "end_time", new Timestamp(System.currentTimeMillis()).toString());
        DataFlowNodeExecutionSync.setElapsedTime(e);
    }

    public void terminate(Execution e) {
        if (!"completed".equals(DataFlowNodeExecutionSync.getState(e, "state"))) {
            DataFlowNodeExecutionSync.setState(e, "state", "terminated");
        }
        DataFlowNodeExecutionSync.setState(e, "end_time", new Timestamp(System.currentTimeMillis()).toString());
    }

    public void reenter(Execution e) {
        this.setPath(e);
    }

    public void ready(Execution e) {
        DataFlowNodeExecutionSync.setState(e, "state", "ready");
        long now = System.currentTimeMillis();
        e.setTransientProperty("start_time", (Object)now);
        DataFlowNodeExecutionSync.setState(e, "start_time", new Timestamp(now).toString());
    }

    public void started(Execution e) {
        Node node = (Node)e.getDefine();
        if (node.getCallback() == null) {
            DataFlowNodeExecutionSync.setState(e, "state", "completed");
        } else {
            DataFlowNodeExecutionSync.setState(e, "state", "started");
        }
    }

    public void leapOver(Execution e) {
        DataFlowNodeExecutionSync.setLeapOver(e);
        FiberTask.incLeapOverCount(e);
    }

    public static void setLeapOver(Execution e) {
        DataFlowNodeExecutionSync.setState(e, "state", "leap_over");
        DataFlowNodeExecutionSync.setState(e, "end_time", new Timestamp(System.currentTimeMillis()).toString());
        DataFlowNodeExecutionSync.setElapsedTime(e);
    }

    private static void setElapsedTime(Execution e) {
        long elapsed;
        Long start_time = (Long)e.getTransientProperty("start_time");
        if (start_time == null) {
            Timestamp started = D.t((Object)DataFlowNodeExecutionSync.getState(e, "start_time"));
            if (started == null) {
                return;
            }
            start_time = started.getTime();
        }
        if ((elapsed = System.currentTimeMillis() - start_time) <= 0L) {
            return;
        }
        DataFlowNodeExecutionSync.setState(e, "elapsed", String.valueOf(elapsed));
    }

    public static String getState(Execution e, String key) {
        String name = DataFlowNodeExecutionSync.getStatePropertyName(e, "acts");
        Map acts = (Map)e.getRuntime().getProperty(name);
        if (acts == null) {
            return null;
        }
        String id = e.getDefine().getId();
        Map info = (Map)acts.get(id);
        if (info == null) {
            return null;
        }
        return (String)info.get(key);
    }

    private static void setState(Execution e, String key, String value) {
        FlowRuntime runtime = e.getRuntime();
        String nodeId = e.getDefine().getId();
        DataFlowNodeExecutionSync.innerSetState(runtime, e, nodeId, key, value);
    }

    private static void innerSetState(FlowRuntime runtime, Execution e, String nodeId, String key, String value) {
        HashMap<String, String> info;
        String name = DataFlowNodeExecutionSync.getStatePropertyName(e, "acts");
        LinkedHashMap<String, HashMap<String, String>> acts = (LinkedHashMap<String, HashMap<String, String>>)runtime.getProperty(name);
        if (acts == null) {
            acts = new LinkedHashMap<String, HashMap<String, String>>();
            runtime.setProperty(name, acts);
        }
        if ((info = (HashMap<String, String>)acts.get(nodeId)) == null) {
            info = new HashMap<String, String>();
        }
        info.put(key, value);
        acts.put(nodeId, info);
    }

    public static Map<String, Object> getTraceInfo(FlowRuntime runtime, String nodeId) {
        Map info;
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>(16);
        data.put("node_name", runtime.getFlow().getNode(nodeId).getTitle());
        Map acts = (Map)runtime.getProperty("acts");
        if (acts != null && (info = (Map)acts.get(nodeId)) != null) {
            data.put("state", info.get("state"));
            data.put("start_time", info.get("start_time"));
            data.put("end_time", info.get("end_time"));
            data.put("elapsed", TraceType.getTime((int)D.i(info.get("elapsed"))));
            if (D.x(info.get("is_start"))) {
                data.put("is_start", Boolean.TRUE);
            }
        }
        return data;
    }

    private void setPath(Execution e) {
        String id = e.getTransitionId();
        if (id == null) {
            return;
        }
        String name = DataFlowNodeExecutionSync.getStatePropertyName(e, "trans");
        LinkedHashMap<String, String> trans = (LinkedHashMap<String, String>)e.getRuntime().getProperty(name);
        if (trans == null) {
            trans = new LinkedHashMap<String, String>();
            e.getRuntime().setProperty(name, trans);
        }
        trans.put(id, "true");
    }

    private static String getStatePropertyName(Execution e, String name) {
        ProcessElement parentDefine;
        if (e == null) {
            return name;
        }
        Execution parent = e.getParent();
        while (!"$".equals(parent.getDefine().getId())) {
            parent = parent.getParent();
        }
        if ((parent = parent.getParent()) != null && (parentDefine = parent.getDefine()).getFlow() != e.getDefine().getFlow()) {
            name = parentDefine.getId() + "/" + name;
        }
        return name;
    }

    public static void stop(Execution e, boolean isFiberComplete) {
        e.stop();
        DataFlowNodeExecutionSync.setState(e, "state", "stopped");
        DataFlowNodeExecutionSync.setState(e, "end_time", new Timestamp(System.currentTimeMillis()).toString());
        DataFlowNodeExecutionSync.setElapsedTime(e);
        FiberTask.incCompletedCount(e);
        if (!isFiberComplete) {
            FiberTask.incOmmitedCount(e);
        }
        if (e.getParent().getChildren().size() == 1) {
            FiberTask currentTask = FiberTask.getCurrentTask(e);
            if (isFiberComplete) {
                currentTask.getStream().getCounter().incCompletedCount();
            } else {
                currentTask.getStream().getCounter().incOmmittedCount();
                currentTask.setStopped();
            }
        }
    }

    public static void setStartNode(FlowRuntime runtime, String nodeId) {
        DataFlowNodeExecutionSync.innerSetState(runtime, null, nodeId, "is_start", "true");
    }
}

