/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.runtime.job;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.license.IscLicenseUtil;
import kd.isc.iscb.util.data.LocalCache;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.flow.core.Flow;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.script.context.Context;
import kd.isc.iscx.platform.core.res.runtime.Connector;
import kd.isc.iscx.platform.core.res.runtime.DataFlowDefine;
import kd.isc.iscx.platform.core.res.runtime.LoggerLevel;
import kd.isc.iscx.platform.core.res.runtime.job.DataFiberCounter;
import kd.isc.iscx.platform.core.res.runtime.job.DataStreamJob;
import kd.isc.iscx.platform.core.res.runtime.job.DataTask;
import kd.isc.iscx.platform.core.res.runtime.job.NodeCounter;
import kd.isc.iscx.platform.core.res.runtime.job.WorkArea;
import kd.isc.iscx.platform.core.res.runtime.job.task.DataTaskUtil;
import kd.isc.iscx.platform.core.res.runtime.job.task.FiberTask;
import kd.isc.iscx.platform.core.res.runtime.job.task.FiberUtil;

public class DataStream {
    private long id;
    private String number;
    private DataFlowDefine dataFlow;
    private WorkArea workArea;
    private DataFiberCounter counter;
    private DataStreamJob mainJob;
    private volatile transient Throwable last_error;
    private int execute_count;
    private Object params;
    private transient LocalCache<Object, Object> vc_cache = new LocalCache(8192);
    private volatile Boolean resLicense;

    DataStream(DynamicObject info, DataStreamJob mainJob) {
        this.id = info.getLong("id");
        this.number = info.getString("number");
        this.dataFlow = DataFlowDefine.get(info.getLong("data_flow_def"));
        this.mainJob = mainJob;
        this.workArea = new WorkArea(this);
        this.params = Json.toObject((String)D.s((Object)info.getString("params_tag")));
        this.execute_count = D.i((Object)info.get("execute_count"));
        this.initWorkArea(info);
    }

    public String getContextDigest() {
        StringBuilder sb = new StringBuilder();
        sb.append(ResManager.loadKDString((String)"\u603b\u884c\u6570:", (String)"DataStream_4", (String)"isc-iscx-platform-core", (Object[])new Object[0])).append(this.counter.getTotalCount());
        this.appendCount(sb, ResManager.loadKDString((String)"\u5b8c\u6210", (String)"DataStream_0", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.counter.getCompletedCount());
        this.appendCount(sb, ResManager.loadKDString((String)"\u64a4\u9500", (String)"DataStream_2", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.counter.getTerminatedCount());
        this.appendCount(sb, ResManager.loadKDString((String)"\u5ffd\u7565", (String)"DataStream_3", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.counter.getOmmittedCount());
        Pair<Map<DataTask.State, AtomicInteger>, Map<DataTask.State, AtomicInteger>> p = this.workArea.taskCount();
        Map map0 = (Map)p.getKey();
        this.appendCount(sb, ResManager.loadKDString((String)"\u5931\u8d25", (String)"DataStream_5", (String)"isc-iscx-platform-core", (Object[])new Object[0]), ((AtomicInteger)map0.get((Object)DataTask.State.Failed)).get());
        this.appendCount(sb, ResManager.loadKDString((String)"\u5c31\u7eea", (String)"DataStream_6", (String)"isc-iscx-platform-core", (Object[])new Object[0]), ((AtomicInteger)map0.get((Object)DataTask.State.Ready)).get());
        this.appendCount(sb, ResManager.loadKDString((String)"\u963b\u585e", (String)"DataStream_7", (String)"isc-iscx-platform-core", (Object[])new Object[0]), ((AtomicInteger)map0.get((Object)DataTask.State.Blocked)).get());
        this.appendCount(sb, ResManager.loadKDString((String)"\u7b49\u5f85\u4e2d", (String)"DataStream_8", (String)"isc-iscx-platform-core", (Object[])new Object[0]), ((AtomicInteger)map0.get((Object)DataTask.State.Waiting)).get());
        this.appendCount(sb, ResManager.loadKDString((String)"\u6267\u884c\u4e2d", (String)"DataStream_9", (String)"isc-iscx-platform-core", (Object[])new Object[0]), ((AtomicInteger)map0.get((Object)DataTask.State.Running)).get());
        sb.append("\r\n");
        Map map = (Map)p.getValue();
        int total = 0;
        for (AtomicInteger i : map.values()) {
            total += i.get();
        }
        this.appendCount(sb, ResManager.loadKDString((String)"\u5176\u4ed6\u4efb\u52a1", (String)"DataStream_11", (String)"isc-iscx-platform-core", (Object[])new Object[0]), total);
        this.appendCount(sb, ResManager.loadKDString((String)"\u5931\u8d25", (String)"DataStream_5", (String)"isc-iscx-platform-core", (Object[])new Object[0]), ((AtomicInteger)map.get((Object)DataTask.State.Failed)).get());
        this.appendCount(sb, ResManager.loadKDString((String)"\u5c31\u7eea", (String)"DataStream_6", (String)"isc-iscx-platform-core", (Object[])new Object[0]), ((AtomicInteger)map.get((Object)DataTask.State.Ready)).get());
        this.appendCount(sb, ResManager.loadKDString((String)"\u963b\u585e", (String)"DataStream_7", (String)"isc-iscx-platform-core", (Object[])new Object[0]), ((AtomicInteger)map.get((Object)DataTask.State.Blocked)).get());
        this.appendCount(sb, ResManager.loadKDString((String)"\u7b49\u5f85\u4e2d", (String)"DataStream_8", (String)"isc-iscx-platform-core", (Object[])new Object[0]), ((AtomicInteger)map.get((Object)DataTask.State.Waiting)).get());
        this.appendCount(sb, ResManager.loadKDString((String)"\u6267\u884c\u4e2d", (String)"DataStream_9", (String)"isc-iscx-platform-core", (Object[])new Object[0]), ((AtomicInteger)map.get((Object)DataTask.State.Running)).get());
        sb.append("\r\n");
        return sb.toString();
    }

    public DataStreamJob getMainJob() {
        return this.mainJob;
    }

    public DataFiberCounter getCounter() {
        return this.counter;
    }

    private void appendCount(StringBuilder sb, String state, int count) {
        if (count > 0) {
            if (sb.charAt(sb.length() - 1) != '\n') {
                sb.append(", ");
            }
            sb.append(state).append(':').append(count);
        }
    }

    private void initWorkArea(DynamicObject info) {
        String context = D.s((Object)info.getString("context_tag"));
        if (context == null) {
            this.counter = new DataFiberCounter(0, 0, 0, 0);
            this.initWorkAreaWithParams(this.params);
            FiberUtil.prepareDebugger(this);
        } else {
            Map json = (Map)Json.toObject((String)context);
            this.counter = new DataFiberCounter(D.i(json.get("total")), D.i(json.get("success")), D.i(json.get("terminated")), D.i(json.get("ommitted")));
            this.restoreWorkArea(json);
        }
    }

    private void restoreWorkArea(Map<String, Object> json) {
        long task_sequence = D.l((Object)json.get("task_sequence"));
        this.workArea.setTaskSequence(task_sequence);
        for (Map item : (List)json.get("counter")) {
            String nodeId = (String)item.get("id");
            long elapsed = D.l(item.get("elapsed"));
            int completed = D.i(item.get("completed"));
            int ommited = D.i(item.get("ommited"));
            int leap_over = D.i(item.get("leap_over"));
            NodeCounter c = new NodeCounter(completed, ommited, elapsed, leap_over);
            this.workArea.addNodeCounter(nodeId, c);
        }
        for (Map item : (List)json.get("task")) {
            DataTask t = DataTaskUtil.fromJson(this, item);
            DataTask.State state = t.getState();
            if (state.isClosed()) continue;
            if (!t.compareAndSetState(DataTask.State.Ready, DataTask.State.Failed)) {
                t.compareAndSetState(DataTask.State.Ready, DataTask.State.Blocked);
            }
            this.workArea.enqueue(t);
        }
    }

    private void initWorkAreaWithParams(Object params) {
        if (params instanceof Map) {
            DataTask job = this.dataFlow.getTrigger().createFirstTask(this, (Map)params);
            this.workArea.enqueue(job);
        } else if (params instanceof List) {
            for (Map item : (List)params) {
                DataTask job = this.dataFlow.getTrigger().createFirstTask(this, item);
                this.workArea.enqueue(job);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public long getId() {
        return this.id;
    }

    public String getNumber() {
        return this.number;
    }

    public Object getParams() {
        return this.params;
    }

    public WorkArea getWorkArea() {
        return this.workArea;
    }

    public int getExecuteCount() {
        return this.execute_count;
    }

    public NodeCounter getNodeCounter(String fiberNodeId) {
        return this.workArea.getNodeCounter(fiberNodeId);
    }

    public DataFlowDefine getDataFlow() {
        return this.dataFlow;
    }

    public Flow getFiberFlow() {
        return this.dataFlow.getFiberFlow();
    }

    public Connector getConnector(String connectorAlias) {
        return this.dataFlow.getConnector(connectorAlias);
    }

    public LoggerLevel getLoggerLevel() {
        return this.dataFlow.getLoggerLevel();
    }

    public void addElapsedTime(String nodeId, long startTime) {
        long elapsed = System.currentTimeMillis() - startTime;
        this.getNodeCounter(nodeId).add(elapsed);
    }

    public static void addElapsedTime(Execution e, long startTime) {
        FiberTask task = FiberTask.getCurrentTask(e.getRuntime());
        String nodeId = e.getDefine().getId();
        task.getStream().addElapsedTime(nodeId, startTime);
    }

    public FiberTask getFiberTask(Long fiberId) {
        return this.workArea.getFiberTask(fiberId);
    }

    public int fiberTaskCount(String startNodeId) {
        return this.workArea.fiberTaskCount(startNodeId);
    }

    public Context getContext() {
        return new Context(){

            public Object get(String property) {
                if ("last_error".equals(property)) {
                    return DataStream.this.last_error;
                }
                if ("number".equals(property)) {
                    return DataStream.this.number;
                }
                if ("start_time".equals(property)) {
                    return DataStream.this.mainJob.getStartTime();
                }
                if ("params".equals(property)) {
                    return DataStream.this.params;
                }
                if ("execute_count".equals(property)) {
                    return DataStream.this.execute_count;
                }
                if ("stream_id".equals(property)) {
                    return DataStream.this.id;
                }
                if ("stream_number".equals(property)) {
                    return DataStream.this.number;
                }
                if ("trigger_id".equals(property)) {
                    return DataStream.this.dataFlow.getDataFlowTriggerId();
                }
                if ("trigger_number".equals(property)) {
                    return DataStream.this.dataFlow.getDataFlowTriggerNumber();
                }
                if ("total".equals(property)) {
                    return DataStream.this.counter.getTotalCount();
                }
                if ("success".equals(property)) {
                    return DataStream.this.counter.getCompletedCount();
                }
                if ("terminated".equals(property)) {
                    return DataStream.this.counter.getTerminatedCount();
                }
                if ("ommitted".equals(property)) {
                    return DataStream.this.counter.getOmmittedCount();
                }
                if ("state".equals(property)) {
                    return DataStream.this.workArea.getDataStreamState().name();
                }
                return null;
            }

            public boolean set(String property, Object value) {
                return false;
            }

            public boolean contains(String property) {
                return false;
            }
        };
    }

    void setLastError(Throwable error) {
        if (error != null) {
            this.last_error = error;
        }
    }

    public boolean isWorkAreaFull() {
        return this.workArea.isFull();
    }

    public LocalCache<Object, Object> getCache() {
        return this.vc_cache;
    }

    public Map<String, Object> getState() {
        LinkedHashMap<String, Object> state = new LinkedHashMap<String, Object>();
        state.put("state", this.workArea.getDataStreamState().toString());
        state.put("id", this.id);
        state.put("number", this.number);
        state.put("total_count", this.counter.getTotalCount());
        state.put("completed_count", this.counter.getCompletedCount());
        state.put("terminated_count", this.counter.getTerminatedCount());
        state.put("ommitted_count", this.counter.getOmmittedCount());
        state.put("last_error", this.last_error);
        return state;
    }

    public static Map<String, Object> getState(DynamicObject info) {
        LinkedHashMap<String, Object> state = new LinkedHashMap<String, Object>();
        state.put("state", info.get("state"));
        state.put("id", info.get("id"));
        state.put("number", info.get("number"));
        Map json = (Map)Json.toObject((String)info.getString("context_tag"));
        state.put("total_count", D.i(json.get("total")));
        state.put("completed_count", D.i(json.get("success")));
        state.put("terminated_count", D.i(json.get("terminated")));
        state.put("ommitted_count", D.i(json.get("ommitted")));
        return state;
    }

    public boolean hasLicense() {
        Boolean resLicense = this.resLicense;
        if (resLicense == null) {
            resLicense = this.resLicense = Boolean.valueOf(IscLicenseUtil.resHasLicense((String)"iscx_resource", (long)this.getDataFlow().getDataFlowResId()));
        }
        return resLicense;
    }
}

