/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.runtime.job;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.IscRuntimeInfo;
import kd.isc.iscb.platform.core.dc.e.DataCopyRunner;
import kd.isc.iscb.platform.core.dc.e.MQueueWriter;
import kd.isc.iscb.platform.core.dc.meta.DataCopyConsumer;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.except.TaskCancelException;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.context.Context;
import kd.isc.iscx.platform.core.res.meta.ds.NoticeSend;
import kd.isc.iscx.platform.core.res.runtime.job.DataStream;
import kd.isc.iscx.platform.core.res.runtime.job.DataStreamJobFactory;
import kd.isc.iscx.platform.core.res.runtime.job.DataStreamProgress;
import kd.isc.iscx.platform.core.res.runtime.job.DataStreamState;
import kd.isc.iscx.platform.core.res.runtime.job.DataTask;
import kd.isc.iscx.platform.core.res.runtime.job.TriggerMessageParam;
import kd.isc.iscx.platform.core.res.runtime.job.Util;
import kd.isc.iscx.platform.core.res.runtime.job.WorkArea;

public final class DataStreamJob
implements Job {
    private long id;
    private String number;
    private long mutex;
    private boolean isLight;
    private volatile DataStream stream;
    private Timestamp start_time;
    private static Log logger = LogFactory.getLog(DataStreamJob.class);
    private AtomicInteger threadCount = new AtomicInteger(0);

    public DataStreamJob(long id, String number, long mutex, boolean isLightJob) {
        this.id = id;
        this.number = number;
        this.mutex = mutex;
        this.isLight = isLightJob;
    }

    DataStreamJob(String number, String param) {
        this.number = number;
        String[] s = param.split(",");
        this.id = D.l((Object)s[0]);
        this.mutex = D.l((Object)s[1]);
        this.isLight = D.x((Object)s[2]);
    }

    public String getParam() {
        return this.id + "," + this.mutex + "," + this.isLight;
    }

    public String getTitle() {
        return this.number;
    }

    public boolean isLightTask() {
        return this.isLight;
    }

    public Date getStartTime() {
        return this.start_time;
    }

    public JobFactory getFactory() {
        return new DataStreamJobFactory();
    }

    public long getOwnerId() {
        return this.id;
    }

    public long getMutex() {
        return this.mutex;
    }

    public DataStream getStream() {
        return this.stream;
    }

    public Job.Progress getRealtimeProgress() {
        if (this.stream == null) {
            return null;
        }
        int total = this.stream.getCounter().getTotalCount();
        int success = this.stream.getCounter().getCompletedCount();
        int ommittedCount = this.stream.getCounter().getOmmittedCount();
        int failed = this.stream.getCounter().getFailedCount();
        WorkArea workArea = this.stream.getWorkArea();
        int workAreaSize = workArea.dataJobsCount();
        long elapsed = Math.max(1L, (System.currentTimeMillis() - this.start_time.getTime()) / 1000L);
        String v3 = this.threadCount + ", " + elapsed;
        String description = String.format(ResManager.loadKDString((String)"%1$s\u5de5\u4f5c\u533a:%2$s, \u7ebf\u7a0b\u6570\uff1a%3$s", (String)"DataStreamJob_3", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.stream.getContextDigest(), workAreaSize, v3);
        return new Job.Progress((long)total, (long)(success + failed + ommittedCount), description);
    }

    public String getJobSummary() {
        if (this.stream == null) {
            return "";
        }
        String s = this.stream.getContextDigest();
        if (this.stream.getWorkArea().isFull()) {
            s = s + ", ";
            s = s + ResManager.loadKDString((String)"\u5de5\u4f5c\u533a: \u6ee1\u8f7d", (String)"DataStreamJob_2", (String)"isc-iscx-platform-core", (Object[])new Object[0]);
        }
        return s.trim();
    }

    public void run() {
        if (this.setRunning()) {
            try {
                this.execute();
            }
            catch (Throwable e) {
                if (!(e instanceof TaskCancelException)) {
                    Util.saveErrorLog(this.stream, e);
                }
                throw e;
            }
            finally {
                this.handleRetry();
            }
        }
    }

    public void executeWithoutRetry() {
        if (!this.setRunning()) {
            String message = String.format(ResManager.loadKDString((String)"\u6570\u636e\u6d41\uff08%s\uff09\u6b63\u5728\u6267\u884c\u4e2d\u6216\u5df2\u7ed3\u675f\u3002", (String)"DataStreamJob_4", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.number);
            throw new IscBizException(message);
        }
        this.execute();
    }

    private void execute() {
        try {
            this.publishStartMessage();
            IscRuntimeInfo.get().incDataFlowExecuteTotalCount();
            this.tryDeleteLogs();
            SignalManager.registerTask((String)D.s((Object)this.id));
            ScheduleManager.submit((Task)new DataStreamProgress(this), (int)5);
            this.doMainTask();
        }
        catch (TaskCancelException e) {
            this.stream.getWorkArea().terminate();
            throw e;
        }
        finally {
            SignalManager.unregisterTask((String)D.s((Object)this.id));
            this.waitForSubTasks();
            this.updateStateAndDisposeTask();
            this.publishEndMessage();
            this.sendDataStreamNotice();
        }
    }

    private void handleRetry() {
        int retryIndex;
        if (this.stream.getWorkArea().getDataStreamState().isFailed() && (retryIndex = this.stream.getExecuteCount() - 1) < this.stream.getDataFlow().getMaxRetryTimes()) {
            int delay = this.stream.getDataFlow().getRetryInterval(retryIndex) * 60000;
            DataStreamJob job = new DataStreamJob(this.id, this.number, this.mutex, this.isLight);
            JobEngine.submit((Job)job, (Timestamp)new Timestamp(System.currentTimeMillis() + (long)delay));
        }
    }

    private void publishStartMessage() {
        try {
            long id = this.stream.getDataFlow().getStartMqTopic();
            this.publishMsg(id, "IscxDataFlowEventStart");
        }
        catch (Exception e) {
            logger.warn("\u6570\u636e\u6d41\u542f\u52a8\u65b9\u6848\u6267\u884c\u65f6\u901a\u77e5mq\u53d1\u751f\u9519\u8bef,\u542f\u52a8\u65b9\u6848id:" + this.stream.getDataFlow().getDataFlowTriggerId(), (Throwable)e);
        }
    }

    private void publishEndMessage() {
        try {
            long id = this.stream.getDataFlow().getEndMqTopic();
            this.publishMsg(id, "IscxDataFlowEventEnd");
        }
        catch (Exception e) {
            logger.warn("\u6570\u636e\u6d41\u542f\u52a8\u65b9\u6848\u7ed3\u675f\u65f6\u56de\u8c03mq\u53d1\u751f\u9519\u8bef,\u542f\u52a8\u65b9\u6848id:" + this.stream.getDataFlow().getDataFlowTriggerId(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishMsg(long topicId, String type) {
        if (topicId != 0L) {
            TriggerMessageParam messageParam = new TriggerMessageParam(topicId, 1);
            try (MQueueWriter writer = null;){
                Map<String, Object> msg = this.buildMsg(type);
                writer = new MQueueWriter((DataCopyConsumer)messageParam);
                writer.write(msg);
            }
        }
    }

    private Map<String, Object> buildMsg(String type) {
        Context context = this.stream.getContext();
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put("stream_id", context.get("stream_id"));
        data.put("stream_number", context.get("stream_number"));
        data.put("trigger_id", context.get("trigger_id"));
        data.put("trigger_number", context.get("trigger_number"));
        data.put("state", context.get("state"));
        data.put("total", context.get("total"));
        data.put("success", context.get("success"));
        data.put("terminated", context.get("terminated"));
        data.put("ommitted", context.get("ommitted"));
        data.put("start_time", context.get("start_time"));
        data.put("params", context.get("params"));
        data.put("execute_count", context.get("execute_count"));
        data.put("last_error", StringUtil.getCascadeMessage((Throwable)((Throwable)context.get("last_error"))));
        data.put("type", type);
        return data;
    }

    private void sendDataStreamNotice() {
        NoticeSend notice;
        DataStreamState state = this.stream.getWorkArea().getDataStreamState();
        if (state.isFailed()) {
            NoticeSend notice2 = this.stream.getDataFlow().getFailedNotice();
            if (notice2 != null) {
                notice2.send(this.createContext(), NoticeSend.NoticeType.warning);
            }
        } else if (DataStreamState.S == state && (notice = this.stream.getDataFlow().getSuccessNotice()) != null) {
            notice.send(this.createContext(), NoticeSend.NoticeType.message);
        }
    }

    private Map<String, Object> createContext() {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("$data", this.stream.getParams());
        ctx.put("$flow", this.stream.getFiberFlow());
        ctx.put("$stream", this.stream.getContext());
        return ctx;
    }

    private void doMainTask() {
        while (this.stream.getWorkArea().resetRunning()) {
            try {
                this.doTask();
            }
            catch (Throwable error) {
                this.handleUnexpectedError(error);
            }
        }
    }

    private void handleUnexpectedError(Throwable error) {
        if (error instanceof TaskCancelException) {
            throw (TaskCancelException)error;
        }
        Util.saveErrorLog(this.stream, error);
    }

    private void waitForSubTasks() {
        WorkArea workArea = this.stream.getWorkArea();
        while (workArea.getCurrentThreads() > 1) {
            D.sleep((long)20L);
        }
        if (workArea.resetRunning()) {
            Util.saveErrorLog(this.stream, new Exception("workArea.resetRunning() = true"));
        }
    }

    private void tryDeleteLogs() {
        if (D.i((Object)this.stream.getExecuteCount()) > 1) {
            Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
            try {
                String sql = "DELETE FROM t_iscx_data_stream_log WHERE fdata_stream=?";
                DbUtil.executeUpdate((Connection)cn, (String)sql, (List)D.asList((Object[])new Object[]{this.id}), (List)D.asList((Object[])new Integer[]{-5}));
            }
            finally {
                DbUtil.close((Connection)cn, (boolean)true);
            }
        }
    }

    private void updateStateAndDisposeTask() {
        try {
            this.stream.getWorkArea().dispose();
        }
        finally {
            DataStreamState.update(this.stream);
            if (this.stream.getWorkArea().getDataStreamState().isFailed()) {
                IscRuntimeInfo.get().incDataFlowExecuteFailedCount();
            }
        }
    }

    private boolean setRunning() {
        boolean b = DataStreamState.setRunning(this.id);
        if (b) {
            this.start_time = new Timestamp(System.currentTimeMillis());
            DynamicObject info = BusinessDataServiceHelper.loadSingle((Object)this.id, (String)"iscx_data_stream");
            this.stream = new DataStream(info, this);
            this.stream.getWorkArea().setRunning();
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTask() {
        this.threadCount.incrementAndGet();
        try {
            WorkArea workArea = this.stream.getWorkArea();
            int nullCount = 0;
            while (true) {
                DataTask task;
                if ((task = workArea.dequeue()) != null) {
                    try {
                        nullCount = 0;
                        task.run();
                    }
                    finally {
                        workArea.release(task);
                    }
                    continue;
                }
                if (++nullCount <= 5) {
                    D.sleep((long)1L);
                    continue;
                }
                break;
            }
        }
        finally {
            this.threadCount.decrementAndGet();
        }
    }

    void startSubTaskThread() {
        final List tasks = SignalManager.currentTasks();
        DataCopyRunner.submitDataStreamTask((Task)new Task(){
            private String id = UUID.randomUUID().toString();

            public String getId() {
                return this.id;
            }

            public void run() {
                try {
                    SignalManager.registerOnSubTaskBegin((List)tasks);
                    try {
                        DataStreamJob.this.doTask();
                    }
                    finally {
                        SignalManager.unregisterOnSubTaskEnd();
                    }
                }
                finally {
                    DataStreamJob.this.stream.getWorkArea().decCurrentThreads();
                }
            }
        });
    }
}

