/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.runtime.job;

import java.util.UUID;
import kd.isc.iscb.platform.core.task.DaemonTask;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscx.platform.core.res.runtime.job.DataStreamJob;
import kd.isc.iscx.platform.core.res.runtime.job.DataStreamState;

public class DataStreamProgress
implements DaemonTask {
    private String id = UUID.randomUUID().toString();
    private DataStreamJob job;
    private long last_flush_all_time;
    private long last_flush_progress_time;
    private long flush_interval;

    public String getId() {
        return this.id;
    }

    public DataStreamProgress(DataStreamJob job) {
        this.job = job;
        this.flush_interval = Math.max(5000, 1000 * job.getStream().getDataFlow().getCheckPoint());
        this.last_flush_all_time = this.last_flush_progress_time = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean affected = true;
        try {
            if (this.job.getStream().getWorkArea().resetRunning()) {
                boolean flushProgress;
                boolean flushAll;
                long now = System.currentTimeMillis();
                boolean bl = flushAll = now - this.last_flush_all_time >= this.flush_interval;
                if (flushAll) {
                    affected = DataStreamState.refresh(this.job.getStream());
                    this.last_flush_all_time = now;
                    this.last_flush_progress_time = now;
                }
                boolean bl2 = flushProgress = now - this.last_flush_progress_time >= 5000L;
                if (flushProgress) {
                    affected = DataStreamState.refreshProgress(this.job.getStream());
                    this.last_flush_progress_time = now;
                }
            } else {
                affected = false;
            }
        }
        finally {
            if (affected) {
                ScheduleManager.submit((Task)this, (int)1);
            }
        }
    }
}

