/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.runtime.job;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.List;
import kd.bos.db.tx.TX;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscx.platform.core.res.runtime.job.DataStream;

public enum DataStreamState {
    C,
    R,
    F{

        @Override
        public boolean isFailed() {
            return true;
        }
    }
    ,
    P{

        @Override
        public boolean isFailed() {
            return true;
        }
    }
    ,
    S,
    X,
    A,
    U;


    public boolean isFailed() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean setRunning(long id) {
        String sql = "UPDATE t_iscx_datax_stream SET fstate='R',fexecute_count =fexecute_count+1, fstart_time=?, fmodifytime=? WHERE fid=? AND (fstate IN('C','F','A','U','P','H','B') OR (fstate = 'R' AND fmodifytime < ?))";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            Timestamp now = new Timestamp(System.currentTimeMillis());
            Timestamp now_15s = new Timestamp(System.currentTimeMillis() - 15000L);
            int affected = DbUtil.executeUpdate((Connection)cn, (String)sql, (List)D.asList((Object[])new Object[]{now, now, id, now_15s}), (List)D.asList((Object[])new Integer[]{93, 93, -5, 93}));
            boolean bl = affected == 1;
            return bl;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    public static void update(DataStream stream) {
        String sql = "UPDATE t_iscx_datax_stream SET fstate=?,fmodifytime=?,fcontext=?,fcontext_tag=?, fhost = ? WHERE fid=?";
        DataStreamState.save(stream, sql);
    }

    public static boolean refresh(DataStream stream) {
        String sql = "UPDATE t_iscx_datax_stream SET fstate=?,fmodifytime=?,fcontext=?,fcontext_tag=?, fhost = ? WHERE fid=? AND fstate = 'R'";
        return DataStreamState.save(stream, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean save(DataStream stream, String sql) {
        long id = stream.getId();
        DataStreamState state = stream.getWorkArea().getDataStreamState();
        String contextDigest = stream.getContextDigest();
        String contextTag = stream.getWorkArea().generateContextJson();
        String host = StringUtil.trim((String)NetUtil.getServerId(), (int)50);
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            Timestamp now = new Timestamp(System.currentTimeMillis());
            int affected = DbUtil.executeUpdate((Connection)cn, (String)sql, (List)D.asList((Object[])new Object[]{state.name(), now, contextDigest, contextTag, host, id}), (List)D.asList((Object[])new Integer[]{12, 93, 12, 12, 12, -5}));
            boolean bl = affected == 1;
            return bl;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean refreshProgress(DataStream stream) {
        String sql = "UPDATE t_iscx_datax_stream SET fstate=?,fmodifytime=?,fcontext=?,fhost = ? WHERE fid=? AND fstate = 'R'";
        long id = stream.getId();
        DataStreamState state = stream.getWorkArea().getDataStreamState();
        String contextDigest = stream.getContextDigest();
        String host = StringUtil.trim((String)NetUtil.getServerId(), (int)50);
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            Timestamp now = new Timestamp(System.currentTimeMillis());
            int affected = DbUtil.executeUpdate((Connection)cn, (String)sql, (List)D.asList((Object[])new Object[]{state.name(), now, contextDigest, host, id}), (List)D.asList((Object[])new Integer[]{12, 93, 12, 12, -5}));
            boolean bl = affected == 1;
            return bl;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }
}

