/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.runtime.job;

import java.sql.Timestamp;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.except.TaskCancelException;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.flow.core.FlowRuntime;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscx.platform.core.res.runtime.LoggerLevel;
import kd.isc.iscx.platform.core.res.runtime.job.AbstractBatchApplication;
import kd.isc.iscx.platform.core.res.runtime.job.DataStream;
import kd.isc.iscx.platform.core.res.runtime.job.Util;
import kd.isc.iscx.platform.core.res.runtime.job.WorkArea;
import kd.isc.iscx.platform.core.res.runtime.job.task.FiberTask;

public abstract class DataTask {
    private long id;
    private volatile State state;
    private DataStream stream;
    private transient Throwable error;
    private volatile OnRelease onRelease;

    protected DataTask(DataStream stream) {
        this.stream = stream;
        this.id = stream.getWorkArea().incTaskSequence();
        this.state = State.Ready;
    }

    protected DataTask(DataStream stream, Map<String, Object> json) {
        this.stream = stream;
        this.id = D.l((Object)json.get("id"));
        this.state = State.valueOf(D.s((Object)json.get("state")));
    }

    public final Map<String, Object> toJson() {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        json.put("id", this.id);
        json.put("state", (Object)this.state);
        json.put("type", this.getClass().getName());
        this.innerToJson(json);
        return json;
    }

    public Throwable getError() {
        return this.error;
    }

    public final DataStream getStream() {
        return this.stream;
    }

    public final long getId() {
        return this.id;
    }

    public final State getState() {
        return this.state;
    }

    public final boolean isRunning() {
        return State.Running == this.state;
    }

    public final boolean isReady() {
        return State.Ready == this.state;
    }

    protected final synchronized void setState(State state) {
        if (!this.state.isClosed()) {
            this.state = state;
        }
    }

    protected final void resumeBatch(List<AbstractBatchApplication.Data> batch) {
        WorkArea workArea = this.stream.getWorkArea();
        for (AbstractBatchApplication.Data d : batch) {
            String executionId;
            FiberTask task = d.getTask();
            if (task.getState().isClosed()) continue;
            FlowRuntime runtime = task.getFlowRuntime();
            Execution e = runtime.getExecution(executionId = d.getExecutionId());
            if (!e.isAppStarted()) {
                workArea.moveToReady(task);
                continue;
            }
            if (runtime.inject(executionId, null)) {
                workArea.moveToReady(task);
                continue;
            }
            throw new IscBizException(ResManager.loadKDString((String)"\u4e0d\u53ef\u80fd\u7684\u9519\u8bef\uff0c\u5524\u9192\u6570\u636e\u7ebf\u4efb\u52a1\u5931\u8d25\u3002", (String)"WorkArea_4", (String)"isc-iscx-platform-core", (Object[])new Object[0]));
        }
    }

    protected void appFailed(List<AbstractBatchApplication.Data> batch, Throwable error) {
        WorkArea workArea = this.stream.getWorkArea();
        for (AbstractBatchApplication.Data d : batch) {
            String executionId;
            FiberTask task = d.getTask();
            if (task.getState().isClosed()) continue;
            FlowRuntime runtime = task.getFlowRuntime();
            Execution e = runtime.getExecution(executionId = d.getExecutionId());
            if (!e.isAppStarted()) {
                workArea.moveToReady(task);
                continue;
            }
            e.appFailed(error);
            workArea.moveToReady(task);
        }
    }

    protected synchronized boolean compareAndSetState(State state, State original) {
        if (this.state == original) {
            this.state = state;
            return true;
        }
        return false;
    }

    public synchronized void setOnRelease(OnRelease r) {
        if (this.state != State.Running) {
            throw new RuntimeException(this + " is running.");
        }
        if (this.onRelease != null) {
            throw new RuntimeException(this + "'s onRelease is set.");
        }
        this.onRelease = r;
    }

    public synchronized OnRelease takeOnRelease() {
        OnRelease r = this.onRelease;
        this.onRelease = null;
        return r != null ? r : new OnRelease(){

            @Override
            public void doSomething() {
            }
        };
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "." + this.id + "." + (Object)((Object)this.state);
    }

    public final void run() {
        ConnectionManager.pushResLicense((boolean)this.getStream().hasLicense());
        try {
            SignalManager.checkCancelSignal();
            if (this.compareAndSetState(State.Running, State.Ready)) {
                this.doJob();
            }
        }
        catch (Throwable error) {
            this.handleError(error);
        }
        finally {
            ConnectionManager.popResLicense();
            this.postHandle();
        }
    }

    private void handleError(Throwable error) {
        this.error = error;
        if (error instanceof TaskCancelException) {
            this.setState(State.Terminated);
            throw (TaskCancelException)error;
        }
        this.setState(State.Failed);
    }

    private void postHandle() {
        try {
            this.compareAndSetState(State.Ready, State.Running);
            if (this.getState().isClosed()) {
                this.close();
            }
        }
        finally {
            this.saveErrorLog();
            DataTask.saveTaskTrace(this);
        }
    }

    static void saveTaskTrace(DataTask t) {
        if (t.state.isClosed() && t.stream.getLoggerLevel() == LoggerLevel.ALL) {
            DynamicObject trace = BusinessDataServiceHelper.newDynamicObject((String)"iscx_data_stream_trace");
            trace.set("state", (Object)t.getState().toString());
            trace.set("type", (Object)t.getClass().getSimpleName());
            trace.set("time", (Object)new Timestamp(System.currentTimeMillis()));
            trace.set("data_stream", (Object)t.stream.getId());
            trace.set("data", (Object)StringUtil.trim((String)t.getContextDigest(), (int)80));
            trace.set("data_tag", (Object)Json.toString(t.toJson()));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{trace});
        }
    }

    public final String getContextDigest() {
        try {
            return this.innerGetContextDigest();
        }
        catch (Throwable e) {
            return StringUtil.getCascadeMessage((Throwable)e);
        }
    }

    private void saveErrorLog() {
        if (this.error != null) {
            Util.saveErrorLog(this.getStream(), this.error, this);
        }
    }

    protected final void enqueue(FiberTask job) {
        this.getStream().getWorkArea().enqueue(job);
    }

    protected abstract String innerGetContextDigest();

    protected abstract void innerToJson(Map<String, Object> var1);

    protected abstract void doJob();

    public abstract void close();

    public abstract boolean isResumeable();

    public static enum State {
        Ready,
        Running,
        Blocked,
        Waiting,
        Failed,
        Terminated{

            @Override
            public boolean isClosed() {
                return true;
            }
        }
        ,
        Success{

            @Override
            public boolean isClosed() {
                return true;
            }
        }
        ,
        Stopped{

            @Override
            public boolean isClosed() {
                return true;
            }
        };


        public boolean isClosed() {
            return false;
        }
    }

    public static interface OnRelease {
        public void doSomething();
    }
}

