/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.runtime.job;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.data.Heap;
import kd.isc.iscx.platform.core.res.runtime.job.DataTask;
import kd.isc.iscx.platform.core.res.runtime.job.task.FiberTask;
import kd.isc.iscx.platform.core.res.runtime.job.task.StreamTask;

class DataTaskQueue {
    private LinkedList<DataTask> d_queue = new LinkedList();
    private Heap<StreamTask> heap = new Heap();
    private Set<DataTask> set = new HashSet<DataTask>();
    private int terminalCount;

    DataTaskQueue(int terminalCount) {
        this.terminalCount = terminalCount;
    }

    boolean isEmpty() {
        return this.set.isEmpty();
    }

    void clear() {
        this.d_queue.clear();
        this.heap.clear();
        this.set.clear();
    }

    int size() {
        return this.set.size();
    }

    void enqueue(DataTask t) {
        if (this.set.add(t)) {
            if (t instanceof StreamTask) {
                this.heap.push((Comparable)((StreamTask)t));
            } else if (t instanceof FiberTask) {
                this.d_queue.addLast(t);
            } else {
                this.d_queue.addFirst(t);
            }
        } else {
            String message = String.format(ResManager.loadKDString((String)"\u4efb\u52a1\uff08%s\uff09\u88ab\u91cd\u590d\u5165\u961f\u3002", (String)"DataTaskQueue_2", (String)"isc-iscx-platform-core", (Object[])new Object[0]), t.getClass().getSimpleName() + "/" + t.getId());
            throw new UnsupportedOperationException(message);
        }
    }

    DataTask dequeue() {
        DataTask t = this.innerDequeue();
        if (t != null) {
            this.set.remove(t);
        }
        return t;
    }

    private DataTask innerDequeue() {
        if (this.terminalCount == 0) {
            if (!this.heap.isEmpty()) {
                return (DataTask)((Object)this.heap.pop());
            }
            if (!this.d_queue.isEmpty()) {
                return this.d_queue.removeFirst();
            }
            return null;
        }
        if (!this.d_queue.isEmpty()) {
            return this.d_queue.removeFirst();
        }
        if (!this.heap.isEmpty()) {
            return (DataTask)((Object)this.heap.pop());
        }
        return null;
    }
}

