/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.runtime.job;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class NodeCounter {
    private AtomicInteger completed_count;
    private AtomicInteger ommited_count;
    private AtomicLong time_elapsed;
    private AtomicInteger leap_over_count;

    public NodeCounter(int completed_count, int ommited_count, long time_elapsed, int leap_over_count) {
        this.completed_count = new AtomicInteger(completed_count);
        this.time_elapsed = new AtomicLong(time_elapsed);
        this.ommited_count = new AtomicInteger(ommited_count);
        this.leap_over_count = new AtomicInteger(leap_over_count);
    }

    public void add(long milliseconds) {
        this.time_elapsed.addAndGet(milliseconds);
    }

    public void incCompletedCount() {
        this.completed_count.incrementAndGet();
    }

    public void incOmmitedCount() {
        this.ommited_count.incrementAndGet();
    }

    public void incLeapOverCount() {
        this.leap_over_count.incrementAndGet();
    }

    public long getTimeElapsed() {
        return this.time_elapsed.get();
    }

    public int getCompletedCount() {
        return this.completed_count.get();
    }

    public int getOmmitedCount() {
        return this.ommited_count.get();
    }

    public int getLeapOverCount() {
        return this.leap_over_count.get();
    }
}

