/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.runtime.job;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.util.except.TaskCancelException;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.flow.core.ProcessElement;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscx.platform.core.res.meta.dm.AbstractDataModel;
import kd.isc.iscx.platform.core.res.runtime.DataFlowException;
import kd.isc.iscx.platform.core.res.runtime.DataHandler;
import kd.isc.iscx.platform.core.res.runtime.job.DataStream;
import kd.isc.iscx.platform.core.res.runtime.job.DataTask;

public class Util {
    public static Map<String, Object> getOutputData(Execution e, DataHandler res) {
        String var = res.getOutput().getVariableName();
        Map tar = (Map)e.get(var);
        if (tar == null) {
            e.set(var, new HashMap());
            tar = (Map)e.get(var);
        }
        return tar;
    }

    public static Map<String, Object> getInputData(Execution e, DataHandler res) {
        AbstractDataModel input = res.getInput();
        Map src = (Map)e.get(input.getVariableName());
        ProcessElement node = e.getDefine();
        if (src == null) {
            throw new DataFlowException(node.getId(), node.getTitle(), String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u672a\u8d4b\u503c\u3002", (String)"Util_8", (String)"isc-iscx-platform-core", (Object[])new Object[0]), input.getName()));
        }
        if (src.isEmpty()) {
            throw new DataFlowException(node.getId(), node.getTitle(), String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5404\u5b57\u6bb5\u90fd\u6ca1\u6709\u8d4b\u503c\u3002", (String)"Util_9", (String)"isc-iscx-platform-core", (Object[])new Object[0]), input.getName()));
        }
        return src;
    }

    static void saveErrorLog(DataStream stream, Throwable error) {
        Util.saveErrorLog(stream, error, null);
    }

    static void saveErrorLog(DataStream stream, Throwable error, DataTask task) {
        if (error instanceof TaskCancelException) {
            return;
        }
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"iscx_data_stream_log");
        log.set("time", (Object)new Timestamp(System.currentTimeMillis()));
        log.set("host", (Object)StringUtil.trim((String)NetUtil.getServerId(), (int)50));
        log.set("data_stream", (Object)stream.getId());
        if (error instanceof DataFlowException) {
            DataFlowException e = (DataFlowException)((Object)error);
            log.set("node", (Object)e.getNodeId());
            log.set("node_title", (Object)e.getNodeTitle());
            log.set("data", (Object)StringUtil.trim((String)e.getDataDigest(), (int)80));
            log.set("data_tag", (Object)StringUtil.trim((String)e.getDataJson(), (int)800000));
        }
        log.set("error", (Object)StringUtil.trim((String)StringUtil.getCascadeMessage((Throwable)error), (int)120));
        log.set("error_tag", (Object)StringUtil.toString((Throwable)error));
        if (task != null) {
            log.set("task_type", (Object)task.getClass().getSimpleName());
            log.set("task_context", (Object)StringUtil.trim((String)task.getContextDigest(), (int)80));
            log.set("task_context_tag", (Object)Json.toString(task.toJson()));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
    }
}

