/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.runtime.job;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscx.platform.core.res.runtime.DataFlowDefine;
import kd.isc.iscx.platform.core.res.runtime.job.DataFiberCounter;
import kd.isc.iscx.platform.core.res.runtime.job.DataStream;
import kd.isc.iscx.platform.core.res.runtime.job.DataStreamState;
import kd.isc.iscx.platform.core.res.runtime.job.DataTask;
import kd.isc.iscx.platform.core.res.runtime.job.DataTaskQueue;
import kd.isc.iscx.platform.core.res.runtime.job.NodeCounter;
import kd.isc.iscx.platform.core.res.runtime.job.task.BatchTask;
import kd.isc.iscx.platform.core.res.runtime.job.task.FiberTask;
import kd.isc.iscx.platform.core.res.runtime.job.task.FiberUtil;
import kd.isc.iscx.platform.core.res.runtime.job.task.StreamTask;

public final class WorkArea {
    private AtomicLong taskSequence = new AtomicLong(0L);
    private final ConcurrentHashMap<String, NodeCounter> nodeCounters = new ConcurrentHashMap();
    private final Map<String, AtomicInteger> fiberTaskCounters = new HashMap<String, AtomicInteger>(16);
    private final Map<Long, DataTask> dataTasks = new LinkedHashMap<Long, DataTask>();
    private final Set<DataTask> runningTaskPool = new HashSet<DataTask>();
    private final DataTaskQueue readyTaskQueue;
    private final Set<StreamTask> blockedStreamTaskPool = new HashSet<StreamTask>();
    private final Map<String, BatchTask> blockedBatchTaskPool = new HashMap<String, BatchTask>();
    private final Map<Long, String> jsonBuffer = new HashMap<Long, String>();
    private final DataStream stream;
    private final int capacity;
    private final int capacityThreshold;
    private final int maxThreads;
    private int currentThreads;
    private boolean is_running = false;
    private boolean has_failed = false;
    private boolean has_terminated = false;

    WorkArea(DataStream stream) {
        this.stream = stream;
        DataFlowDefine dataFlow = stream.getDataFlow();
        this.maxThreads = FiberUtil.isDebug(stream) ? 1 : Math.max(1, dataFlow.getMaxThreads());
        this.capacity = Math.max(5, dataFlow.getWorkAreaSize());
        this.capacityThreshold = this.capacity * 9 / 10;
        this.readyTaskQueue = new DataTaskQueue(dataFlow.getTerminalNodeCount());
        for (String nodeId : dataFlow.getFiberFlow().getNodes().keySet()) {
            this.fiberTaskCounters.put(nodeId, new AtomicInteger(0));
        }
    }

    synchronized boolean isRunning() {
        return this.is_running;
    }

    synchronized DataStreamState getDataStreamState() {
        if (this.is_running) {
            return DataStreamState.R;
        }
        if (this.has_terminated) {
            return DataStreamState.X;
        }
        if (this.has_failed) {
            if (this.stream.getCounter().getCompletedCount() > 0) {
                return DataStreamState.P;
            }
            return DataStreamState.F;
        }
        if (this.dataTasks.isEmpty()) {
            return DataStreamState.S;
        }
        return DataStreamState.U;
    }

    synchronized void setRunning() {
        this.is_running = true;
        this.currentThreads = 1;
    }

    synchronized void terminate() {
        this.has_terminated = true;
        this.readyTaskQueue.clear();
        this.blockedBatchTaskPool.clear();
        this.blockedStreamTaskPool.clear();
        this.jsonBuffer.clear();
        Iterator<Map.Entry<Long, DataTask>> i = this.dataTasks.entrySet().iterator();
        while (i.hasNext()) {
            DataTask t = i.next().getValue();
            DataTask.State state = t.getState();
            if (state == DataTask.State.Running || !t.compareAndSetState(DataTask.State.Terminated, state)) continue;
            DataTask.saveTaskTrace(t);
            i.remove();
        }
        this.resetRunning();
    }

    synchronized boolean resetRunning() {
        if (this.runningTaskPool.isEmpty() && this.readyTaskQueue.isEmpty()) {
            this.is_running = false;
            return false;
        }
        return this.is_running;
    }

    synchronized Pair<Map<DataTask.State, AtomicInteger>, Map<DataTask.State, AtomicInteger>> taskCount() {
        HashMap<DataTask.State, AtomicInteger> map1 = new HashMap<DataTask.State, AtomicInteger>(DataTask.State.values().length);
        HashMap<DataTask.State, AtomicInteger> map2 = new HashMap<DataTask.State, AtomicInteger>(DataTask.State.values().length);
        for (DataTask.State state : DataTask.State.values()) {
            map1.put(state, new AtomicInteger(0));
            map2.put(state, new AtomicInteger(0));
        }
        for (DataTask job : this.dataTasks.values()) {
            if (job instanceof FiberTask) {
                ((AtomicInteger)map1.get((Object)job.getState())).incrementAndGet();
                continue;
            }
            ((AtomicInteger)map2.get((Object)job.getState())).incrementAndGet();
        }
        return new Pair(map1, map2);
    }

    synchronized int dataJobsCount() {
        return this.dataTasks.size();
    }

    synchronized int failedJobsCount() {
        int count = 0;
        for (DataTask job : this.dataTasks.values()) {
            if (job.getState() != DataTask.State.Failed) continue;
            ++count;
        }
        return count;
    }

    synchronized int readyJobsCount() {
        return this.readyTaskQueue.size();
    }

    synchronized void release(DataTask task) {
        this.stream.setLastError(task.getError());
        this.decreaseFiberTaskCounter(task);
        task.takeOnRelease().doSomething();
        this.innerReleaseTask(task);
        this.resumeBlockedTasks();
    }

    private synchronized void innerReleaseTask(DataTask task) {
        this.jsonBuffer.remove(task.getId());
        this.runningTaskPool.remove(task);
        DataTask.State state = task.getState();
        switch (state) {
            case Success: 
            case Stopped: {
                this.dataTasks.remove(task.getId());
                return;
            }
            case Waiting: {
                return;
            }
            case Blocked: {
                this.blockedTaskEnqueue(task);
                return;
            }
            case Ready: {
                this.readyJobEnqueue(task);
                return;
            }
            case Failed: {
                this.has_failed = true;
                return;
            }
            case Terminated: {
                this.dataTasks.remove(task.getId());
                this.has_terminated = true;
                return;
            }
        }
        String s = String.format(ResManager.loadKDString((String)"\u88ab\u91ca\u653e\u7684\u4efb\u52a1\u72b6\u6001\u4e0d\u5408\u6cd5\uff0cID\u662f\uff1a%1$s\uff0c\u4efb\u52a1\u7c7b\u578b\u662f\uff1a%2$s\uff0c\u72b6\u6001\u662f\uff1a%3$s", (String)"WorkArea_5", (String)"isc-iscx-platform-core", (Object[])new Object[0]), new Object[]{task.getId(), task.getClass().getSimpleName(), state});
        throw new IllegalArgumentException(s);
    }

    private void blockedTaskEnqueue(DataTask task) {
        if (task instanceof StreamTask) {
            this.blockedStreamTaskPool.add((StreamTask)task);
        } else if (task instanceof BatchTask) {
            BatchTask batch = (BatchTask)task;
            this.blockedBatchTaskPool.put(batch.getNodeId(), batch);
        } else {
            throw new UnsupportedOperationException(task + " couldn't be blocked.");
        }
    }

    synchronized String generateContextJson() {
        for (Map.Entry<Long, DataTask> e : this.dataTasks.entrySet()) {
            if (this.jsonBuffer.containsKey(e.getKey())) continue;
            this.jsonBuffer.put(e.getKey(), Json.toString(e.getValue().toJson()));
        }
        StringBuilder json = new StringBuilder(524288);
        json.append('{');
        this.appendTaskSequence(json);
        json.append(',');
        this.appendCounters(json);
        json.append(',');
        this.appendTasks(json);
        DataFiberCounter c = this.stream.getCounter();
        json.append(",\"total\":").append(c.getTotalCount());
        json.append(",\"success\":").append(c.getCompletedCount());
        json.append(",\"terminated\":").append(c.getTerminatedCount());
        json.append(",\"ommitted\":").append(c.getOmmittedCount());
        json.append('}');
        return json.toString();
    }

    private void appendTaskSequence(StringBuilder json) {
        json.append('\"').append("task_sequence").append('\"').append(':').append('\"').append(this.taskSequence.get()).append('\"');
    }

    private void appendCounters(StringBuilder json) {
        HashMap<String, Integer> failedNodes = new HashMap<String, Integer>();
        for (DataTask t : this.dataTasks.values()) {
            if (!(t instanceof FiberTask)) continue;
            for (String nodeId : ((FiberTask)t).getFailedNodes()) {
                failedNodes.put(nodeId, 1 + D.i(failedNodes.get(nodeId)));
            }
        }
        json.append("\"counter\":");
        json.append('[');
        boolean first = true;
        for (Map.Entry<String, NodeCounter> e : this.nodeCounters.entrySet()) {
            String nodeId;
            if (first) {
                first = false;
            } else {
                json.append(',');
            }
            nodeId = e.getKey();
            NodeCounter c = e.getValue();
            json.append('{');
            json.append('\"').append("id").append('\"').append(':').append('\"').append(nodeId).append('\"');
            json.append(',');
            String nodeTitle = this.stream.getFiberFlow().getNode(nodeId).getTitle().replace('\"', '\'');
            json.append('\"').append("title").append('\"').append(':').append('\"').append(nodeTitle).append('\"');
            json.append(',');
            json.append('\"').append("elapsed").append('\"').append(':').append(c.getTimeElapsed()).append(' ');
            json.append(',');
            json.append('\"').append("completed").append('\"').append(':').append(c.getCompletedCount()).append(' ');
            json.append(',');
            json.append('\"').append("ommited").append('\"').append(':').append(c.getOmmitedCount()).append(' ');
            json.append(',');
            json.append('\"').append("leap_over").append('\"').append(':').append(c.getLeapOverCount()).append(' ');
            json.append(',');
            json.append('\"').append("failed").append('\"').append(':').append(D.i(failedNodes.get(nodeId))).append(' ');
            json.append('}');
        }
        json.append(']');
    }

    private void appendTasks(StringBuilder json) {
        json.append('\"').append("task").append('\"').append(':');
        json.append('[');
        boolean first = true;
        for (String item : this.jsonBuffer.values()) {
            if (first) {
                first = false;
            } else {
                json.append(',');
            }
            json.append(item);
        }
        json.append(']');
    }

    synchronized boolean isFull() {
        return this.capacity <= this.dataTasks.size();
    }

    synchronized DataTask dequeue() {
        if (this.readyTaskQueue.isEmpty()) {
            return null;
        }
        try {
            DataTask job = this.readyTaskQueue.dequeue();
            if (!this.runningTaskPool.add(job)) {
                throw new IscBizException(job + " is Running.");
            }
            DataTask dataTask = job;
            return dataTask;
        }
        finally {
            this.tryStartSubTask();
        }
    }

    private synchronized void readyJobEnqueue(DataTask task) {
        if (!this.runningTaskPool.contains(task)) {
            this.readyTaskQueue.enqueue(task);
            if (this.is_running) {
                this.tryStartSubTask();
            }
        } else {
            throw new IscBizException(task + " is Running.");
        }
    }

    public synchronized void enqueue(DataTask t) {
        if (this.has_terminated) {
            return;
        }
        if (this.dataTasks.containsKey(t.getId())) {
            String s = String.format(ResManager.loadKDString((String)"\u4efb\u52a1ID\u91cd\u590d\uff0cID\u662f\uff1a%1$s\uff0c\u4efb\u52a1\u7c7b\u578b\u662f\uff1a%2$s", (String)"WorkArea_6", (String)"isc-iscx-platform-core", (Object[])new Object[0]), t.getId(), t.getClass().getSimpleName());
            throw new IllegalArgumentException(s);
        }
        this.increaseFiberTaskCounter(t);
        this.dataTasks.put(t.getId(), t);
        if (t.getState() == DataTask.State.Ready) {
            this.readyJobEnqueue(t);
        } else if (t.getState() == DataTask.State.Blocked) {
            this.blockedTaskEnqueue(t);
        }
    }

    private void increaseFiberTaskCounter(DataTask t) {
        if (t instanceof FiberTask) {
            String key = ((FiberTask)t).getStartNodeId();
            AtomicInteger counter = this.fiberTaskCounters.get(key);
            counter.incrementAndGet();
        }
    }

    int fiberTaskCount(String startNodeId) {
        AtomicInteger counter = this.fiberTaskCounters.get(startNodeId);
        return counter.get();
    }

    private void decreaseFiberTaskCounter(DataTask t) {
        if (t.getState().isClosed() && t instanceof FiberTask) {
            String key = ((FiberTask)t).getStartNodeId();
            AtomicInteger counter = this.fiberTaskCounters.get(key);
            counter.decrementAndGet();
        }
    }

    synchronized void moveToReady(DataTask task) {
        task.setState(DataTask.State.Ready);
        this.readyJobEnqueue(task);
        this.jsonBuffer.remove(task.getId());
        if (task instanceof BatchTask) {
            this.blockedBatchTaskPool.remove(((BatchTask)task).getNodeId());
        } else if (task instanceof StreamTask) {
            this.blockedStreamTaskPool.remove(task);
        }
    }

    private synchronized void resumeBlockedTasks() {
        if ((this.readyTaskQueue.isEmpty() || this.dataTasks.size() <= this.capacityThreshold) && !this.blockedStreamTaskPool.isEmpty()) {
            Iterator<StreamTask> it = this.blockedStreamTaskPool.iterator();
            while (it.hasNext()) {
                StreamTask streamTask = it.next();
                if (!streamTask.isResumeable()) continue;
                streamTask.setState(DataTask.State.Ready);
                this.readyJobEnqueue(streamTask);
                it.remove();
            }
        }
        if (this.readyTaskQueue.isEmpty() && !this.blockedBatchTaskPool.isEmpty()) {
            for (BatchTask batchTask : this.blockedBatchTaskPool.values()) {
                batchTask.setState(DataTask.State.Ready);
                this.readyJobEnqueue(batchTask);
            }
            this.blockedBatchTaskPool.clear();
        }
    }

    private synchronized void tryStartSubTask() {
        int j = Math.min(this.maxThreads - this.currentThreads, this.readyTaskQueue.size());
        for (int i = 0; i < j; ++i) {
            this.stream.getMainJob().startSubTaskThread();
            ++this.currentThreads;
        }
    }

    public synchronized int getCurrentThreads() {
        return this.currentThreads;
    }

    synchronized void decCurrentThreads() {
        --this.currentThreads;
    }

    NodeCounter getNodeCounter(String fiberNodeId) {
        NodeCounter c = this.nodeCounters.get(fiberNodeId);
        if (c == null) {
            this.nodeCounters.putIfAbsent(fiberNodeId, new NodeCounter(0, 0, 0L, 0));
            c = this.nodeCounters.get(fiberNodeId);
        }
        return c;
    }

    synchronized void dispose() {
        for (DataTask t : this.dataTasks.values()) {
            try {
                t.close();
            }
            catch (Throwable throwable) {}
        }
    }

    long incTaskSequence() {
        return this.taskSequence.incrementAndGet();
    }

    void setTaskSequence(long task_sequence) {
        this.taskSequence.set(task_sequence);
    }

    void addNodeCounter(String nodeId, NodeCounter c) {
        this.nodeCounters.put(nodeId, c);
    }

    protected synchronized void appendBatch(Execution e, int batchSize) {
        String nodeId = e.getDefine().getId();
        BatchTask batch = this.blockedBatchTaskPool.get(nodeId);
        if (batch == null) {
            batch = new BatchTask(this.stream, batchSize, nodeId);
            this.enqueue(batch);
        }
        batch.appendFiberTask(FiberTask.getCurrentTask(e), e.getId());
        if (batch.getFiberCount() >= batchSize) {
            this.moveToReady(batch);
        }
    }

    synchronized FiberTask getFiberTask(Long fiberId) {
        return (FiberTask)this.dataTasks.get(fiberId);
    }
}

