/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.runtime.job.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.flow.core.Node;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscx.platform.core.res.meta.dm.AbstractDataModel;
import kd.isc.iscx.platform.core.res.runtime.DataFlowException;
import kd.isc.iscx.platform.core.res.runtime.job.AbstractBatchApplication;
import kd.isc.iscx.platform.core.res.runtime.job.DataStream;
import kd.isc.iscx.platform.core.res.runtime.job.DataTask;
import kd.isc.iscx.platform.core.res.runtime.job.task.FiberTask;

public final class BatchTask
extends DataTask {
    private int batchSize;
    private String nodeId;
    private String nodeTitle;
    private Map<Long, Pair<FiberTask, String>> fibers = new HashMap<Long, Pair<FiberTask, String>>();
    private AbstractBatchApplication app;
    private AbstractDataModel input;
    private AbstractDataModel output;

    public BatchTask(DataStream stream, int batchSize, String nodeId) {
        super(stream);
        this.batchSize = Math.max(1, Math.min(batchSize, stream.getDataFlow().getMaxBatchSize()));
        this.nodeId = nodeId;
        this.nodeTitle = stream.getFiberFlow().getNode(nodeId).getTitle();
        Node node = stream.getFiberFlow().getNode(nodeId);
        this.app = (AbstractBatchApplication)node.getApplication();
        this.input = this.app.getDataHandler().getInput();
        this.output = this.app.getDataHandler().getOutput();
        this.setState(DataTask.State.Blocked);
    }

    BatchTask(DataStream stream, Map<String, Object> json) {
        super(stream, json);
        this.batchSize = D.i((Object)json.get("batch_size"));
        this.nodeId = D.s((Object)json.get("node_id"));
        Map map = (Map)json.get("fibers");
        this.fibers = new HashMap<Long, Pair<FiberTask, String>>(map.size());
        for (Map.Entry e : map.entrySet()) {
            Object p = e.getValue();
            if (p instanceof Map) {
                this.fibers.put(D.l(e.getKey()), (Pair<FiberTask, String>)new Pair(null, (Object)((String)((Map)p).get("value"))));
                continue;
            }
            this.fibers.put(D.l(e.getKey()), (Pair<FiberTask, String>)new Pair(null, (Object)((String)p)));
        }
        this.app = (AbstractBatchApplication)stream.getFiberFlow().getNode(this.nodeId).getApplication();
        this.input = this.app.getDataHandler().getInput();
        this.output = this.app.getDataHandler().getOutput();
        this.compareAndSetState(DataTask.State.Ready, DataTask.State.Blocked);
    }

    @Override
    protected void innerToJson(Map<String, Object> json) {
        json.put("batch_size", this.batchSize);
        json.put("node_id", this.nodeId);
        json.put("fibers", this.fibers);
    }

    @Override
    public boolean isResumeable() {
        return true;
    }

    public synchronized void appendFiberTask(FiberTask t, String executionId) {
        DataTask.State state = this.getState();
        if (DataTask.State.Blocked == state) {
            if (this.fibers.putIfAbsent(t.getId(), (Pair<FiberTask, String>)new Pair((Object)t, (Object)executionId)) != null) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u91cd\u590d\u6dfb\u52a0\u5b50\u4efb\u52a1\uff08%s\uff09", (String)"BatchTask_5", (String)"isc-iscx-platform-core", (Object[])new Object[0]), t.getId()));
            }
        } else {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u72b6\u6001\uff08%s\uff09\u7981\u6b62\u6dfb\u52a0\u5b50\u4efb\u52a1\u3002", (String)"BatchTask_6", (String)"isc-iscx-platform-core", (Object[])new Object[0]), new Object[]{state}));
        }
    }

    @Override
    public String innerGetContextDigest() {
        String varName = this.input.getVariableName();
        StringBuilder sb = new StringBuilder(1024);
        sb.append(this.app.getDataHandler().getName()).append(" : ");
        for (Long id : this.fibers.keySet()) {
            FiberTask f = this.getStream().getFiberTask(id);
            String s = this.input.digest((Map)f.getFlowRuntime().get(varName));
            sb.append(s).append("; ");
        }
        return sb.toString();
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getFiberCount() {
        return this.fibers.size();
    }

    public String getNodeId() {
        return this.nodeId;
    }

    @Override
    protected void doJob() {
        String inputVar = this.input.getVariableName();
        String outputVar = this.output.getVariableName();
        List<AbstractBatchApplication.Data> batch = this.prepareBatch(inputVar, outputVar);
        try {
            this.doBatch(batch);
            this.setOutputData(batch, inputVar, outputVar);
            this.resumeBatch(batch);
            this.setState(DataTask.State.Success);
        }
        catch (Exception error) {
            this.appFailed(batch, error);
            this.setState(DataTask.State.Stopped);
        }
    }

    private void doBatch(List<AbstractBatchApplication.Data> batch) {
        long startTime = System.currentTimeMillis();
        try {
            this.app.doBatch(this.getStream(), batch);
        }
        catch (Throwable e) {
            throw this.wrapError(e, batch);
        }
        finally {
            this.getStream().addElapsedTime(this.nodeId, startTime);
        }
    }

    private DataFlowException wrapError(Throwable e, List<AbstractBatchApplication.Data> batch) {
        if (e instanceof DataFlowException) {
            return (DataFlowException)((Object)e);
        }
        String nodeTitle = this.getStream().getFiberFlow().getNode(this.nodeId).getTitle();
        List<Map<String, Object>> data = BatchTask.getInputData(batch);
        return new DataFlowException(this.nodeId, nodeTitle, this.input, data, e);
    }

    private static List<Map<String, Object>> getInputData(List<AbstractBatchApplication.Data> batch) {
        ArrayList<Map<String, Object>> input = new ArrayList<Map<String, Object>>(batch.size());
        for (AbstractBatchApplication.Data data : batch) {
            input.add(data.getInput());
        }
        return input;
    }

    private void setOutputData(List<AbstractBatchApplication.Data> batch, String inputVar, String outputVar) {
        if (!inputVar.equals(outputVar)) {
            for (AbstractBatchApplication.Data d : batch) {
                d.getTask().getFlowRuntime().getRootExecution().set(outputVar, d.getOutput());
            }
        }
    }

    private List<AbstractBatchApplication.Data> prepareBatch(String inputVar, String outputVar) {
        ArrayList<AbstractBatchApplication.Data> list = new ArrayList<AbstractBatchApplication.Data>(this.fibers.size());
        for (Map.Entry<Long, Pair<FiberTask, String>> t : this.fibers.entrySet()) {
            Pair<FiberTask, String> p = t.getValue();
            FiberTask f = (FiberTask)p.getKey();
            if (f == null) {
                f = this.getStream().getFiberTask(t.getKey());
            }
            Execution root = f.getFlowRuntime().getRootExecution();
            Map<String, Object> in = this.getInput(root, inputVar);
            Map<String, Object> out = this.getOutput(root, outputVar);
            list.add(new AbstractBatchApplication.Data(f, (String)p.getValue(), in, out));
        }
        return list;
    }

    private Map<String, Object> getOutput(Execution root, String outputVar) {
        Map out = (Map)root.get(outputVar);
        if (out == null) {
            out = this.output.getDataType().narrow(Collections.emptyMap());
        }
        return out;
    }

    private Map<String, Object> getInput(Execution root, String inputVar) {
        Map in = (Map)root.get(inputVar);
        if (in == null) {
            throw new DataFlowException(this.nodeId, this.nodeTitle, String.format(ResManager.loadKDString((String)"\u8f93\u5165\u6570\u636e\u672a\u5c31\u7eea\uff0c\u6570\u636e\u6a21\u578b\u662f\uff1a%s", (String)"BatchTask_7", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.input.getName()));
        }
        if (in.isEmpty()) {
            throw new DataFlowException(this.nodeId, this.nodeTitle, String.format(ResManager.loadKDString((String)"\u8f93\u5165\u6570\u636e\u4e3a\u7a7a\uff0c\u6570\u636e\u6a21\u578b\u662f\uff1a%s", (String)"BatchTask_8", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.input.getName()));
        }
        return in;
    }

    @Override
    public void close() {
    }
}

