/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.runtime.job.task;

import java.util.Map;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscx.platform.core.res.runtime.job.DataStream;
import kd.isc.iscx.platform.core.res.runtime.job.DataTask;
import kd.isc.iscx.platform.core.res.runtime.job.task.BatchTask;
import kd.isc.iscx.platform.core.res.runtime.job.task.FiberTask;
import kd.isc.iscx.platform.core.res.runtime.job.task.StreamTask;

public class DataTaskUtil {
    public static DataTask fromJson(DataStream stream, Map<String, Object> json) {
        String type = (String)json.get("type");
        if (StreamTask.class.getName().equals(type)) {
            return new StreamTask(stream, json);
        }
        if (FiberTask.class.getName().equals(type)) {
            return new FiberTask(stream, json);
        }
        if (BatchTask.class.getName().equals(type)) {
            return new BatchTask(stream, json);
        }
        throw new IllegalArgumentException(type);
    }

    public static void appendStreamContext(Execution e, Map<String, Object> ctx) {
        if (e != null) {
            DataStream stream = FiberTask.getCurrentTask(e).getStream();
            DataTaskUtil.appendStreamContext(stream, ctx);
        }
    }

    public static void appendStreamContext(DataStream stream, Map<String, Object> ctx) {
        if (stream != null) {
            ctx.put("$flow", stream.getFiberFlow());
            ctx.put("$stream", stream.getContext());
        }
    }
}

