/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.runtime.job.task;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.isc.iscb.platform.core.IscRuntimeInfo;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.TaskCancelException;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.flow.core.Flow;
import kd.isc.iscb.util.flow.core.FlowRuntime;
import kd.isc.iscx.platform.core.res.meta.dm.AbstractDataModel;
import kd.isc.iscx.platform.core.res.runtime.job.DataFlowNodeExecutionSync;
import kd.isc.iscx.platform.core.res.runtime.job.DataStream;
import kd.isc.iscx.platform.core.res.runtime.job.DataTask;
import kd.isc.iscx.platform.core.res.runtime.job.task.FiberUtil;

public final class FiberTask
extends DataTask {
    private FlowRuntime fiber;
    private final String startNodeId;
    private transient AbstractDataModel dataModel;
    private transient Map<String, Object> data;

    public FiberTask(DataStream stream, String startNodeId, AbstractDataModel dataModel, Map<String, Object> data) {
        super(stream);
        this.startNodeId = startNodeId;
        this.data = data;
        this.dataModel = dataModel;
    }

    FiberTask(DataStream stream, Map<String, Object> json) {
        super(stream, json);
        Flow flow = stream.getFiberFlow();
        this.fiber = flow.fromJson((Map)json.get("runtime"));
        this.fiber.setTransientProperty("$this", (Object)this);
        this.startNodeId = (String)json.get("startNodeId");
        FiberUtil.prepareDebugger(this.fiber, stream);
    }

    private static FlowRuntime createFiber(DataStream stream, String startNodeId, AbstractDataModel dataModel, Map<String, Object> data, long taskId) {
        FlowRuntime fiber = stream.getFiberFlow().newInstance(String.valueOf(taskId));
        fiber.setStartup(new String[]{startNodeId});
        DataFlowNodeExecutionSync.setStartNode(fiber, startNodeId);
        fiber.set(dataModel.getVariableName(), data);
        fiber.setProperty("input_digest", (Object)dataModel.digest(data));
        FiberUtil.prepareDebugger(fiber, stream);
        IscRuntimeInfo.get().incDataFlowFiberCount();
        return fiber;
    }

    public synchronized FlowRuntime getFlowRuntime() {
        FlowRuntime fiber = this.fiber;
        if (fiber == null) {
            this.fiber = fiber = FiberTask.createFiber(this.getStream(), this.startNodeId, this.dataModel, this.data, this.getId());
            fiber.setTransientProperty("$this", (Object)this);
        }
        return fiber;
    }

    @Override
    public String innerGetContextDigest() {
        return (String)this.getFlowRuntime().getProperty("input_digest");
    }

    public String getStartNodeId() {
        return this.startNodeId;
    }

    @Override
    public void close() {
    }

    @Override
    protected void innerToJson(Map<String, Object> json) {
        FlowRuntime fiber = this.getFlowRuntime();
        json.put("runtime", fiber.toJson());
        json.put("startNodeId", this.startNodeId);
    }

    @Override
    protected void doJob() {
        FlowRuntime fiber = this.getFlowRuntime();
        try {
            fiber.resume();
            if (fiber.isClosed()) {
                if (D.x((Object)fiber.getProperty("is_stopped"))) {
                    this.setState(DataTask.State.Stopped);
                } else {
                    this.setState(DataTask.State.Success);
                }
                IscRuntimeInfo.get().incDataFlowFiberCompleteCount();
            } else {
                this.setState(DataTask.State.Waiting);
            }
        }
        catch (Throwable e) {
            if (e instanceof TaskCancelException) {
                fiber.terminate();
            } else {
                this.getStream().getCounter().incFailedCount();
            }
            throw e;
        }
    }

    public void setStopped() {
        this.getFlowRuntime().setProperty("is_stopped", (Object)Boolean.TRUE);
    }

    void registerFailedNode(Execution e) {
        Set<String> failedNodes = this.innerGetFailedNodes();
        failedNodes.add(e.getDefine().getId());
    }

    void unregisterFailedNode(Execution e) {
        Set<String> failedNodes = this.innerGetFailedNodes();
        failedNodes.remove(e.getDefine().getId());
    }

    public Set<String> getFailedNodes() {
        Set<String> s = this.innerGetFailedNodes();
        return s.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(s);
    }

    private Set<String> innerGetFailedNodes() {
        FlowRuntime fiber = this.getFlowRuntime();
        HashSet failedNodes = (HashSet)fiber.getProperty("failed_nodes");
        if (failedNodes == null) {
            failedNodes = new HashSet();
            fiber.setProperty("failed_nodes", failedNodes);
        }
        return failedNodes;
    }

    @Override
    public boolean isResumeable() {
        return false;
    }

    public static FiberTask getCurrentTask(Execution e) {
        return (FiberTask)e.getRuntime().getTransientProperty("$this");
    }

    public static FiberTask getCurrentTask(FlowRuntime fiber) {
        return (FiberTask)fiber.getTransientProperty("$this");
    }

    public static void incOmmitedCount(Execution e) {
        FiberTask task = FiberTask.getCurrentTask(e.getRuntime());
        String nodeId = e.getDefine().getId();
        task.getStream().getNodeCounter(nodeId).incOmmitedCount();
    }

    public static void incLeapOverCount(Execution e) {
        FiberTask task = FiberTask.getCurrentTask(e.getRuntime());
        String nodeId = e.getDefine().getId();
        task.getStream().getNodeCounter(nodeId).incLeapOverCount();
    }

    public static void incCompletedCount(Execution e) {
        FiberTask task = FiberTask.getCurrentTask(e.getRuntime());
        String nodeId = e.getDefine().getId();
        task.getStream().getNodeCounter(nodeId).incCompletedCount();
    }

    public static void stopCurrentFiber(Execution e) {
        if (e != null) {
            DataFlowNodeExecutionSync.stop(e, false);
        }
    }
}

