/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.runtime.job.task;

import kd.isc.iscb.util.debugger.DebuggerAction;
import kd.isc.iscb.util.flow.core.FlowRuntime;
import kd.isc.iscb.util.flow.core.FlowTrace;
import kd.isc.iscb.util.flow.trace.FlowDebuggerResource;
import kd.isc.iscb.util.flow.trace.FlowDebuggerTrace;
import kd.isc.iscb.util.flow.trace.LineCollector;
import kd.isc.iscb.util.script.encoding.Encoding;
import kd.isc.iscx.platform.core.res.meta.event.AbstractEventModel;
import kd.isc.iscx.platform.core.res.runtime.job.DataStream;

public class FiberUtil {
    public static void prepareDebugger(FlowRuntime fiber, DataStream stream) {
        int index = stream.getNumber().lastIndexOf("#DEBUG_");
        if (index <= 0) {
            return;
        }
        String debug = stream.getNumber().substring(index + "#DEBUG_".length());
        FlowDebuggerResource res = new FlowDebuggerResource(fiber.getFlow(), LineCollector.valueOf((String)debug));
        fiber.setFlowTrace((FlowTrace)new FlowDebuggerTrace(res));
        res.attachBreakpoint(fiber);
    }

    public static String buildNumber(long id, String debug) {
        String number = Encoding.pesudoBase64((long)id);
        for (LineCollector c : LineCollector.values()) {
            if (!c.name().equals(debug)) continue;
            number = number + "#DEBUG_" + debug;
            break;
        }
        return number;
    }

    public static void prepareDebugger(DataStream stream) {
        int index = stream.getNumber().lastIndexOf("#DEBUG_");
        if (index <= 0) {
            return;
        }
        AbstractEventModel e = stream.getDataFlow().getEventModel();
        if (e instanceof DebuggerAction) {
            ((DebuggerAction)e).onAttachBreakpoint();
        }
    }

    public static boolean isDebug(DataStream stream) {
        return stream.getNumber().lastIndexOf("#DEBUG_") > 0;
    }
}

