/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.runtime.job.task;

import java.util.Map;
import java.util.zip.CRC32;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.cache.CacheableObjectManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.except.TaskCancelException;
import kd.isc.iscb.util.flow.core.Flow;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscx.platform.core.res.meta.Resource;
import kd.isc.iscx.platform.core.res.meta.dp.AbstractDataQuery;
import kd.isc.iscx.platform.core.res.meta.dt.StructValue;
import kd.isc.iscx.platform.core.res.runtime.Connector;
import kd.isc.iscx.platform.core.res.runtime.DataFlowDefine;
import kd.isc.iscx.platform.core.res.runtime.DataFlowException;
import kd.isc.iscx.platform.core.res.runtime.job.DataStream;
import kd.isc.iscx.platform.core.res.runtime.job.DataTask;
import kd.isc.iscx.platform.core.res.runtime.job.task.FiberTask;

public final class StreamTask
extends DataTask
implements Comparable<StreamTask> {
    private Flow fiberFlow;
    private AbstractDataQuery query;
    private String startNodeId;
    private Map<String, Object> params;
    private Connector connector;
    private String[] crcFields;
    private int index;
    private int total;
    private CRC32 crc;
    private transient long targetCRC;
    private transient int targetIndex;
    private transient ObjectReader<? extends Map<String, Object>> reader;
    private transient ConnectionWrapper cn;
    private transient int bufferSize;
    private String readerSummery;

    public StreamTask(DataStream stream, String startNodeId, AbstractDataQuery query, Connector connector, Map<String, Object> params) {
        super(stream);
        this.initBufferSize();
        this.fiberFlow = stream.getFiberFlow();
        this.startNodeId = startNodeId;
        this.query = query;
        this.params = params;
        this.connector = connector;
        this.crcFields = query.getCrcFields();
        this.index = 0;
        this.targetIndex = 0;
        this.crc = new CRC32();
        this.targetCRC = this.crc.getValue();
        this.total = Integer.MIN_VALUE;
    }

    private void initBufferSize() {
        DataFlowDefine dataFlow = this.getStream().getDataFlow();
        int workAreaSize = dataFlow.getWorkAreaSize();
        int terminalCount = dataFlow.getTerminalNodeCount();
        this.bufferSize = Math.max(workAreaSize / (terminalCount + 1) - 1, 1);
    }

    StreamTask(DataStream stream, Map<String, Object> json) {
        super(stream, json);
        this.initBufferSize();
        this.fiberFlow = stream.getFiberFlow();
        this.startNodeId = D.s((Object)json.get("startNodeId"));
        this.query = (AbstractDataQuery)CacheableObjectManager.get(Resource.class, (Long)D.l((Object)json.get("query")));
        this.params = (Map)json.get("params");
        this.connector = Connector.get(D.l((Object)json.get("connector")));
        this.crcFields = this.query.getCrcFields();
        this.index = 0;
        this.targetIndex = D.i((Object)json.get("index"));
        this.crc = new CRC32();
        this.targetCRC = D.l((Object)json.get("crc"));
        this.total = D.i((Object)json.get("total"));
        this.readerSummery = (String)json.get("reader");
    }

    @Override
    protected void innerToJson(Map<String, Object> json) {
        json.put("startNodeId", this.startNodeId);
        json.put("query", this.query.getId());
        json.put("params", this.params);
        json.put("connector", this.connector.getId());
        json.put("index", this.targetIndex);
        json.put("total", this.total);
        json.put("crc", this.targetCRC);
        json.put("reader", this.readerSummery);
    }

    @Override
    public boolean isResumeable() {
        return !this.isBufferFull();
    }

    private boolean isBufferFull() {
        if (this.getStream().isWorkAreaFull()) {
            return true;
        }
        return this.getStream().fiberTaskCount(this.startNodeId) >= this.bufferSize;
    }

    @Override
    protected void doJob() {
        if (this.isBufferFull()) {
            this.compareAndSetState(DataTask.State.Blocked, DataTask.State.Running);
        } else {
            long start = System.currentTimeMillis();
            try {
                this.prepareReader();
                this.doRead();
            }
            catch (Throwable err) {
                if (err instanceof TaskCancelException) {
                    throw err;
                }
                String nodeTitle = this.fiberFlow.getNode(this.startNodeId).getTitle();
                throw new DataFlowException(this.startNodeId, nodeTitle, this.query.getInput(), this.params, err);
            }
            finally {
                this.getStream().getNodeCounter(this.startNodeId).add(System.currentTimeMillis() - start);
            }
        }
    }

    private void doRead() {
        while (!this.isBufferFull()) {
            SignalManager.checkCancelSignal();
            Map<String, Object> row = this.readRow();
            if (row == null) {
                this.setState(DataTask.State.Success);
                break;
            }
            FiberTask fiberTask = this.createFiberTask(row);
            super.enqueue(fiberTask);
            this.refreshCounter();
        }
    }

    private void refreshCounter() {
        this.targetIndex = this.index;
        this.targetCRC = this.crc.getValue();
        if (this.index > this.total) {
            this.total = this.index;
            this.getStream().getCounter().incTotalCount();
        }
    }

    private FiberTask createFiberTask(Map<String, Object> row) {
        return new FiberTask(this.getStream(), this.startNodeId, this.query.getOutput(), row);
    }

    private Map<String, Object> readRow() {
        Map row = (Map)this.reader.read();
        if (row == null) {
            return null;
        }
        ++this.index;
        for (String field : this.crcFields) {
            Object value = row.get(field);
            String s = value == null ? "null" : value.toString();
            this.crc.update(s.getBytes(D.UTF_8));
        }
        return row;
    }

    private void prepareReader() {
        if (this.reader == null) {
            this.cn = this.connector.getConnection();
            StructValue params = this.query.getInput().getDataType().narrow(this.params);
            this.reader = this.query.invoke(this.getStream(), this.cn, params, this.bufferSize);
            this.readerSummery = this.reader.toString();
            int total = this.reader.getTotalCount();
            if (total >= 0) {
                if (this.total < 0) {
                    this.total = total;
                    this.getStream().getCounter().incTotalCount(total);
                } else if (this.total != total) {
                    throw new IscBizException(ResManager.loadKDString((String)"\u7531\u4e8e\u6e90\u7cfb\u7edf\u7aef\u7684\u6570\u636e\u603b\u884c\u6570\u5728\u4e0a\u6b21\u6267\u884c\u540e\u53d1\u751f\u4e86\u53d8\u5316\uff0c\u5f53\u524d\u6570\u636e\u6d41\u4efb\u52a1\u65e0\u6cd5\u6062\u590d\uff0c\u4e0d\u80fd\u91cd\u8bd5\u3002", (String)"StreamTask_0", (String)"isc-iscx-platform-core", (Object[])new Object[0]));
                }
            }
            while (this.index < this.targetIndex && this.readRow() != null) {
            }
            if (this.crc.getValue() != this.targetCRC) {
                throw new IscBizException(ResManager.loadKDString((String)"\u7531\u4e8e\u6e90\u7cfb\u7edf\u7aef\u7684\u6570\u636e\u5185\u5bb9\u5728\u4e0a\u6b21\u6267\u884c\u540e\u53d1\u751f\u4e86\u53d8\u5316\uff0c\u5f53\u524d\u6570\u636e\u6d41\u4efb\u52a1\u65e0\u6cd5\u6062\u590d\uff0c\u4e0d\u80fd\u91cd\u8bd5\u3002", (String)"StreamTask_1", (String)"isc-iscx-platform-core", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public void close() {
        try {
            ObjectReader<? extends Map<String, Object>> reader = this.reader;
            this.reader = null;
            if (reader != null) {
                reader.close();
            }
        }
        finally {
            ConnectionWrapper cn = this.cn;
            this.cn = null;
            if (cn != null) {
                cn.close();
            }
        }
    }

    @Override
    public String innerGetContextDigest() {
        return this.query.getName() + " : " + this.query.getInput().digest(this.params);
    }

    @Override
    public int compareTo(StreamTask o) {
        return Long.compare(o.getId(), this.getId());
    }
}

