/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.runtime.trigger;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.util.connector.EventBindingUtil;
import kd.isc.iscx.platform.core.res.meta.event.BizEvent;
import kd.isc.iscx.platform.core.res.runtime.Connector;
import kd.isc.iscx.platform.core.res.runtime.DataStreamTrigger;
import kd.isc.iscx.platform.core.res.runtime.job.DataStream;
import kd.isc.iscx.platform.core.res.runtime.job.DataTask;
import kd.isc.iscx.platform.core.res.runtime.job.task.FiberTask;
import kd.isc.iscx.platform.core.res.runtime.util.Util;

public class BizEventTrigger
implements DataStreamTrigger {
    private Connector c;
    private long dataFlowTriggerId;
    private BizEvent bizEvent;
    private String startNodeId;

    public BizEventTrigger(Connector c, BizEvent bizEvent, long dataFlowTriggerId, String startNodeId) {
        this.c = c;
        this.dataFlowTriggerId = dataFlowTriggerId;
        this.bizEvent = bizEvent;
        this.startNodeId = startNodeId;
    }

    @Override
    public BizEvent getEventModel() {
        return this.bizEvent;
    }

    @Override
    public void enable() {
        try (ConnectionWrapper cn = this.c.getConnection();){
            String iscHub = ConnectorUtil.getIscHub((DynamicObject)cn.getConfig());
            Map<String, Object> requires = Util.initRequiresMap(this.bizEvent.getSelectFields());
            EventBindingUtil.TriggerType type = EventBindingUtil.TriggerType.DataFlowTrigger;
            cn.getFactory().attachEvents(cn, iscHub, type, this.dataFlowTriggerId, this.bizEvent.getEntityNumber(), this.bizEvent.getEvents(), requires);
        }
    }

    @Override
    public void disable() {
        try (ConnectionWrapper cn = this.c.getConnection();){
            String iscHub = ConnectorUtil.getIscHub((DynamicObject)cn.getConfig());
            EventBindingUtil.TriggerType type = EventBindingUtil.TriggerType.DataFlowTrigger;
            cn.getFactory().detachEvents(cn, iscHub, type, this.dataFlowTriggerId, this.bizEvent.getEntityNumber());
        }
    }

    @Override
    public DataTask createFirstTask(DataStream stream, Map<String, Object> params) {
        stream.getCounter().incTotalCount();
        return new FiberTask(stream, this.startNodeId, this.bizEvent.getParams(), params);
    }

    public Connector getConnector() {
        return this.c;
    }
}

