/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.runtime.trigger;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.id.IDService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.dc.mq.DataFlowRouter;
import kd.isc.iscb.platform.core.dc.mq.MessageQueueInitiator;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.script.misc.SystemContext;
import kd.isc.iscx.platform.core.res.meta.event.AbstractEventModel;
import kd.isc.iscx.platform.core.res.meta.event.MQueueEvent;
import kd.isc.iscx.platform.core.res.runtime.Connector;
import kd.isc.iscx.platform.core.res.runtime.DataStreamTrigger;
import kd.isc.iscx.platform.core.res.runtime.job.DataStream;
import kd.isc.iscx.platform.core.res.runtime.job.DataTask;
import kd.isc.iscx.platform.core.res.runtime.job.task.FiberTask;

public class MQEventTrigger
implements DataStreamTrigger {
    private MQueueEvent event;
    private Connector connector;
    private long data_flow_trigger_id;
    private String startNodeId;

    public MQEventTrigger(MQueueEvent event, Connector connector, long data_flow_trigger_id, String startNodeId) {
        this.event = event;
        this.connector = connector;
        this.data_flow_trigger_id = data_flow_trigger_id;
        this.startNodeId = startNodeId;
    }

    @Override
    public AbstractEventModel getEventModel() {
        return this.event;
    }

    @Override
    public DataTask createFirstTask(DataStream stream, Map<String, Object> params) {
        stream.getCounter().incTotalCount();
        return new FiberTask(stream, this.startNodeId, this.event.getParams(), params);
    }

    @Override
    public void disable() {
        long original_mq_topic = this.getOriginalMqTopic();
        HashSet<Long> mqServers = new HashSet<Long>(2);
        if (original_mq_topic != 0L) {
            this.disableOriginalMqTopic(original_mq_topic, mqServers);
        }
        DataFlowRouter.clearCache();
        this.resetMqServerListeners(mqServers);
    }

    @Override
    public void enable() {
        long original_mq_topic = this.getOriginalMqTopic();
        long required_mq_topic = this.getOrCreateRequiredMqTopic();
        HashSet<Long> mqServers = new HashSet<Long>(2);
        if (original_mq_topic != required_mq_topic) {
            this.disableOriginalMqTopic(original_mq_topic, mqServers);
            this.bindRequiredMqTopic(required_mq_topic);
        }
        this.enableRequiredMqTopic(required_mq_topic, mqServers);
        DataFlowRouter.clearCache();
        this.resetMqServerListeners(mqServers);
    }

    private void resetMqServerListeners(Set<Long> mqServers) {
        for (Long id : mqServers) {
            if (id == 0L) continue;
            MessageQueueInitiator.resetListeners((long)id);
        }
    }

    private void enableRequiredMqTopic(long required_mq_topic, Set<Long> mqServers) {
        DynamicObject topic;
        if (required_mq_topic != 0L && !D.x((Object)(topic = BusinessDataServiceHelper.loadSingle((Object)required_mq_topic, (String)"isc_mq_subscriber")).get("enable"))) {
            ConnectorUtil.enable((DynamicObject)topic);
            mqServers.add(D.l((Object)topic.get("group_id")));
        }
    }

    private void disableOriginalMqTopic(long original_mq_topic, Set<Long> mqServers) {
        DynamicObject topic;
        if (original_mq_topic != 0L && D.x((Object)(topic = BusinessDataServiceHelper.loadSingle((Object)original_mq_topic, (String)"isc_mq_subscriber")).get("enable"))) {
            ConnectorUtil.disable((DynamicObject)topic);
            mqServers.add(D.l((Object)topic.get("group_id")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindRequiredMqTopic(long required_mq_topic) {
        String sql = "UPDATE t_iscx_datax_trigger SET fmq_topic_id =? WHERE fid=?";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            DbUtil.executeUpdate((Connection)cn, (String)sql, (List)D.asList((Object[])new Object[]{required_mq_topic, this.data_flow_trigger_id}), (List)D.asList((Object[])new Integer[]{-5, -5}));
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getOriginalMqTopic() {
        String sql = "SELECT fmq_topic_id FROM t_iscx_datax_trigger WHERE fid=?";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            long l = D.l((Object)DbUtil.executeScalar((Connection)cn, (String)sql, (List)D.asList((Object[])new Object[]{this.data_flow_trigger_id}), (List)D.asList((Object[])new Integer[]{-5})));
            return l;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private long getOrCreateRequiredMqTopic() {
        long required_mq_topic = this.findRequiredMqTopic();
        if (required_mq_topic == 0L) {
            required_mq_topic = this.createRequiredMqTopic();
        }
        return required_mq_topic;
    }

    private long createRequiredMqTopic() {
        long required_mq_topic = IDService.get().genLongId();
        DynamicObject o = BusinessDataServiceHelper.newDynamicObject((String)"isc_mq_subscriber");
        o.set("id", (Object)required_mq_topic);
        o.set("group_id", (Object)this.connector.getDbLink());
        o.set("number", (Object)this.event.getMQTopicNumber());
        o.set("name", (Object)this.event.getName());
        o.set("isv", (Object)"ISC.DataFlow");
        o.set("status", (Object)"C");
        o.set("creator", (Object)RequestContext.get().getCurrUserId());
        o.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
        boolean isProcEnv = SystemContext.isProcEnv();
        o.set("protect_level", (Object)(isProcEnv ? "READ_ONLY" : "DEFAULT"));
        o.set("subscriber_ip_pattern", (Object)(isProcEnv ? "*" : NetUtil.getLocalAddress()));
        o.set("multi_line", (Object)this.event.isArray());
        o.set("parse_script", (Object)this.event.getScriptRemark());
        o.set("parse_script_tag", (Object)this.event.getScriptText());
        o.set("msg_digest", (Object)this.event.getDataModel().getDigestFormat());
        o.set("charset", (Object)this.event.getCharset());
        ConnectorUtil.save((DynamicObject)o);
        return required_mq_topic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long findRequiredMqTopic() {
        String sql = "SELECT fid FROM t_iscb_mq_subscriber WHERE fnumber=? AND fmq_server=?";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            long l = D.l((Object)DbUtil.executeScalar((Connection)cn, (String)sql, (List)D.asList((Object[])new Object[]{this.event.getMQTopicNumber(), this.connector.getDbLink()}), (List)D.asList((Object[])new Integer[]{12, -5})));
            return l;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }
}

