/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.runtime.trigger;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.isc.iscx.platform.core.res.meta.event.AbstractEventModel;
import kd.isc.iscx.platform.core.res.meta.event.TimerEvent;
import kd.isc.iscx.platform.core.res.runtime.Connector;
import kd.isc.iscx.platform.core.res.runtime.DataFlowTrigger;
import kd.isc.iscx.platform.core.res.runtime.DataStreamTrigger;
import kd.isc.iscx.platform.core.res.runtime.job.DataStream;
import kd.isc.iscx.platform.core.res.runtime.job.DataTask;
import kd.isc.iscx.platform.core.res.runtime.job.task.StreamTask;
import kd.isc.iscx.platform.core.res.runtime.trigger.TimerUtil;

public class TimerEventTrigger
implements DataStreamTrigger {
    private Connector c;
    private TimerEvent timerEvent;
    private long dataFlowTriggerId;
    private String dataFlowTriggerTitle;
    private String startNodeId;
    private long jobMutex;

    public TimerEventTrigger(Connector c, TimerEvent timerEvent, long dataFlowTriggerId, String startNodeId) {
        this.c = c;
        this.timerEvent = timerEvent;
        this.dataFlowTriggerId = dataFlowTriggerId;
        DataFlowTrigger flowTrigger = DataFlowTrigger.get(dataFlowTriggerId);
        this.dataFlowTriggerTitle = flowTrigger.getName();
        this.jobMutex = flowTrigger.getJobMutex();
        this.startNodeId = startNodeId;
    }

    @Override
    public AbstractEventModel getEventModel() {
        return this.timerEvent;
    }

    @Override
    public void enable() {
        TimerUtil.enable(this.timerEvent.getSchedule(), this.dataFlowTriggerId, this.dataFlowTriggerTitle, RequestContext.get().getCurrUserId(), this.jobMutex);
    }

    @Override
    public void disable() {
        TimerUtil.disable(this.dataFlowTriggerId);
    }

    @Override
    public DataTask createFirstTask(DataStream stream, Map<String, Object> params) {
        return new StreamTask(stream, this.startNodeId, this.timerEvent.getQuery(), this.c, params);
    }
}

