/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.service;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscx.platform.core.res.runtime.DataFlowDefine;
import kd.isc.iscx.platform.core.res.runtime.DataFlowHelper;
import kd.isc.iscx.platform.core.res.runtime.DataFlowTrigger;
import kd.isc.iscx.platform.core.res.runtime.job.DataStreamJob;
import kd.isc.iscx.service.IscDataFlowService;

public class IscDataFlowServiceImpl
implements IscDataFlowService {
    public void enable(String triggerNumber) {
        try {
            long triggerId = DataFlowHelper.getIdByNumber(triggerNumber);
            DynamicObject trigger = BusinessDataServiceHelper.loadSingle((Object)triggerId, (String)"iscx_data_flow_trigger");
            ConnectorUtil.enable((DynamicObject)trigger);
        }
        catch (Exception e) {
            String message = StringUtil.getCascadeMessage((Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("ISC_BIZ_EXCEPTION", StringUtil.trim((String)message, (int)8000)), new Object[0]);
        }
    }

    public void disable(String triggerNumber) {
        try {
            long triggerId = DataFlowHelper.getIdByNumber(triggerNumber);
            DynamicObject trigger = BusinessDataServiceHelper.loadSingle((Object)triggerId, (String)"iscx_data_flow_trigger");
            ConnectorUtil.disable((DynamicObject)trigger);
        }
        catch (Exception e) {
            String message = StringUtil.getCascadeMessage((Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("ISC_BIZ_EXCEPTION", StringUtil.trim((String)message, (int)8000)), new Object[0]);
        }
    }

    public long startX(String triggerNumber, List<Map<String, Object>> batch) {
        try {
            DataFlowDefine flow = this.findDataFlowDefine(triggerNumber);
            DataStreamJob job = DataFlowHelper.newDataStreamJob(flow, batch, null);
            JobEngine.submit((Job)job);
            return job.getOwnerId();
        }
        catch (Exception e) {
            String message = StringUtil.getCascadeMessage((Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("ISC_BIZ_EXCEPTION", StringUtil.trim((String)message, (int)8000)), new Object[0]);
        }
    }

    public long start(String triggerNumber, Map<String, Object> params) {
        try {
            DataFlowDefine flow = this.findDataFlowDefine(triggerNumber);
            DataStreamJob job = DataFlowHelper.buildJobByFlowWithParams(flow, params, null);
            JobEngine.submit((Job)job);
            return job.getOwnerId();
        }
        catch (Exception e) {
            String message = StringUtil.getCascadeMessage((Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("ISC_BIZ_EXCEPTION", StringUtil.trim((String)message, (int)8000)), new Object[0]);
        }
    }

    private DataFlowDefine findDataFlowDefine(String triggerNumber) {
        long triggerId = DataFlowHelper.getIdByNumber(triggerNumber);
        DataFlowTrigger task = DataFlowTrigger.get(triggerId);
        DataFlowDefine flow = DataFlowDefine.get(task.getDataFlowId());
        return flow;
    }

    public Map<String, Object> getState(long procInstId) {
        return DataFlowHelper.getState(procInstId);
    }

    public boolean retry(long procInstId) {
        return DataFlowHelper.retry(D.asList((Object[])new Long[]{procInstId})) > 0;
    }

    public void tryTerminate(long procInstId) {
        DataFlowHelper.tryTerminate(procInstId);
    }
}

