/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.license.IscLicenseUtil;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.ds.AbstractDataBatchConsumerApplication;
import kd.isc.iscx.platform.core.res.meta.ds.AbstractDataConsumer;
import kd.isc.iscx.platform.core.res.meta.ds.AbstractDataConsumerApplication;
import kd.isc.iscx.platform.core.res.meta.dt.StructSchema;
import kd.isc.iscx.platform.core.res.meta.dt.StructValue;
import kd.isc.iscx.platform.core.res.runtime.Connector;
import kd.isc.iscx.platform.core.res.runtime.job.AbstractBatchApplication;
import kd.isc.iscx.service.IscDataLoadService;

public class IscDataLoadServiceImpl
implements IscDataLoadService {
    public Map<String, Object> invoke(Map<String, Object> tar, long loadRes, String connector) {
        Connector $tar = Connector.get(connector);
        AbstractDataConsumer consumer = (AbstractDataConsumer)ResourceUtil.getResource(loadRes);
        Object app = consumer.getDataConsumerApplication($tar);
        if (app instanceof AbstractDataConsumerApplication) {
            return this.invoke((AbstractDataConsumerApplication)app, tar, $tar);
        }
        AbstractDataBatchConsumerApplication appx = (AbstractDataBatchConsumerApplication)app;
        List<Map<String, Object>> result = this.invokeX(appx, Collections.singletonList(tar), $tar);
        return result.get(0);
    }

    /*
     * Loose catch block
     */
    private Map<String, Object> invoke(AbstractDataConsumerApplication app, Map<String, Object> tar, Connector $tar) {
        ConnectionManager.pushResLicense((boolean)IscLicenseUtil.resHasLicense((String)"iscx_resource", (long)app.getDataHandler().getId()));
        try {
            try (ConnectionWrapper cn = $tar.getConnection();){
                Map<String, Object> map = this.innerInvoke(cn, app, tar);
                return map;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ConnectionManager.popResLicense();
        }
    }

    private Map<String, Object> innerInvoke(ConnectionWrapper cn, AbstractDataConsumerApplication app, Map<String, Object> tar) {
        StructSchema output = app.getDataHandler().getOutput().getDataType();
        StructSchema input = app.getDataHandler().getInput().getDataType();
        Map<String, Object> result = app.invoke(null, cn, input.narrow(tar));
        return output.narrow(result);
    }

    public List<Map<String, Object>> invokeX(List<Map<String, Object>> _tars, long loadRes, String connector) {
        Connector $tar = Connector.get(connector);
        AbstractDataConsumer consumer = (AbstractDataConsumer)ResourceUtil.getResource(loadRes);
        Object appx = consumer.getDataConsumerApplication($tar);
        if (appx instanceof AbstractDataBatchConsumerApplication) {
            return this.invokeX((AbstractDataBatchConsumerApplication)appx, _tars, $tar);
        }
        return this.loopInvokeX(_tars, (AbstractDataConsumerApplication)appx, $tar);
    }

    /*
     * Loose catch block
     */
    private List<Map<String, Object>> loopInvokeX(List<Map<String, Object>> _tars, AbstractDataConsumerApplication app, Connector $tar) {
        ConnectionManager.pushResLicense((boolean)IscLicenseUtil.resHasLicense((String)"iscx_resource", (long)app.getDataHandler().getId()));
        try {
            try (ConnectionWrapper cn = $tar.getConnection();){
                ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(_tars.size());
                for (Map<String, Object> tar : _tars) {
                    result.add(this.innerInvoke(cn, app, tar));
                }
                ArrayList<Map<String, Object>> arrayList = result;
                return arrayList;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ConnectionManager.popResLicense();
        }
    }

    private List<Map<String, Object>> invokeX(AbstractDataBatchConsumerApplication app, List<Map<String, Object>> _tars, Connector $tar) {
        List<AbstractBatchApplication.Data> batch = this.prepareBatch(app, _tars);
        this.doBatch(app, $tar, batch);
        return this.prepareBatchResult(_tars, batch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBatch(AbstractDataBatchConsumerApplication app, Connector $tar, List<AbstractBatchApplication.Data> batch) {
        ConnectionManager.pushResLicense((boolean)IscLicenseUtil.resHasLicense((String)"iscx_resource", (long)app.getDataHandler().getId()));
        try (ConnectionWrapper cn = $tar.getConnection();){
            app.doBatch(null, cn, batch);
        }
        finally {
            ConnectionManager.popResLicense();
        }
    }

    private List<Map<String, Object>> prepareBatchResult(List<Map<String, Object>> _tars, List<AbstractBatchApplication.Data> batch) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(_tars.size());
        for (AbstractBatchApplication.Data data : batch) {
            list.add(data.getOutput());
        }
        return list;
    }

    private List<AbstractBatchApplication.Data> prepareBatch(AbstractDataBatchConsumerApplication app, List<Map<String, Object>> _tars) {
        StructSchema output = app.getDataHandler().getOutput().getDataType();
        StructSchema input = app.getDataHandler().getInput().getDataType();
        ArrayList<AbstractBatchApplication.Data> batch = new ArrayList<AbstractBatchApplication.Data>(_tars.size());
        for (Map<String, Object> tar : _tars) {
            StructValue in = input.narrow(tar);
            StructValue out = output.narrow(Collections.emptyMap());
            batch.add(new AbstractBatchApplication.Data(null, null, in, out));
        }
        return batch;
    }
}

